<?php
// Copyright (C) 2010-2023 Combodo SARL
//
//   This file is part of iTop.
//
//   iTop is free software; you can redistribute it and/or modify
//   it under the terms of the GNU Affero General Public License as published by
//   the Free Software Foundation, either version 3 of the License, or
//   (at your option) any later version.
//
//   iTop is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU Affero General Public License for more details.
//
//   You should have received a copy of the GNU Affero General Public License
//   along with iTop. If not, see <http://www.gnu.org/licenses/>
/*
* @author ITOMIG GmbH <martin.raenker@itomig.de>

* @copyright     Copyright (C) 2023 Combodo SARL
* @licence	http://opensource.org/licenses/AGPL-3.0
*
*/
Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Relation:impacts/Description' => 'Elemente betroffen von',
	'Relation:impacts/DownStream' => 'Auswirkung ...',
	'Relation:impacts/DownStream+' => 'Elemente betroffen von',
	'Relation:impacts/UpStream' => 'Hängt ab von ...',
	'Relation:impacts/UpStream+' => 'Betroffene Elemente',
	// Legacy entries
	'Relation:depends on/Description' => 'Elemente, von denen dieses Element abhängt.',
	'Relation:depends on/DownStream' => 'Hängt ab von ...',
	'Relation:depends on/UpStream' => 'Wirkt auf ...',
	'Relation:impacts/LoadData' => 'Daten laden',
	'Relation:impacts/FilteredData' => 'Daten sind über den Tab "Grafische Ansicht" gefiltert',
	'Relation:impacts/NoFilteredData' => 'Bitte wählen Sie Objekte im Tab "Grafische Ansicht"',
));


// Dictionnay conventions
// Class:<class_name>
// Class:<class_name>+
// Class:<class_name>/Attribute:<attribute_code>
// Class:<class_name>/Attribute:<attribute_code>+
// Class:<class_name>/Attribute:<attribute_code>/Value:<value>
// Class:<class_name>/Attribute:<attribute_code>/Value:<value>+
// Class:<class_name>/Stimulus:<stimulus_code>
// Class:<class_name>/Stimulus:<stimulus_code>+
// Class:<class_name>/UniquenessRule:<rule_code>
// Class:<class_name>/UniquenessRule:<rule_code>+

//////////////////////////////////////////////////////////////////////
// Classes in 'bizmodel'
//////////////////////////////////////////////////////////////////////
//

// Dictionnay conventions
// Class:<class_name>
// Class:<class_name>+
// Class:<class_name>/Attribute:<attribute_code>
// Class:<class_name>/Attribute:<attribute_code>+
// Class:<class_name>/Attribute:<attribute_code>/Value:<value>
// Class:<class_name>/Attribute:<attribute_code>/Value:<value>+
// Class:<class_name>/Stimulus:<stimulus_code>
// Class:<class_name>/Stimulus:<stimulus_code>+
// Class:<class_name>/UniquenessRule:<rule_code>
// Class:<class_name>/UniquenessRule:<rule_code>+

//////////////////////////////////////////////////////////////////////
// Note: The classes have been grouped by categories: bizmodel
//////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////
// Classes in 'bizmodel'
//////////////////////////////////////////////////////////////////////
//

//
// Class: lnkContactToFunctionalCI
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:lnkContactToFunctionalCI' => 'Verknüpfung Kontakt/FunctionalCI',
	'Class:lnkContactToFunctionalCI+' => '',
	'Class:lnkContactToFunctionalCI/Name' => '%1$s / %2$s',
	'Class:lnkContactToFunctionalCI/Attribute:functionalci_id' => 'FunctionalCI',
	'Class:lnkContactToFunctionalCI/Attribute:functionalci_id+' => '',
	'Class:lnkContactToFunctionalCI/Attribute:functionalci_name' => 'FunctionalCI-Name',
	'Class:lnkContactToFunctionalCI/Attribute:functionalci_name+' => '',
	'Class:lnkContactToFunctionalCI/Attribute:contact_id' => 'Kontakt',
	'Class:lnkContactToFunctionalCI/Attribute:contact_id+' => '',
	'Class:lnkContactToFunctionalCI/Attribute:contact_name' => 'Kontakt-Name',
	'Class:lnkContactToFunctionalCI/Attribute:contact_name+' => '',
));

//
// Class: FunctionalCI
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:FunctionalCI' => 'Funktionales CI',
	'Class:FunctionalCI+' => '',
	'Class:FunctionalCI/Attribute:name' => 'Name',
	'Class:FunctionalCI/Attribute:name+' => '',
	'Class:FunctionalCI/Attribute:description' => 'Beschreibung',
	'Class:FunctionalCI/Attribute:description+' => '',
	'Class:FunctionalCI/Attribute:org_id' => 'Organisation',
	'Class:FunctionalCI/Attribute:org_id+' => '',
	'Class:FunctionalCI/Attribute:organization_name' => 'Organisationsname',
	'Class:FunctionalCI/Attribute:organization_name+' => '',
	'Class:FunctionalCI/Attribute:business_criticity' => 'Business-Kritikalität',
	'Class:FunctionalCI/Attribute:business_criticity+' => '',
	'Class:FunctionalCI/Attribute:business_criticity/Value:high' => 'hoch',
	'Class:FunctionalCI/Attribute:business_criticity/Value:high+' => 'hoch',
	'Class:FunctionalCI/Attribute:business_criticity/Value:low' => 'niedrig',
	'Class:FunctionalCI/Attribute:business_criticity/Value:low+' => 'niedrig',
	'Class:FunctionalCI/Attribute:business_criticity/Value:medium' => 'mittel',
	'Class:FunctionalCI/Attribute:business_criticity/Value:medium+' => 'mittel',
	'Class:FunctionalCI/Attribute:move2production' => 'Go-Live-Datum',
	'Class:FunctionalCI/Attribute:move2production+' => 'Datum, an dem in Produktivbetrieb gegangen wird/wurde',
	'Class:FunctionalCI/Attribute:contacts_list' => 'Kontakte',
	'Class:FunctionalCI/Attribute:contacts_list+' => 'Alle Kontakte dieses CIs',
	'Class:FunctionalCI/Attribute:documents_list' => 'Dokumente',
	'Class:FunctionalCI/Attribute:documents_list+' => 'Alle Dokumente, die mit diesem CI verknüpft sind',
	'Class:FunctionalCI/Attribute:applicationsolution_list' => 'Anwendungslösungen',
	'Class:FunctionalCI/Attribute:applicationsolution_list+' => 'Alle Anwendungslösungen, die von diesem CI abhängen',
	'Class:FunctionalCI/Attribute:softwares_list' => 'Software',
	'Class:FunctionalCI/Attribute:softwares_list+' => 'Software, die auf diesem CI installiert ist',
	'Class:FunctionalCI/Attribute:finalclass' => 'Typ',
	'Class:FunctionalCI/Attribute:finalclass+' => 'Name der instanziierbaren Klasse',
	'Class:FunctionalCI/Tab:OpenedTickets' => 'Offene Tickets',
	'Class:FunctionalCI/Tab:OpenedTickets+' => 'Offene Tickets, die sich auf dieses CI auswirken',
));

//
// Class: PhysicalDevice
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:PhysicalDevice' => 'Physisches Gerät',
	'Class:PhysicalDevice+' => '',
	'Class:PhysicalDevice/ComplementaryName' => '%1$s - %2$s',
	'Class:PhysicalDevice/Attribute:serialnumber' => 'Seriennummer',
	'Class:PhysicalDevice/Attribute:serialnumber+' => '',
	'Class:PhysicalDevice/Attribute:location_id' => 'Standort',
	'Class:PhysicalDevice/Attribute:location_id+' => '',
	'Class:PhysicalDevice/Attribute:location_name' => 'Standortname',
	'Class:PhysicalDevice/Attribute:location_name+' => '',
	'Class:PhysicalDevice/Attribute:status' => 'Status',
	'Class:PhysicalDevice/Attribute:status+' => '',
	'Class:PhysicalDevice/Attribute:status/Value:implementation' => 'Implementierung',
	'Class:PhysicalDevice/Attribute:status/Value:implementation+' => '',
	'Class:PhysicalDevice/Attribute:status/Value:obsolete' => 'Obsolet',
	'Class:PhysicalDevice/Attribute:status/Value:obsolete+' => '',
	'Class:PhysicalDevice/Attribute:status/Value:production' => 'Produktiv',
	'Class:PhysicalDevice/Attribute:status/Value:production+' => '',
	'Class:PhysicalDevice/Attribute:status/Value:stock' => 'Lager',
	'Class:PhysicalDevice/Attribute:status/Value:stock+' => '',
	'Class:PhysicalDevice/Attribute:brand_id' => 'Marke',
	'Class:PhysicalDevice/Attribute:brand_id+' => '',
	'Class:PhysicalDevice/Attribute:brand_name' => 'Markenname',
	'Class:PhysicalDevice/Attribute:brand_name+' => '',
	'Class:PhysicalDevice/Attribute:model_id' => 'Modell',
	'Class:PhysicalDevice/Attribute:model_id+' => '',
	'Class:PhysicalDevice/Attribute:model_name' => 'Modellname',
	'Class:PhysicalDevice/Attribute:model_name+' => '',
	'Class:PhysicalDevice/Attribute:asset_number' => 'Asset-Nummer',
	'Class:PhysicalDevice/Attribute:asset_number+' => '',
	'Class:PhysicalDevice/Attribute:purchase_date' => 'Kaufdatum',
	'Class:PhysicalDevice/Attribute:purchase_date+' => '',
	'Class:PhysicalDevice/Attribute:end_of_warranty' => 'Garantieende',
	'Class:PhysicalDevice/Attribute:end_of_warranty+' => '',
));

//
// Class: Rack
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:Rack' => 'Rack',
	'Class:Rack+' => '',
	'Class:Rack/ComplementaryName' => '%1$s - %2$s',
	'Class:Rack/Attribute:nb_u' => 'Höheneinheiten',
	'Class:Rack/Attribute:nb_u+' => '',
	'Class:Rack/Attribute:device_list' => 'Devices',
	'Class:Rack/Attribute:device_list+' => 'Alle physischen Geräte, die in dieses Rack eingebaut sind',
	'Class:Rack/Attribute:enclosure_list' => 'Enclosures',
	'Class:Rack/Attribute:enclosure_list+' => 'Alle Enclosures in diesem Rack',
));

//
// Class: TelephonyCI
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:TelephonyCI' => 'Telefonie-CI',
	'Class:TelephonyCI+' => '',
	'Class:TelephonyCI/Attribute:phonenumber' => 'Telefonnummer',
	'Class:TelephonyCI/Attribute:phonenumber+' => '',
));

//
// Class: Phone
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:Phone' => 'Telefon',
	'Class:Phone+' => '',
));

//
// Class: MobilePhone
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:MobilePhone' => 'Mobiltelefon',
	'Class:MobilePhone+' => '',
	'Class:MobilePhone/Attribute:imei' => 'IMEI',
	'Class:MobilePhone/Attribute:imei+' => '',
	'Class:MobilePhone/Attribute:hw_pin' => 'Hardware-PIN',
	'Class:MobilePhone/Attribute:hw_pin+' => '',
));

//
// Class: IPPhone
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:IPPhone' => 'IP-Telefon',
	'Class:IPPhone+' => '',
));

//
// Class: Tablet
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:Tablet' => 'Tablet',
	'Class:Tablet+' => '',
));

//
// Class: ConnectableCI
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:ConnectableCI' => 'Verknüpfbares CI',
	'Class:ConnectableCI+' => 'Physisches CI',
	'Class:ConnectableCI/ComplementaryName' => '%1$s - %2$s',
	'Class:ConnectableCI/Attribute:networkdevice_list' => 'Netzwerkgeräte',
	'Class:ConnectableCI/Attribute:networkdevice_list+' => 'Alle Netzwerkgeräte, die mit diesem Gerät verbunden sind',
	'Class:ConnectableCI/Attribute:physicalinterface_list' => 'Netzwerkinterfaces',
	'Class:ConnectableCI/Attribute:physicalinterface_list+' => 'Alle physischen Netzwerkinterfaces des Geräts',
));

//
// Class: DatacenterDevice
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:DatacenterDevice' => 'Datacenter-Gerät',
	'Class:DatacenterDevice+' => '',
	'Class:DatacenterDevice/ComplementaryName' => '%1$s - %2$s',
	'Class:DatacenterDevice/Attribute:rack_id' => 'Rack',
	'Class:DatacenterDevice/Attribute:rack_id+' => '',
	'Class:DatacenterDevice/Attribute:rack_name' => 'Rack-Name',
	'Class:DatacenterDevice/Attribute:rack_name+' => '',
	'Class:DatacenterDevice/Attribute:enclosure_id' => 'Enclosure',
	'Class:DatacenterDevice/Attribute:enclosure_id+' => '',
	'Class:DatacenterDevice/Attribute:enclosure_name' => 'Enclosure-Name',
	'Class:DatacenterDevice/Attribute:enclosure_name+' => '',
	'Class:DatacenterDevice/Attribute:nb_u' => 'Höheneinheiten',
	'Class:DatacenterDevice/Attribute:nb_u+' => '',
	'Class:DatacenterDevice/Attribute:managementip' => 'Management-IP',
	'Class:DatacenterDevice/Attribute:managementip+' => '',
	'Class:DatacenterDevice/Attribute:powerA_id' => 'Strom-A-Quelle',
	'Class:DatacenterDevice/Attribute:powerA_id+' => '',
	'Class:DatacenterDevice/Attribute:powerA_name' => 'Strom-A-Quellenname',
	'Class:DatacenterDevice/Attribute:powerA_name+' => '',
	'Class:DatacenterDevice/Attribute:powerB_id' => 'Strom-B-Quelle',
	'Class:DatacenterDevice/Attribute:powerB_id+' => '',
	'Class:DatacenterDevice/Attribute:powerB_name' => 'Strom-B-Quellenname',
	'Class:DatacenterDevice/Attribute:powerB_name+' => '',
	'Class:DatacenterDevice/Attribute:fiberinterfacelist_list' => 'FC-Ports',
	'Class:DatacenterDevice/Attribute:fiberinterfacelist_list+' => 'Alle Fibre-Channel-Schnittstellen für dieses Gerät',
	'Class:DatacenterDevice/Attribute:san_list' => 'SANs',
	'Class:DatacenterDevice/Attribute:san_list+' => 'Alle mit diesem Gerät verbundenen SAN-Switches',
	'Class:DatacenterDevice/Attribute:redundancy' => 'Redundanz',
	'Class:DatacenterDevice/Attribute:redundancy/count' => 'Das Gerät läuft, wenn mindestens eine der Stromversorgungen (A oder B) läuft.',
	// Unused yet
	'Class:DatacenterDevice/Attribute:redundancy/disabled' => 'Das Gerät läuft, wenn alle seine Stromversorgungen laufen.',
	'Class:DatacenterDevice/Attribute:redundancy/percent' => 'Das Gerät läuft, wenn mindestens %1$s %% seiner Stromversorgungen laufen.',
));

//
// Class: NetworkDevice
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:NetworkDevice' => 'Netzwerk-Gerät',
	'Class:NetworkDevice+' => '',
	'Class:NetworkDevice/ComplementaryName' => '%1$s - %2$s',
	'Class:NetworkDevice/Attribute:networkdevicetype_id' => 'Netzwerktyp',
	'Class:NetworkDevice/Attribute:networkdevicetype_id+' => '',
	'Class:NetworkDevice/Attribute:networkdevicetype_name' => 'Netzwerk-Typname',
	'Class:NetworkDevice/Attribute:networkdevicetype_name+' => '',
	'Class:NetworkDevice/Attribute:connectablecis_list' => 'Geräte',
	'Class:NetworkDevice/Attribute:connectablecis_list+' => 'Alle Geräte, die mit diesem Netzwerkgerät verbunden sind',
	'Class:NetworkDevice/Attribute:iosversion_id' => 'IOS Version',
	'Class:NetworkDevice/Attribute:iosversion_id+' => '',
	'Class:NetworkDevice/Attribute:iosversion_name' => 'IOS-Versionsname',
	'Class:NetworkDevice/Attribute:iosversion_name+' => '',
	'Class:NetworkDevice/Attribute:ram' => 'RAM',
	'Class:NetworkDevice/Attribute:ram+' => '',
));

//
// Class: Server
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:Server' => 'Server',
	'Class:Server+' => '',
	'Class:Server/ComplementaryName' => '%1$s - %2$s',
	'Class:Server/Attribute:osfamily_id' => 'OS Familie',
	'Class:Server/Attribute:osfamily_id+' => '',
	'Class:Server/Attribute:osfamily_name' => 'OS-Familienname',
	'Class:Server/Attribute:osfamily_name+' => '',
	'Class:Server/Attribute:osversion_id' => 'OS Version',
	'Class:Server/Attribute:osversion_id+' => '',
	'Class:Server/Attribute:osversion_name' => 'OS-Versionsname',
	'Class:Server/Attribute:osversion_name+' => '',
	'Class:Server/Attribute:oslicence_id' => 'OS Lizenz',
	'Class:Server/Attribute:oslicence_id+' => '',
	'Class:Server/Attribute:oslicence_name' => 'OS-Lizenzname',
	'Class:Server/Attribute:oslicence_name+' => '',
	'Class:Server/Attribute:cpu' => 'CPU',
	'Class:Server/Attribute:cpu+' => '',
	'Class:Server/Attribute:ram' => 'RAM',
	'Class:Server/Attribute:ram+' => '',
	'Class:Server/Attribute:logicalvolumes_list' => 'Logische Volumes',
	'Class:Server/Attribute:logicalvolumes_list+' => 'Alle mit diesem Server verbundenen logischen Volumes',
));

//
// Class: StorageSystem
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:StorageSystem' => 'Storage-System',
	'Class:StorageSystem+' => '',
	'Class:StorageSystem/ComplementaryName' => '%1$s - %2$s',
	'Class:StorageSystem/Attribute:logicalvolume_list' => 'Logische Volumes',
	'Class:StorageSystem/Attribute:logicalvolume_list+' => 'Alle logischen Volumes in diesem Storage-System',
));

//
// Class: SANSwitch
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:SANSwitch' => 'SAN-Switch',
	'Class:SANSwitch+' => '',
	'Class:SANSwitch/ComplementaryName' => '%1$s - %2$s',
	'Class:SANSwitch/Attribute:datacenterdevice_list' => 'Geräte',
	'Class:SANSwitch/Attribute:datacenterdevice_list+' => 'Alle Geräte, die mit diesem SAN-Switche verbundenen sind',
));

//
// Class: TapeLibrary
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:TapeLibrary' => 'Tape-Library',
	'Class:TapeLibrary+' => '',
	'Class:TapeLibrary/ComplementaryName' => '%1$s - %2$s',
	'Class:TapeLibrary/Attribute:tapes_list' => 'Tapes',
	'Class:TapeLibrary/Attribute:tapes_list+' => 'Alle Tapes in der Tape-Library',
));

//
// Class: NAS
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:NAS' => 'NAS',
	'Class:NAS+' => '',
	'Class:NAS/ComplementaryName' => '%1$s - %2$s',
	'Class:NAS/Attribute:nasfilesystem_list' => 'Dateisysteme',
	'Class:NAS/Attribute:nasfilesystem_list+' => 'Alle Dateisysteme in diesem NAS',
));

//
// Class: PC
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:PC' => 'PC',
	'Class:PC+' => '',
	'Class:PC/ComplementaryName' => '%1$s - %2$s',
	'Class:PC/Attribute:osfamily_id' => 'OS-Familie',
	'Class:PC/Attribute:osfamily_id+' => '',
	'Class:PC/Attribute:osfamily_name' => 'OS-Familienname',
	'Class:PC/Attribute:osfamily_name+' => '',
	'Class:PC/Attribute:osversion_id' => 'OS-Version',
	'Class:PC/Attribute:osversion_id+' => '',
	'Class:PC/Attribute:osversion_name' => 'OS-Versionsname',
	'Class:PC/Attribute:osversion_name+' => '',
	'Class:PC/Attribute:cpu' => 'CPU',
	'Class:PC/Attribute:cpu+' => '',
	'Class:PC/Attribute:ram' => 'RAM',
	'Class:PC/Attribute:ram+' => '',
	'Class:PC/Attribute:type' => 'Typ',
	'Class:PC/Attribute:type+' => '',
	'Class:PC/Attribute:type/Value:desktop' => 'Desktop',
	'Class:PC/Attribute:type/Value:desktop+' => 'Desktop',
	'Class:PC/Attribute:type/Value:laptop' => 'Laptop',
	'Class:PC/Attribute:type/Value:laptop+' => 'Laptop',
));

//
// Class: Printer
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:Printer' => 'Drucker',
	'Class:Printer+' => '',
	'Class:Printer/ComplementaryName' => '%1$s - %2$s',
));

//
// Class: PowerConnection
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:PowerConnection' => 'Stromverbindung',
	'Class:PowerConnection+' => '',
	'Class:PowerConnection/ComplementaryName' => '%1$s - %2$s',
));

//
// Class: PowerSource
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:PowerSource' => 'Stromquelle',
	'Class:PowerSource+' => '',
	'Class:PowerSource/ComplementaryName' => '%1$s - %2$s',
	'Class:PowerSource/Attribute:pdus_list' => 'PDUs',
	'Class:PowerSource/Attribute:pdus_list+' => 'Alle PDUs, die diese Stromquelle nutzen',
));

//
// Class: PDU
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:PDU' => 'PDU',
	'Class:PDU+' => '',
	'Class:PDU/ComplementaryName' => '%1$s - %2$s - %3$s - %4$s',
	'Class:PDU/Attribute:rack_id' => 'Rack',
	'Class:PDU/Attribute:rack_id+' => '',
	'Class:PDU/Attribute:rack_name' => 'Rack-Name',
	'Class:PDU/Attribute:rack_name+' => '',
	'Class:PDU/Attribute:powerstart_id' => 'Eingangs-Stromverbindung',
	'Class:PDU/Attribute:powerstart_id+' => '',
	'Class:PDU/Attribute:powerstart_name' => 'Eingangs-Stromverbindung',
	'Class:PDU/Attribute:powerstart_name+' => '',
));

//
// Class: Peripheral
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:Peripheral' => 'Peripheriegerät',
	'Class:Peripheral+' => '',
	'Class:Peripheral/ComplementaryName' => '%1$s - %2$s',
));

//
// Class: Enclosure
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:Enclosure' => 'Enclosure',
	'Class:Enclosure+' => '',
	'Class:Enclosure/ComplementaryName' => '%1$s - %2$s - %3$s',
	'Class:Enclosure/Attribute:rack_id' => 'Rack',
	'Class:Enclosure/Attribute:rack_id+' => '',
	'Class:Enclosure/Attribute:rack_name' => 'Rack-Name',
	'Class:Enclosure/Attribute:rack_name+' => '',
	'Class:Enclosure/Attribute:nb_u' => 'Höheneinheiten',
	'Class:Enclosure/Attribute:nb_u+' => '',
	'Class:Enclosure/Attribute:device_list' => 'Geräte',
	'Class:Enclosure/Attribute:device_list+' => 'Alle Geräte in diesem Enclosure',
));

//
// Class: ApplicationSolution
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:ApplicationSolution' => 'Anwendungslösung',
	'Class:ApplicationSolution+' => '',
	'Class:ApplicationSolution/Attribute:functionalcis_list' => 'CIs',
	'Class:ApplicationSolution/Attribute:functionalcis_list+' => 'Alle CIs, aus denen diese Anwendungslösung besteht',
	'Class:ApplicationSolution/Attribute:businessprocess_list' => 'Business-Prozesse',
	'Class:ApplicationSolution/Attribute:businessprocess_list+' => 'Alle Geschäftsprozesse, die von dieser Anwendungslösung abhängen',
	'Class:ApplicationSolution/Attribute:status' => 'Status',
	'Class:ApplicationSolution/Attribute:status+' => '',
	'Class:ApplicationSolution/Attribute:status/Value:active' => 'aktiv',
	'Class:ApplicationSolution/Attribute:status/Value:active+' => '',
	'Class:ApplicationSolution/Attribute:status/Value:inactive' => 'inaktiv',
	'Class:ApplicationSolution/Attribute:status/Value:inactive+' => '',
	'Class:ApplicationSolution/Attribute:redundancy' => 'Auswirkungsanalyse: Redundanz-Einstellungen',
	'Class:ApplicationSolution/Attribute:redundancy/disabled' => 'Die Lösung läuft, wenn alle ihre CIs laufen.',
	'Class:ApplicationSolution/Attribute:redundancy/count' => 'Die Lösung läuft, wenn mindestens %1$s CI(s) laufen.',
	'Class:ApplicationSolution/Attribute:redundancy/percent' => 'Die Lösung läuft, wenn mindestens %1$s %% der CIs laufen.',
));

//
// Class: BusinessProcess
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:BusinessProcess' => 'Business-Prozess',
	'Class:BusinessProcess+' => '',
	'Class:BusinessProcess/Attribute:applicationsolutions_list' => 'Anwendungslösungen',
	'Class:BusinessProcess/Attribute:applicationsolutions_list+' => 'Alle Anwendungslösungen, die sich auf diesen Geschäftsprozess auswirken',
	'Class:BusinessProcess/Attribute:status' => 'Status',
	'Class:BusinessProcess/Attribute:status+' => '',
	'Class:BusinessProcess/Attribute:status/Value:active' => 'aktiv',
	'Class:BusinessProcess/Attribute:status/Value:active+' => '',
	'Class:BusinessProcess/Attribute:status/Value:inactive' => 'inaktiv',
	'Class:BusinessProcess/Attribute:status/Value:inactive+' => '',
));

//
// Class: SoftwareInstance
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:SoftwareInstance' => 'Software-Instanz',
	'Class:SoftwareInstance+' => '',
	'Class:SoftwareInstance/Attribute:system_id' => 'System',
	'Class:SoftwareInstance/Attribute:system_id+' => '',
	'Class:SoftwareInstance/Attribute:system_name' => 'Systemname',
	'Class:SoftwareInstance/Attribute:system_name+' => '',
	'Class:SoftwareInstance/Attribute:software_id' => 'Software',
	'Class:SoftwareInstance/Attribute:software_id+' => '',
	'Class:SoftwareInstance/Attribute:software_name' => 'Software',
	'Class:SoftwareInstance/Attribute:software_name+' => '',
	'Class:SoftwareInstance/Attribute:softwarelicence_id' => 'Software-Lizenz',
	'Class:SoftwareInstance/Attribute:softwarelicence_id+' => '',
	'Class:SoftwareInstance/Attribute:softwarelicence_name' => 'Software-Lizenzname',
	'Class:SoftwareInstance/Attribute:softwarelicence_name+' => '',
	'Class:SoftwareInstance/Attribute:path' => 'Pfad',
	'Class:SoftwareInstance/Attribute:path+' => '',
	'Class:SoftwareInstance/Attribute:status' => 'Status',
	'Class:SoftwareInstance/Attribute:status+' => '',
	'Class:SoftwareInstance/Attribute:status/Value:active' => 'Aktiv',
	'Class:SoftwareInstance/Attribute:status/Value:active+' => '',
	'Class:SoftwareInstance/Attribute:status/Value:inactive' => 'Inaktiv',
	'Class:SoftwareInstance/Attribute:status/Value:inactive+' => '',
));

//
// Class: Middleware
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:Middleware' => 'Middleware',
	'Class:Middleware+' => '',
	'Class:Middleware/Attribute:middlewareinstance_list' => 'Middleware-Instanzen',
	'Class:Middleware/Attribute:middlewareinstance_list+' => 'Alle Middleware-Instanzen, die von dieser Middleware bereitgestellt werden',
));

//
// Class: DBServer
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:DBServer' => 'DB Server',
	'Class:DBServer+' => '',
	'Class:DBServer/Attribute:dbschema_list' => 'DB Schemata',
	'Class:DBServer/Attribute:dbschema_list+' => 'Alle Datenbankschemata für diesen DB-Server',
));

//
// Class: WebServer
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:WebServer' => 'Web Server',
	'Class:WebServer+' => '',
	'Class:WebServer/Attribute:webapp_list' => 'Webapplikationen',
	'Class:WebServer/Attribute:webapp_list+' => 'Alle auf diesem Webserver verfügbaren Webanwendungen',
));

//
// Class: PCSoftware
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:PCSoftware' => 'PC-Software',
	'Class:PCSoftware+' => '',
));

//
// Class: OtherSoftware
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:OtherSoftware' => 'Andere Software',
	'Class:OtherSoftware+' => '',
));

//
// Class: MiddlewareInstance
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:MiddlewareInstance' => 'Middleware-Instanz',
	'Class:MiddlewareInstance+' => '',
	'Class:MiddlewareInstance/ComplementaryName' => '%1$s - %2$s',
	'Class:MiddlewareInstance/Attribute:middleware_id' => 'Middleware',
	'Class:MiddlewareInstance/Attribute:middleware_id+' => '',
	'Class:MiddlewareInstance/Attribute:middleware_name' => 'Middleware-Name',
	'Class:MiddlewareInstance/Attribute:middleware_name+' => '',
));

//
// Class: DatabaseSchema
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:DatabaseSchema' => 'Datenbank-Schema',
	'Class:DatabaseSchema+' => '',
	'Class:DatabaseSchema/ComplementaryName' => '%1$s - %2$s',
	'Class:DatabaseSchema/Attribute:dbserver_id' => 'DB-Server',
	'Class:DatabaseSchema/Attribute:dbserver_id+' => '',
	'Class:DatabaseSchema/Attribute:dbserver_name' => 'DB-Servername',
	'Class:DatabaseSchema/Attribute:dbserver_name+' => '',
));

//
// Class: WebApplication
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:WebApplication' => 'Webapplikation',
	'Class:WebApplication+' => '',
	'Class:WebApplication/ComplementaryName' => '%1$s - %2$s',
	'Class:WebApplication/Attribute:webserver_id' => 'Webserver',
	'Class:WebApplication/Attribute:webserver_id+' => '',
	'Class:WebApplication/Attribute:webserver_name' => 'Webservername',
	'Class:WebApplication/Attribute:webserver_name+' => '',
	'Class:WebApplication/Attribute:url' => 'URL',
	'Class:WebApplication/Attribute:url+' => '',
));


//
// Class: VirtualDevice
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:VirtualDevice' => 'Virtuelles Gerät',
	'Class:VirtualDevice+' => '',
	'Class:VirtualDevice/Attribute:status' => 'Status',
	'Class:VirtualDevice/Attribute:status+' => '',
	'Class:VirtualDevice/Attribute:status/Value:implementation' => 'Implementierung',
	'Class:VirtualDevice/Attribute:status/Value:implementation+' => '',
	'Class:VirtualDevice/Attribute:status/Value:obsolete' => 'Obsolet',
	'Class:VirtualDevice/Attribute:status/Value:obsolete+' => '',
	'Class:VirtualDevice/Attribute:status/Value:production' => 'Produktiv',
	'Class:VirtualDevice/Attribute:status/Value:production+' => '',
	'Class:VirtualDevice/Attribute:status/Value:stock' => 'Lager',
	'Class:VirtualDevice/Attribute:status/Value:stock+' => '',
	'Class:VirtualDevice/Attribute:logicalvolumes_list' => 'Logische Volumes',
	'Class:VirtualDevice/Attribute:logicalvolumes_list+' => 'Alle von diesem Gerät verwendeten logischen Volumes',
));

//
// Class: VirtualHost
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:VirtualHost' => 'Host',
	'Class:VirtualHost+' => '',
	'Class:VirtualHost/Attribute:virtualmachine_list' => 'Virtuelle Maschinen',
	'Class:VirtualHost/Attribute:virtualmachine_list+' => 'Alle virtuellen Maschinen, die von diesem Host gehostet werden',
));

//
// Class: Hypervisor
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:Hypervisor' => 'Hypervisor',
	'Class:Hypervisor+' => '',
	'Class:Hypervisor/Attribute:farm_id' => 'Farm',
	'Class:Hypervisor/Attribute:farm_id+' => '',
	'Class:Hypervisor/Attribute:farm_name' => 'Farmname',
	'Class:Hypervisor/Attribute:farm_name+' => '',
	'Class:Hypervisor/Attribute:server_id' => 'Server',
	'Class:Hypervisor/Attribute:server_id+' => '',
	'Class:Hypervisor/Attribute:server_name' => 'Servername',
	'Class:Hypervisor/Attribute:server_name+' => '',
));

//
// Class: Farm
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:Farm' => 'Farm',
	'Class:Farm+' => '',
	'Class:Farm/Attribute:hypervisor_list' => 'Hypervisoren',
	'Class:Farm/Attribute:hypervisor_list+' => 'Alle Hypervisoren, aus denen diese Farm besteht',
	'Class:Farm/Attribute:redundancy' => 'Hochverfügbarkeit',
	'Class:Farm/Attribute:redundancy/disabled' => 'Die Farm läuft, wenn alle Hypervisoren laufen.',
	'Class:Farm/Attribute:redundancy/count' => 'Die Farm läuft, wenn mindestens %1$s Hypervisor(en) läuft/laufen.',
	'Class:Farm/Attribute:redundancy/percent' => 'Die Farm läuft, wenn mindestens %1$s %% der Hypervisoren laufen.',
));

//
// Class: VirtualMachine
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:VirtualMachine' => 'Virtuelle Maschine',
	'Class:VirtualMachine+' => '',
	'Class:VirtualMachine/ComplementaryName' => '%1$s - %2$s',
	'Class:VirtualMachine/Attribute:virtualhost_id' => 'Host',
	'Class:VirtualMachine/Attribute:virtualhost_id+' => '',
	'Class:VirtualMachine/Attribute:virtualhost_name' => 'Hostname',
	'Class:VirtualMachine/Attribute:virtualhost_name+' => '',
	'Class:VirtualMachine/Attribute:osfamily_id' => 'OS-Familie',
	'Class:VirtualMachine/Attribute:osfamily_id+' => '',
	'Class:VirtualMachine/Attribute:osfamily_name' => 'OS-Familienname',
	'Class:VirtualMachine/Attribute:osfamily_name+' => '',
	'Class:VirtualMachine/Attribute:osversion_id' => 'OS-Version',
	'Class:VirtualMachine/Attribute:osversion_id+' => '',
	'Class:VirtualMachine/Attribute:osversion_name' => 'OS-Versionsname',
	'Class:VirtualMachine/Attribute:osversion_name+' => '',
	'Class:VirtualMachine/Attribute:oslicence_id' => 'OS-Lizenz',
	'Class:VirtualMachine/Attribute:oslicence_id+' => '',
	'Class:VirtualMachine/Attribute:oslicence_name' => 'OS-Lizenzname',
	'Class:VirtualMachine/Attribute:oslicence_name+' => '',
	'Class:VirtualMachine/Attribute:cpu' => 'CPU',
	'Class:VirtualMachine/Attribute:cpu+' => '',
	'Class:VirtualMachine/Attribute:ram' => 'RAM',
	'Class:VirtualMachine/Attribute:ram+' => '',
	'Class:VirtualMachine/Attribute:managementip' => 'Management-IP',
	'Class:VirtualMachine/Attribute:managementip+' => '',
	'Class:VirtualMachine/Attribute:logicalinterface_list' => 'Netzwerk-Interfaces',
	'Class:VirtualMachine/Attribute:logicalinterface_list+' => 'Alle logischen Netzwerk-Interfaces',
));

//
// Class: LogicalVolume
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:LogicalVolume' => 'Logisches Volume',
	'Class:LogicalVolume+' => '',
	'Class:LogicalVolume/Attribute:name' => 'Name',
	'Class:LogicalVolume/Attribute:name+' => '',
	'Class:LogicalVolume/Attribute:lun_id' => 'LUN ID',
	'Class:LogicalVolume/Attribute:lun_id+' => '',
	'Class:LogicalVolume/Attribute:description' => 'Beschreibung',
	'Class:LogicalVolume/Attribute:description+' => '',
	'Class:LogicalVolume/Attribute:raid_level' => 'Raid-Level',
	'Class:LogicalVolume/Attribute:raid_level+' => '',
	'Class:LogicalVolume/Attribute:size' => 'Größe',
	'Class:LogicalVolume/Attribute:size+' => '',
	'Class:LogicalVolume/Attribute:storagesystem_id' => 'Storage-System',
	'Class:LogicalVolume/Attribute:storagesystem_id+' => '',
	'Class:LogicalVolume/Attribute:storagesystem_name' => 'Storage-Systemname',
	'Class:LogicalVolume/Attribute:storagesystem_name+' => '',
	'Class:LogicalVolume/Attribute:servers_list' => 'Server',
	'Class:LogicalVolume/Attribute:servers_list+' => 'Alle Server, die dieses Volume verwenden',
	'Class:LogicalVolume/Attribute:virtualdevices_list' => 'Virtuelle Geräte',
	'Class:LogicalVolume/Attribute:virtualdevices_list+' => 'Alle virtuellen Maschinen, die dieses Volume verwenden',
));

//
// Class: lnkServerToVolume
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:lnkServerToVolume' => 'Verknüpfung Server/Volume',
	'Class:lnkServerToVolume+' => '',
	'Class:lnkServerToVolume/Name' => '%1$s / %2$s',
	'Class:lnkServerToVolume/Attribute:volume_id' => 'Volume',
	'Class:lnkServerToVolume/Attribute:volume_id+' => '',
	'Class:lnkServerToVolume/Attribute:volume_name' => 'Volume-Name',
	'Class:lnkServerToVolume/Attribute:volume_name+' => '',
	'Class:lnkServerToVolume/Attribute:server_id' => 'Server',
	'Class:lnkServerToVolume/Attribute:server_id+' => '',
	'Class:lnkServerToVolume/Attribute:server_name' => 'Server-Name',
	'Class:lnkServerToVolume/Attribute:server_name+' => '',
	'Class:lnkServerToVolume/Attribute:size_used' => 'Größe verwendet',
	'Class:lnkServerToVolume/Attribute:size_used+' => '',
));

//
// Class: lnkVirtualDeviceToVolume
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:lnkVirtualDeviceToVolume' => 'Verknüpfung Virtuelles Gerät/Volume',
	'Class:lnkVirtualDeviceToVolume+' => '',
	'Class:lnkVirtualDeviceToVolume/Name' => '%1$s / %2$s',
	'Class:lnkVirtualDeviceToVolume/Attribute:volume_id' => 'Volume',
	'Class:lnkVirtualDeviceToVolume/Attribute:volume_id+' => '',
	'Class:lnkVirtualDeviceToVolume/Attribute:volume_name' => 'Volume-Name',
	'Class:lnkVirtualDeviceToVolume/Attribute:volume_name+' => '',
	'Class:lnkVirtualDeviceToVolume/Attribute:virtualdevice_id' => 'Virtuelles Gerät',
	'Class:lnkVirtualDeviceToVolume/Attribute:virtualdevice_id+' => '',
	'Class:lnkVirtualDeviceToVolume/Attribute:virtualdevice_name' => 'Virtuelles Gerät-Name',
	'Class:lnkVirtualDeviceToVolume/Attribute:virtualdevice_name+' => '',
	'Class:lnkVirtualDeviceToVolume/Attribute:size_used' => 'Größe verwendet',
	'Class:lnkVirtualDeviceToVolume/Attribute:size_used+' => '',
));

//
// Class: lnkSanToDatacenterDevice
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:lnkSanToDatacenterDevice' => 'Verknüpfung SAN/Datacenter-Gerät',
	'Class:lnkSanToDatacenterDevice+' => '',
	'Class:lnkSanToDatacenterDevice/Name' => '%1$s / %2$s',
	'Class:lnkSanToDatacenterDevice/Attribute:san_id' => 'SAN-Switch',
	'Class:lnkSanToDatacenterDevice/Attribute:san_id+' => '',
	'Class:lnkSanToDatacenterDevice/Attribute:san_name' => 'SAN-Switch-Name',
	'Class:lnkSanToDatacenterDevice/Attribute:san_name+' => '',
	'Class:lnkSanToDatacenterDevice/Attribute:datacenterdevice_id' => 'Gerät',
	'Class:lnkSanToDatacenterDevice/Attribute:datacenterdevice_id+' => '',
	'Class:lnkSanToDatacenterDevice/Attribute:datacenterdevice_name' => 'Gerät-Name',
	'Class:lnkSanToDatacenterDevice/Attribute:datacenterdevice_name+' => '',
	'Class:lnkSanToDatacenterDevice/Attribute:san_port' => 'SAN FC',
	'Class:lnkSanToDatacenterDevice/Attribute:san_port+' => '',
	'Class:lnkSanToDatacenterDevice/Attribute:datacenterdevice_port' => 'Gerät FC',
	'Class:lnkSanToDatacenterDevice/Attribute:datacenterdevice_port+' => '',
));

//
// Class: Tape
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:Tape' => 'Tape',
	'Class:Tape+' => '',
	'Class:Tape/Attribute:name' => 'Name',
	'Class:Tape/Attribute:name+' => '',
	'Class:Tape/Attribute:description' => 'Beschreibung',
	'Class:Tape/Attribute:description+' => '',
	'Class:Tape/Attribute:size' => 'Größe',
	'Class:Tape/Attribute:size+' => '',
	'Class:Tape/Attribute:tapelibrary_id' => 'Tape-Library',
	'Class:Tape/Attribute:tapelibrary_id+' => '',
	'Class:Tape/Attribute:tapelibrary_name' => 'Tape-Library-Name',
	'Class:Tape/Attribute:tapelibrary_name+' => '',
));

//
// Class: NASFileSystem
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:NASFileSystem' => 'NAS-Dateisystem',
	'Class:NASFileSystem+' => '',
	'Class:NASFileSystem/Attribute:name' => 'Name',
	'Class:NASFileSystem/Attribute:name+' => '',
	'Class:NASFileSystem/Attribute:description' => 'Beschreibung',
	'Class:NASFileSystem/Attribute:description+' => '',
	'Class:NASFileSystem/Attribute:raid_level' => 'Raid-Level',
	'Class:NASFileSystem/Attribute:raid_level+' => '',
	'Class:NASFileSystem/Attribute:size' => 'Größe',
	'Class:NASFileSystem/Attribute:size+' => '',
	'Class:NASFileSystem/Attribute:nas_id' => 'NAS',
	'Class:NASFileSystem/Attribute:nas_id+' => '',
	'Class:NASFileSystem/Attribute:nas_name' => 'NAS-Name',
	'Class:NASFileSystem/Attribute:nas_name+' => '',
));

//
// Class: Software
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:Software' => 'Software',
	'Class:Software+' => '',
	'Class:Software/ComplementaryName' => '%1$s - %2$s',
	'Class:Software/Attribute:name' => 'Name',
	'Class:Software/Attribute:name+' => '',
	'Class:Software/Attribute:vendor' => 'Hersteller',
	'Class:Software/Attribute:vendor+' => '',
	'Class:Software/Attribute:version' => 'Version',
	'Class:Software/Attribute:version+' => '',
	'Class:Software/Attribute:documents_list' => 'Dokumente',
	'Class:Software/Attribute:documents_list+' => 'Alle mit dieser Software verknüpften Dokumente',
	'Class:Software/Attribute:type' => 'Typ',
	'Class:Software/Attribute:type+' => '',
	'Class:Software/Attribute:type/Value:DBServer' => 'DB-Server',
	'Class:Software/Attribute:type/Value:DBServer+' => '',
	'Class:Software/Attribute:type/Value:Middleware' => 'Middleware',
	'Class:Software/Attribute:type/Value:Middleware+' => '',
	'Class:Software/Attribute:type/Value:OtherSoftware' => 'Andere Software',
	'Class:Software/Attribute:type/Value:OtherSoftware+' => '',
	'Class:Software/Attribute:type/Value:PCSoftware' => 'PC-Software',
	'Class:Software/Attribute:type/Value:PCSoftware+' => '',
	'Class:Software/Attribute:type/Value:WebServer' => 'Webserver',
	'Class:Software/Attribute:type/Value:WebServer+' => '',
	'Class:Software/Attribute:softwareinstance_list' => 'Software-Instanzen',
	'Class:Software/Attribute:softwareinstance_list+' => 'Alle Software-Instanzen für diese Software',
	'Class:Software/Attribute:softwarepatch_list' => 'Software-Patches',
	'Class:Software/Attribute:softwarepatch_list+' => 'Alle Software-Patches für diese Software',
	'Class:Software/Attribute:softwarelicence_list' => 'Softwarelizenzen',
	'Class:Software/Attribute:softwarelicence_list+' => 'Alle Lizenzen für diese Software',
));

//
// Class: Patch
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:Patch' => 'Patch',
	'Class:Patch+' => '',
	'Class:Patch/Attribute:name' => 'Name',
	'Class:Patch/Attribute:name+' => '',
	'Class:Patch/Attribute:documents_list' => 'Dokumente',
	'Class:Patch/Attribute:documents_list+' => 'Alle Dokumente, die mit diesem Patch verknüpft sind',
	'Class:Patch/Attribute:description' => 'Beschreibung',
	'Class:Patch/Attribute:description+' => '',
	'Class:Patch/Attribute:finalclass' => 'Typ',
	'Class:Patch/Attribute:finalclass+' => '',
));

//
// Class: OSPatch
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:OSPatch' => 'OS-Patch',
	'Class:OSPatch+' => '',
	'Class:OSPatch/Attribute:functionalcis_list' => 'Geräte',
	'Class:OSPatch/Attribute:functionalcis_list+' => 'Alle Systeme, auf denen dieser Patch installiert ist',
	'Class:OSPatch/Attribute:osversion_id' => 'OS Version',
	'Class:OSPatch/Attribute:osversion_id+' => '',
	'Class:OSPatch/Attribute:osversion_name' => 'OS-Versionsname',
	'Class:OSPatch/Attribute:osversion_name+' => '',
));

//
// Class: SoftwarePatch
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:SoftwarePatch' => 'Software-Patch',
	'Class:SoftwarePatch+' => '',
	'Class:SoftwarePatch/Attribute:software_id' => 'Software',
	'Class:SoftwarePatch/Attribute:software_id+' => '',
	'Class:SoftwarePatch/Attribute:software_name' => 'Software-Name',
	'Class:SoftwarePatch/Attribute:software_name+' => '',
	'Class:SoftwarePatch/Attribute:softwareinstances_list' => 'Software-Instanzen',
	'Class:SoftwarePatch/Attribute:softwareinstances_list+' => 'Alle Systeme, auf denen dieser Software-Patch installiert ist',
));

//
// Class: Licence
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:Licence' => 'Lizenz',
	'Class:Licence+' => '',
	'Class:Licence/Attribute:name' => 'Name',
	'Class:Licence/Attribute:name+' => '',
	'Class:Licence/Attribute:documents_list' => 'Dokumente',
	'Class:Licence/Attribute:documents_list+' => 'Alle mit dieser Lizenz verknüpften Dokumente',
	'Class:Licence/Attribute:org_id' => 'Besitzer',
	'Class:Licence/Attribute:org_id+' => '',
	'Class:Licence/Attribute:organization_name' => 'Organisationsname',
	'Class:Licence/Attribute:organization_name+' => '',
	'Class:Licence/Attribute:usage_limit' => 'Nutzungseinschränkungen',
	'Class:Licence/Attribute:usage_limit+' => '',
	'Class:Licence/Attribute:description' => 'Beschreibung',
	'Class:Licence/Attribute:description+' => '',
	'Class:Licence/Attribute:start_date' => 'Startdatum',
	'Class:Licence/Attribute:start_date+' => '',
	'Class:Licence/Attribute:end_date' => 'Enddatum',
	'Class:Licence/Attribute:end_date+' => '',
	'Class:Licence/Attribute:licence_key' => 'Schlüssel',
	'Class:Licence/Attribute:licence_key+' => '',
	'Class:Licence/Attribute:perpetual' => 'unbefristet',
	'Class:Licence/Attribute:perpetual+' => '',
	'Class:Licence/Attribute:perpetual/Value:no' => 'nein',
	'Class:Licence/Attribute:perpetual/Value:no+' => 'nein',
	'Class:Licence/Attribute:perpetual/Value:yes' => 'ja',
	'Class:Licence/Attribute:perpetual/Value:yes+' => 'ja',
	'Class:Licence/Attribute:finalclass' => 'Typ',
	'Class:Licence/Attribute:finalclass+' => 'Name der instanziierbaren Klasse',
));

//
// Class: OSLicence
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:OSLicence' => 'OS-Lizenz',
	'Class:OSLicence+' => '',
	'Class:OSLicence/ComplementaryName' => '%1$s - %2$s',
	'Class:OSLicence/Attribute:osversion_id' => 'OS-Version',
	'Class:OSLicence/Attribute:osversion_id+' => '',
	'Class:OSLicence/Attribute:osversion_name' => 'OS-Versionsname',
	'Class:OSLicence/Attribute:osversion_name+' => '',
	'Class:OSLicence/Attribute:virtualmachines_list' => 'Virtuelle Maschinen',
	'Class:OSLicence/Attribute:virtualmachines_list+' => 'Alle virtuellen Maschinen, auf denen diese Lizenz verwendet wird',
	'Class:OSLicence/Attribute:servers_list' => 'Server',
	'Class:OSLicence/Attribute:servers_list+' => 'Alle Server, auf denen diese Lizenz verwendet wird',
));

//
// Class: SoftwareLicence
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:SoftwareLicence' => 'Software-Lizenz',
	'Class:SoftwareLicence+' => '',
	'Class:SoftwareLicence/ComplementaryName' => '%1$s - %2$s',
	'Class:SoftwareLicence/Attribute:software_id' => 'Software',
	'Class:SoftwareLicence/Attribute:software_id+' => '',
	'Class:SoftwareLicence/Attribute:software_name' => 'Software-Name',
	'Class:SoftwareLicence/Attribute:software_name+' => '',
	'Class:SoftwareLicence/Attribute:softwareinstance_list' => 'Software-Instanzen',
	'Class:SoftwareLicence/Attribute:softwareinstance_list+' => 'Alle Systeme, in denen diese Lizenz verwendet wird',
));

//
// Class: lnkDocumentToLicence
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:lnkDocumentToLicence' => 'Verknüpfung Dokument/Lizenz',
	'Class:lnkDocumentToLicence+' => '',
	'Class:lnkDocumentToLicence/Name' => '%1$s / %2$s',
	'Class:lnkDocumentToLicence/Attribute:licence_id' => 'Lizenz',
	'Class:lnkDocumentToLicence/Attribute:licence_id+' => '',
	'Class:lnkDocumentToLicence/Attribute:licence_name' => 'Lizenz-Name',
	'Class:lnkDocumentToLicence/Attribute:licence_name+' => '',
	'Class:lnkDocumentToLicence/Attribute:document_id' => 'Dokument',
	'Class:lnkDocumentToLicence/Attribute:document_id+' => '',
	'Class:lnkDocumentToLicence/Attribute:document_name' => 'Dokumenten-Name',
	'Class:lnkDocumentToLicence/Attribute:document_name+' => '',
));

//
// Class: OSVersion
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:OSVersion' => 'OS-Version',
	'Class:OSVersion+' => '',
	'Class:OSVersion/Attribute:osfamily_id' => 'OS-Familie',
	'Class:OSVersion/Attribute:osfamily_id+' => '',
	'Class:OSVersion/Attribute:osfamily_name' => 'OS-Familienname',
	'Class:OSVersion/Attribute:osfamily_name+' => '',
));

//
// Class: OSFamily
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:OSFamily' => 'OS-Familie',
	'Class:OSFamily+' => '',
));

//
// Class: Brand
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:Brand' => 'Marke',
	'Class:Brand+' => '',
	'Class:Brand/Attribute:physicaldevices_list' => 'Physische Geräte',
	'Class:Brand/Attribute:physicaldevices_list+' => 'Alle physischen Geräte dieser Marke',
	'Class:Brand/UniquenessRule:name+' => 'Der Name muss eindeutig sein',
	'Class:Brand/UniquenessRule:name' => 'Diese Marke existiert bereits',
));

//
// Class: Model
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:Model' => 'Modell',
	'Class:Model+' => '',
	'Class:Model/ComplementaryName' => '%1$s - %2$s',
	'Class:Model/Attribute:brand_id' => 'Marke',
	'Class:Model/Attribute:brand_id+' => '',
	'Class:Model/Attribute:brand_name' => 'Markenname',
	'Class:Model/Attribute:brand_name+' => '',
	'Class:Model/Attribute:type' => 'Gerätetyp',
	'Class:Model/Attribute:type+' => '',
	'Class:Model/Attribute:type/Value:PowerSource' => 'Stromquelle',
	'Class:Model/Attribute:type/Value:PowerSource+' => 'Stromquelle',
	'Class:Model/Attribute:type/Value:DiskArray' => 'Plattenarray',
	'Class:Model/Attribute:type/Value:DiskArray+' => 'Plattenarray',
	'Class:Model/Attribute:type/Value:Enclosure' => 'Enclosure',
	'Class:Model/Attribute:type/Value:Enclosure+' => 'Enclosure',
	'Class:Model/Attribute:type/Value:IPPhone' => 'IP-Telefon',
	'Class:Model/Attribute:type/Value:IPPhone+' => 'IP-Telefon',
	'Class:Model/Attribute:type/Value:MobilePhone' => 'Mobiltelefon',
	'Class:Model/Attribute:type/Value:MobilePhone+' => 'Mobiltelefon',
	'Class:Model/Attribute:type/Value:NAS' => 'NAS',
	'Class:Model/Attribute:type/Value:NAS+' => 'NAS',
	'Class:Model/Attribute:type/Value:NetworkDevice' => 'Netzwerkgerät',
	'Class:Model/Attribute:type/Value:NetworkDevice+' => 'Netzwerkgerät',
	'Class:Model/Attribute:type/Value:PC' => 'PC',
	'Class:Model/Attribute:type/Value:PC+' => 'PC',
	'Class:Model/Attribute:type/Value:PDU' => 'PDU',
	'Class:Model/Attribute:type/Value:PDU+' => 'PDU',
	'Class:Model/Attribute:type/Value:Peripheral' => 'Peripheriegeräte',
	'Class:Model/Attribute:type/Value:Peripheral+' => 'Peripheriegeräte',
	'Class:Model/Attribute:type/Value:Printer' => 'Drucker',
	'Class:Model/Attribute:type/Value:Printer+' => 'Drucker',
	'Class:Model/Attribute:type/Value:Rack' => 'Rack',
	'Class:Model/Attribute:type/Value:Rack+' => 'Rack',
	'Class:Model/Attribute:type/Value:SANSwitch' => 'SAN-Switch',
	'Class:Model/Attribute:type/Value:SANSwitch+' => 'SAN-Switch',
	'Class:Model/Attribute:type/Value:Server' => 'Server',
	'Class:Model/Attribute:type/Value:Server+' => 'Server',
	'Class:Model/Attribute:type/Value:StorageSystem' => 'Storage-System',
	'Class:Model/Attribute:type/Value:StorageSystem+' => 'Storage-System',
	'Class:Model/Attribute:type/Value:Tablet' => 'Tablet',
	'Class:Model/Attribute:type/Value:Tablet+' => 'Tablet',
	'Class:Model/Attribute:type/Value:TapeLibrary' => 'Tape-Library',
	'Class:Model/Attribute:type/Value:TapeLibrary+' => 'Tape-Library',
	'Class:Model/Attribute:type/Value:Phone' => 'Telefon',
	'Class:Model/Attribute:type/Value:Phone+' => 'Telefon',
	'Class:Model/Attribute:physicaldevices_list' => 'Physische Geräte',
	'Class:Model/Attribute:physicaldevices_list+' => 'Alle physischen Geräte, die diesem Modell entsprechen',
	'Class:Model/UniquenessRule:name_brand+' => 'Der Modellname für eine Marke muss eindeutig sein',
	'Class:Model/UniquenessRule:name_brand' => 'Es existiert bereits ein Modell mit diesem Namen für diese Marke',
));

//
// Class: NetworkDeviceType
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:NetworkDeviceType' => 'Netzwerkgerätetyp',
	'Class:NetworkDeviceType+' => '',
	'Class:NetworkDeviceType/Attribute:networkdevicesdevices_list' => 'Netzwerkgeräte',
	'Class:NetworkDeviceType/Attribute:networkdevicesdevices_list+' => 'Alle Netzwerkgeräte, die diesem Typ entsprechen',
));

//
// Class: IOSVersion
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:IOSVersion' => 'IOS-Version',
	'Class:IOSVersion+' => '',
	'Class:IOSVersion/Attribute:brand_id' => 'Marke',
	'Class:IOSVersion/Attribute:brand_id+' => '',
	'Class:IOSVersion/Attribute:brand_name' => 'Markenname',
	'Class:IOSVersion/Attribute:brand_name+' => '',
));

//
// Class: lnkDocumentToPatch
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:lnkDocumentToPatch' => 'Verknüpfung Dokument/Patch',
	'Class:lnkDocumentToPatch+' => '',
	'Class:lnkDocumentToPatch/Name' => '%1$s / %2$s',
	'Class:lnkDocumentToPatch/Attribute:patch_id' => 'Patch',
	'Class:lnkDocumentToPatch/Attribute:patch_id+' => '',
	'Class:lnkDocumentToPatch/Attribute:patch_name' => 'Patch-Name',
	'Class:lnkDocumentToPatch/Attribute:patch_name+' => '',
	'Class:lnkDocumentToPatch/Attribute:document_id' => 'Dokument',
	'Class:lnkDocumentToPatch/Attribute:document_id+' => '',
	'Class:lnkDocumentToPatch/Attribute:document_name' => 'Dokument-Name',
	'Class:lnkDocumentToPatch/Attribute:document_name+' => '',
));

//
// Class: lnkSoftwareInstanceToSoftwarePatch
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:lnkSoftwareInstanceToSoftwarePatch' => 'Verknüpfung Software-Instanz/Softeware-Patch',
	'Class:lnkSoftwareInstanceToSoftwarePatch+' => '',
	'Class:lnkSoftwareInstanceToSoftwarePatch/Name' => '%1$s / %2$s',
	'Class:lnkSoftwareInstanceToSoftwarePatch/Attribute:softwarepatch_id' => 'Software-Patch',
	'Class:lnkSoftwareInstanceToSoftwarePatch/Attribute:softwarepatch_id+' => '',
	'Class:lnkSoftwareInstanceToSoftwarePatch/Attribute:softwarepatch_name' => 'Software-Patch-Name',
	'Class:lnkSoftwareInstanceToSoftwarePatch/Attribute:softwarepatch_name+' => '',
	'Class:lnkSoftwareInstanceToSoftwarePatch/Attribute:softwareinstance_id' => 'Software-Instanz',
	'Class:lnkSoftwareInstanceToSoftwarePatch/Attribute:softwareinstance_id+' => '',
	'Class:lnkSoftwareInstanceToSoftwarePatch/Attribute:softwareinstance_name' => 'Software-Instanz-Name',
	'Class:lnkSoftwareInstanceToSoftwarePatch/Attribute:softwareinstance_name+' => '',
));

//
// Class: lnkFunctionalCIToOSPatch
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:lnkFunctionalCIToOSPatch' => 'Verknüpfung FunctionalCI/OS-Patch',
	'Class:lnkFunctionalCIToOSPatch+' => '',
	'Class:lnkFunctionalCIToOSPatch/Name' => '%1$s / %2$s',
	'Class:lnkFunctionalCIToOSPatch/Attribute:ospatch_id' => 'OS-Patch',
	'Class:lnkFunctionalCIToOSPatch/Attribute:ospatch_id+' => '',
	'Class:lnkFunctionalCIToOSPatch/Attribute:ospatch_name' => 'OS-Patch-Name',
	'Class:lnkFunctionalCIToOSPatch/Attribute:ospatch_name+' => '',
	'Class:lnkFunctionalCIToOSPatch/Attribute:functionalci_id' => 'FunctionalCI',
	'Class:lnkFunctionalCIToOSPatch/Attribute:functionalci_id+' => '',
	'Class:lnkFunctionalCIToOSPatch/Attribute:functionalci_name' => 'FunctionalCI-Name',
	'Class:lnkFunctionalCIToOSPatch/Attribute:functionalci_name+' => '',
));

//
// Class: lnkDocumentToSoftware
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:lnkDocumentToSoftware' => 'Verknüpfung Dokument/Software',
	'Class:lnkDocumentToSoftware+' => '',
	'Class:lnkDocumentToSoftware/Name' => '%1$s / %2$s',
	'Class:lnkDocumentToSoftware/Attribute:software_id' => 'Software',
	'Class:lnkDocumentToSoftware/Attribute:software_id+' => '',
	'Class:lnkDocumentToSoftware/Attribute:software_name' => 'Software-Name',
	'Class:lnkDocumentToSoftware/Attribute:software_name+' => '',
	'Class:lnkDocumentToSoftware/Attribute:document_id' => 'Dokument',
	'Class:lnkDocumentToSoftware/Attribute:document_id+' => '',
	'Class:lnkDocumentToSoftware/Attribute:document_name' => 'Dokument-Name',
	'Class:lnkDocumentToSoftware/Attribute:document_name+' => '',
));

//
// Class: Subnet
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:Subnet' => 'Subnetz',
	'Class:Subnet+' => '',
	'Class:Subnet/Name' => '%1$s/%2$s',
	'Class:Subnet/ComplementaryName' => '%1$s - %2$s',
	'Class:Subnet/Attribute:description' => 'Beschreibung',
	'Class:Subnet/Attribute:description+' => '',
	'Class:Subnet/Attribute:subnet_name' => 'Subnetzname',
	'Class:Subnet/Attribute:subnet_name+' => '',
	'Class:Subnet/Attribute:org_id' => 'Organisation',
	'Class:Subnet/Attribute:org_id+' => '',
	'Class:Subnet/Attribute:org_name' => 'Name',
	'Class:Subnet/Attribute:org_name+' => '',
	'Class:Subnet/Attribute:ip' => 'IP',
	'Class:Subnet/Attribute:ip+' => '',
	'Class:Subnet/Attribute:ip_mask' => 'Subnetz-Maske',
	'Class:Subnet/Attribute:ip_mask+' => '',
	'Class:Subnet/Attribute:vlans_list' => 'VLANs',
	'Class:Subnet/Attribute:vlans_list+' => '',
));

//
// Class: VLAN
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:VLAN' => 'VLAN',
	'Class:VLAN+' => '',
	'Class:VLAN/Attribute:vlan_tag' => 'VLAN-Tag',
	'Class:VLAN/Attribute:vlan_tag+' => '',
	'Class:VLAN/Attribute:description' => 'Beschreibung',
	'Class:VLAN/Attribute:description+' => '',
	'Class:VLAN/Attribute:org_id' => 'Organisation',
	'Class:VLAN/Attribute:org_id+' => '',
	'Class:VLAN/Attribute:org_name' => 'Organisationsname',
	'Class:VLAN/Attribute:org_name+' => 'Allgemeiner Name (Common name)',
	'Class:VLAN/Attribute:subnets_list' => 'Subnetze',
	'Class:VLAN/Attribute:subnets_list+' => '',
	'Class:VLAN/Attribute:physicalinterfaces_list' => 'Physische Interfaces',
	'Class:VLAN/Attribute:physicalinterfaces_list+' => '',
));

//
// Class: lnkSubnetToVLAN
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:lnkSubnetToVLAN' => 'Verknüpfung Subnetz/VLAN',
	'Class:lnkSubnetToVLAN+' => '',
	'Class:lnkSubnetToVLAN/Name' => '%1$s / %2$s',
	'Class:lnkSubnetToVLAN/Attribute:subnet_id' => 'Subnetz',
	'Class:lnkSubnetToVLAN/Attribute:subnet_id+' => '',
	'Class:lnkSubnetToVLAN/Attribute:subnet_ip' => 'Subnetz-IP',
	'Class:lnkSubnetToVLAN/Attribute:subnet_ip+' => '',
	'Class:lnkSubnetToVLAN/Attribute:subnet_name' => 'Subnetz-Name',
	'Class:lnkSubnetToVLAN/Attribute:subnet_name+' => '',
	'Class:lnkSubnetToVLAN/Attribute:vlan_id' => 'VLAN',
	'Class:lnkSubnetToVLAN/Attribute:vlan_id+' => '',
	'Class:lnkSubnetToVLAN/Attribute:vlan_tag' => 'VLAN Tag',
	'Class:lnkSubnetToVLAN/Attribute:vlan_tag+' => '',
));

//
// Class: NetworkInterface
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:NetworkInterface' => 'Netzwerk-Interface',
	'Class:NetworkInterface+' => '',
	'Class:NetworkInterface/Attribute:name' => 'Name',
	'Class:NetworkInterface/Attribute:name+' => '',
	'Class:NetworkInterface/Attribute:finalclass' => 'Typ',
	'Class:NetworkInterface/Attribute:finalclass+' => 'Name der instanziierbaren Klasse',
));

//
// Class: IPInterface
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:IPInterface' => 'IP-Interface',
	'Class:IPInterface+' => '',
	'Class:IPInterface/Attribute:ipaddress' => 'IP-Adresse',
	'Class:IPInterface/Attribute:ipaddress+' => '',
	'Class:IPInterface/Attribute:macaddress' => 'MAC-Adresse',
	'Class:IPInterface/Attribute:macaddress+' => '',
	'Class:IPInterface/Attribute:comment' => 'Kommentar',
	'Class:IPInterface/Attribute:coment+' => '',
	'Class:IPInterface/Attribute:ipgateway' => 'IP-Gateway',
	'Class:IPInterface/Attribute:ipgateway+' => '',
	'Class:IPInterface/Attribute:ipmask' => 'IP-Maske',
	'Class:IPInterface/Attribute:ipmask+' => '',
	'Class:IPInterface/Attribute:speed' => 'Geschwindigkeit',
	'Class:IPInterface/Attribute:speed+' => '',
));

//
// Class: PhysicalInterface
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:PhysicalInterface' => 'Physisches Interface',
	'Class:PhysicalInterface+' => '',
	'Class:PhysicalInterface/Name' => '%2$s %1$s',
	'Class:PhysicalInterface/Attribute:connectableci_id' => 'Gerät',
	'Class:PhysicalInterface/Attribute:connectableci_id+' => '',
	'Class:PhysicalInterface/Attribute:connectableci_name' => 'Gerätename',
	'Class:PhysicalInterface/Attribute:connectableci_name+' => '',
	'Class:PhysicalInterface/Attribute:vlans_list' => 'VLANs',
	'Class:PhysicalInterface/Attribute:vlans_list+' => '',
));

//
// Class: lnkPhysicalInterfaceToVLAN
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:lnkPhysicalInterfaceToVLAN' => 'Verknüpfung Physisches Interface / VLAN',
	'Class:lnkPhysicalInterfaceToVLAN+' => '',
	'Class:lnkPhysicalInterfaceToVLAN/Name' => '%1$s %2$s / %3$s',
	'Class:lnkPhysicalInterfaceToVLAN/Attribute:physicalinterface_id' => 'Physisches Interface',
	'Class:lnkPhysicalInterfaceToVLAN/Attribute:physicalinterface_id+' => '',
	'Class:lnkPhysicalInterfaceToVLAN/Attribute:physicalinterface_name' => 'Physisches Interface Name',
	'Class:lnkPhysicalInterfaceToVLAN/Attribute:physicalinterface_name+' => '',
	'Class:lnkPhysicalInterfaceToVLAN/Attribute:physicalinterface_device_id' => 'Gerät',
	'Class:lnkPhysicalInterfaceToVLAN/Attribute:physicalinterface_device_id+' => '',
	'Class:lnkPhysicalInterfaceToVLAN/Attribute:physicalinterface_device_name' => 'Gerätename',
	'Class:lnkPhysicalInterfaceToVLAN/Attribute:physicalinterface_device_name+' => '',
	'Class:lnkPhysicalInterfaceToVLAN/Attribute:vlan_id' => 'VLAN',
	'Class:lnkPhysicalInterfaceToVLAN/Attribute:vlan_id+' => '',
	'Class:lnkPhysicalInterfaceToVLAN/Attribute:vlan_tag' => 'VLAN Tag',
	'Class:lnkPhysicalInterfaceToVLAN/Attribute:vlan_tag+' => '',
));


//
// Class: LogicalInterface
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:LogicalInterface' => 'Logisches Interface',
	'Class:LogicalInterface+' => '',
	'Class:LogicalInterface/Attribute:virtualmachine_id' => 'Virtuelle Maschine',
	'Class:LogicalInterface/Attribute:virtualmachine_id+' => '',
	'Class:LogicalInterface/Attribute:virtualmachine_name' => 'Virtuelle Maschine-Name',
	'Class:LogicalInterface/Attribute:virtualmachine_name+' => '',
));

//
// Class: FiberChannelInterface
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:FiberChannelInterface' => 'Fiber Channel Interface',
	'Class:FiberChannelInterface+' => '',
	'Class:FiberChannelInterface/Attribute:speed' => 'Geschwindigkeit',
	'Class:FiberChannelInterface/Attribute:speed+' => '',
	'Class:FiberChannelInterface/Attribute:topology' => 'Topologie',
	'Class:FiberChannelInterface/Attribute:topology+' => '',
	'Class:FiberChannelInterface/Attribute:wwn' => 'WWN',
	'Class:FiberChannelInterface/Attribute:wwn+' => '',
	'Class:FiberChannelInterface/Attribute:datacenterdevice_id' => 'Gerät',
	'Class:FiberChannelInterface/Attribute:datacenterdevice_id+' => '',
	'Class:FiberChannelInterface/Attribute:datacenterdevice_name' => 'Gerätename',
	'Class:FiberChannelInterface/Attribute:datacenterdevice_name+' => '',
));

//
// Class: lnkConnectableCIToNetworkDevice
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:lnkConnectableCIToNetworkDevice' => 'Verknüpfung ConnectableCI/NetworkDevice',
	'Class:lnkConnectableCIToNetworkDevice+' => '',
	'Class:lnkConnectableCIToNetworkDevice/Name' => '%1$s / %2$s',
	'Class:lnkConnectableCIToNetworkDevice/Attribute:networkdevice_id' => 'Netzwerkgerät',
	'Class:lnkConnectableCIToNetworkDevice/Attribute:networkdevice_id+' => '',
	'Class:lnkConnectableCIToNetworkDevice/Attribute:networkdevice_name' => 'Netzwerkgerät-Name',
	'Class:lnkConnectableCIToNetworkDevice/Attribute:networkdevice_name+' => '',
	'Class:lnkConnectableCIToNetworkDevice/Attribute:connectableci_id' => 'Verbundenes Gerät',
	'Class:lnkConnectableCIToNetworkDevice/Attribute:connectableci_id+' => '',
	'Class:lnkConnectableCIToNetworkDevice/Attribute:connectableci_name' => 'Verbundenes Gerät-Name',
	'Class:lnkConnectableCIToNetworkDevice/Attribute:connectableci_name+' => '',
	'Class:lnkConnectableCIToNetworkDevice/Attribute:network_port' => 'Netzwerkport',
	'Class:lnkConnectableCIToNetworkDevice/Attribute:network_port+' => '',
	'Class:lnkConnectableCIToNetworkDevice/Attribute:device_port' => 'Geräteport',
	'Class:lnkConnectableCIToNetworkDevice/Attribute:device_port+' => '',
	'Class:lnkConnectableCIToNetworkDevice/Attribute:connection_type' => 'Verbindungstyp',
	'Class:lnkConnectableCIToNetworkDevice/Attribute:connection_type+' => '',
	'Class:lnkConnectableCIToNetworkDevice/Attribute:connection_type/Value:downlink' => 'Downlink',
	'Class:lnkConnectableCIToNetworkDevice/Attribute:connection_type/Value:downlink+' => '',
	'Class:lnkConnectableCIToNetworkDevice/Attribute:connection_type/Value:uplink' => 'Uplink',
	'Class:lnkConnectableCIToNetworkDevice/Attribute:connection_type/Value:uplink+' => '',
));

//
// Class: lnkApplicationSolutionToFunctionalCI
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:lnkApplicationSolutionToFunctionalCI' => 'Verknüpfung Anwendungslösung/FunctionalCI',
	'Class:lnkApplicationSolutionToFunctionalCI+' => '',
	'Class:lnkApplicationSolutionToFunctionalCI/Name' => '%1$s / %2$s',
	'Class:lnkApplicationSolutionToFunctionalCI/Attribute:applicationsolution_id' => 'Anwendungslösung',
	'Class:lnkApplicationSolutionToFunctionalCI/Attribute:applicationsolution_id+' => '',
	'Class:lnkApplicationSolutionToFunctionalCI/Attribute:applicationsolution_name' => 'Anwendungslösungs-Name',
	'Class:lnkApplicationSolutionToFunctionalCI/Attribute:applicationsolution_name+' => '',
	'Class:lnkApplicationSolutionToFunctionalCI/Attribute:functionalci_id' => 'FunctionalCI',
	'Class:lnkApplicationSolutionToFunctionalCI/Attribute:functionalci_id+' => '',
	'Class:lnkApplicationSolutionToFunctionalCI/Attribute:functionalci_name' => 'FunctionalCI-Name',
	'Class:lnkApplicationSolutionToFunctionalCI/Attribute:functionalci_name+' => '',
));

//
// Class: lnkApplicationSolutionToBusinessProcess
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:lnkApplicationSolutionToBusinessProcess' => 'Verknüpfung Anwendungslösung/Business-Prozess',
	'Class:lnkApplicationSolutionToBusinessProcess+' => '',
	'Class:lnkApplicationSolutionToBusinessProcess/Name' => '%1$s / %2$s',
	'Class:lnkApplicationSolutionToBusinessProcess/Attribute:businessprocess_id' => 'Business-Prozess',
	'Class:lnkApplicationSolutionToBusinessProcess/Attribute:businessprocess_id+' => '',
	'Class:lnkApplicationSolutionToBusinessProcess/Attribute:businessprocess_name' => 'Business-Prozess-Name',
	'Class:lnkApplicationSolutionToBusinessProcess/Attribute:businessprocess_name+' => '',
	'Class:lnkApplicationSolutionToBusinessProcess/Attribute:applicationsolution_id' => 'Anwendungslösung',
	'Class:lnkApplicationSolutionToBusinessProcess/Attribute:applicationsolution_id+' => '',
	'Class:lnkApplicationSolutionToBusinessProcess/Attribute:applicationsolution_name' => 'Anwendungslösung-Name',
	'Class:lnkApplicationSolutionToBusinessProcess/Attribute:applicationsolution_name+' => '',
));

//
// Class: Group
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:Group' => 'Gruppe',
	'Class:Group+' => '',
	'Class:Group/ComplementaryName' => '%1$s - %2$s',
	'Class:Group/Attribute:name' => 'Name',
	'Class:Group/Attribute:name+' => '',
	'Class:Group/Attribute:status' => 'Status',
	'Class:Group/Attribute:status+' => '',
	'Class:Group/Attribute:status/Value:implementation' => 'Implementation',
	'Class:Group/Attribute:status/Value:implementation+' => 'Implementation',
	'Class:Group/Attribute:status/Value:obsolete' => 'Obsolet (Veraltet)',
	'Class:Group/Attribute:status/Value:obsolete+' => 'Obsolet (Veraltet)',
	'Class:Group/Attribute:status/Value:production' => 'Produktion',
	'Class:Group/Attribute:status/Value:production+' => 'Produktion',
	'Class:Group/Attribute:org_id' => 'Organisation',
	'Class:Group/Attribute:org_id+' => '',
	'Class:Group/Attribute:owner_name' => 'Name',
	'Class:Group/Attribute:owner_name+' => 'Allgemeiner Name',
	'Class:Group/Attribute:description' => 'Beschreibung',
	'Class:Group/Attribute:description+' => '',
	'Class:Group/Attribute:type' => 'Typ',
	'Class:Group/Attribute:type+' => '',
	'Class:Group/Attribute:parent_id' => 'Muttergruppe',
	'Class:Group/Attribute:parent_id+' => '',
	'Class:Group/Attribute:parent_name' => 'Name',
	'Class:Group/Attribute:parent_name+' => '',
	'Class:Group/Attribute:ci_list' => 'Verbundene CIs',
	'Class:Group/Attribute:ci_list+' => 'Alle mit dieser Gruppe verknüpften CIs',
	'Class:Group/Attribute:parent_id_friendlyname' => 'Parent-Gruppe',
	'Class:Group/Attribute:parent_id_friendlyname+' => '',
));

//
// Class: lnkGroupToCI
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:lnkGroupToCI' => 'Gruppe/CI',
	'Class:lnkGroupToCI+' => '',
	'Class:lnkGroupToCI/Name' => '%1$s / %2$s',
	'Class:lnkGroupToCI/Attribute:group_id' => 'Gruppe',
	'Class:lnkGroupToCI/Attribute:group_id+' => '',
	'Class:lnkGroupToCI/Attribute:group_name' => 'Name',
	'Class:lnkGroupToCI/Attribute:group_name+' => '',
	'Class:lnkGroupToCI/Attribute:ci_id' => 'CI',
	'Class:lnkGroupToCI/Attribute:ci_id+' => '',
	'Class:lnkGroupToCI/Attribute:ci_name' => 'Name',
	'Class:lnkGroupToCI/Attribute:ci_name+' => '',
	'Class:lnkGroupToCI/Attribute:reason' => 'Grund',
	'Class:lnkGroupToCI/Attribute:reason+' => '',
));

// Add translation for Fieldsets

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Server:baseinfo' => 'Allgemeine Informationen',
	'Server:Date' => 'Datum',
	'Server:moreinfo' => 'Weitere Informationen',
	'Server:otherinfo' => 'Sonstige Informationen',
	'Server:power' => 'Stromversorgung',
	'Class:Subnet/Tab:IPUsage' => 'IP-Nutzung',
	'Class:Subnet/Tab:IPUsage+' => 'Welche IPs innerhalb dieses Subnetzes verwendet werden oder nicht',
	'Class:Subnet/Tab:IPUsage-explain' => 'Interfaces mit einer IP in der Range: <em>%1$s</em> bis <em>%2$s</em>',
	'Class:Subnet/Tab:FreeIPs' => 'Freie IPs',
	'Class:Subnet/Tab:FreeIPs-count' => 'Freie IPs: %1$s',
	'Class:Subnet/Tab:FreeIPs-explain' => 'Hier ist eine Auflistung von 10 freien IP Adressen',
	'Class:Document:PreviewTab' => 'Vorschau',
));


//
// Class: lnkDocumentToFunctionalCI
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Class:lnkDocumentToFunctionalCI' => 'Verknüpfung Dokument/FunctionalCI',
	'Class:lnkDocumentToFunctionalCI+' => '',
	'Class:lnkDocumentToFunctionalCI/Name' => '%1$s / %2$s',
	'Class:lnkDocumentToFunctionalCI/Attribute:functionalci_id' => 'FunctionalCI',
	'Class:lnkDocumentToFunctionalCI/Attribute:functionalci_id+' => '',
	'Class:lnkDocumentToFunctionalCI/Attribute:functionalci_name' => 'FunctionalCI-Name',
	'Class:lnkDocumentToFunctionalCI/Attribute:functionalci_name+' => '',
	'Class:lnkDocumentToFunctionalCI/Attribute:document_id' => 'Dokument',
	'Class:lnkDocumentToFunctionalCI/Attribute:document_id+' => '',
	'Class:lnkDocumentToFunctionalCI/Attribute:document_name' => 'Dokument-Name',
	'Class:lnkDocumentToFunctionalCI/Attribute:document_name+' => '',
));

//
// Application Menu
//

Dict::Add('DE DE', 'German', 'Deutsch', array(
	'Menu:Application' => 'Anwendungen',
	'Menu:Application+' => 'Alle Anwendungen',
	'Menu:DBServer' => 'Datenbank-Server',
	'Menu:DBServer+' => 'Datenbank-Server',
	'Menu:BusinessProcess' => 'Business-Prozesse',
	'Menu:BusinessProcess+' => 'Alle Business-Prozesse',
	'Menu:ApplicationSolution' => 'Anwendungslösungen',
	'Menu:ApplicationSolution+' => 'Alle Anwendungslösungen',
	'Menu:ConfigManagementSoftware' => 'Anwendungs-Management',
	'Menu:Licence' => 'Lizenzen',
	'Menu:Licence+' => 'Alle Lizenzen',
	'Menu:Patch' => 'Patches',
	'Menu:Patch+' => 'Alle Patches',
	'Menu:ApplicationInstance' => 'Installierte Software',
	'Menu:ApplicationInstance+' => 'Anwendungen und Datenbank-Server',
	'Menu:ConfigManagementHardware' => 'Infrastruktur-Management',
	'Menu:Subnet' => 'Subnetze',
	'Menu:Subnet+' => 'Alle Subnetze',
	'Menu:NetworkDevice' => 'Netzwerkgeräte',
	'Menu:NetworkDevice+' => 'Alle Netzwerkgeräte',
	'Menu:Server' => 'Server',
	'Menu:Server+' => 'Alle Server',
	'Menu:Printer' => 'Drucker',
	'Menu:Printer+' => 'Alle Drucker',
	'Menu:MobilePhone' => 'Mobiltelefone',
	'Menu:MobilePhone+' => 'Alle Mobiltelefone',
	'Menu:PC' => 'Rechner (PC)',
	'Menu:PC+' => 'Alle Rechner (PC)',
	'Menu:NewCI' => 'Neues CI',
	'Menu:NewCI+' => 'Neues CI',
	'Menu:SearchCIs' => 'Nach CIs suchen',
	'Menu:SearchCIs+' => 'Nach CIs suchen',
	'Menu:ConfigManagement:Devices' => 'Geräte',
	'Menu:ConfigManagement:AllDevices' => 'Infrastruktur',
	'Menu:ConfigManagement:virtualization' => 'Virtualisierung',
	'Menu:ConfigManagement:EndUsers' => 'Endbenutzer-Geräte',
	'Menu:ConfigManagement:SWAndApps' => 'Software und Anwendungen',
	'Menu:ConfigManagement:Misc' => 'Diverses',
	'Menu:Group' => 'Gruppen von CIs',
	'Menu:Group+' => 'Gruppen von CIs',
	'Menu:OSVersion' => 'OS-Versionen',
	'Menu:OSVersion+' => '',
	'Menu:Software' => 'Software-Katalog',
	'Menu:Software+' => '',
));
?>
