<?php
/**
 * Copyright (C) 2013-2023 Combodo SARL
 *
 * This file is part of iTop.
 *
 * iTop is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * iTop is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 *
 *
 */
Dict::Add('SK SK', 'Slovak', 'Slovenčina', array(
	'Core:DeletedObjectLabel' => '%1s (odstránené)',
	'Core:DeletedObjectTip' => 'Objekt bol odstránený o %1$s (%2$s)',
	'Core:UnknownObjectLabel' => 'Objekt nebol nájdený (trieda: %1$s, id: %2$d)',
	'Core:UnknownObjectTip' => 'Objekt nebol nájdený. Mohol byť odstránený pred nejakým časom a záznam bol odvtedy nenávratne zmazaný.',
	'Core:UniquenessDefaultError' => 'Uniqueness rule \'%1$s\' in error~~',
	'Core:CheckConsistencyError' => 'Consistency rules not followed: %1$s~~',
	'Core:CheckValueError' => 'Unexpected value for attribute \'%1$s\' (%2$s) : %3$s~~',
	'Core:AttributeLinkedSet' => 'Pole objektov',
	'Core:AttributeLinkedSet+' => '',
	'Core:AttributeLinkedSetDuplicatesFound' => 'Duplicates in the \'%1$s\' field : %2$s~~',
	'Core:AttributeDashboard' => 'Dashboard~~',
	'Core:AttributeDashboard+' => '',
	'Core:AttributePhoneNumber' => 'Phone number~~',
	'Core:AttributePhoneNumber+' => '',
	'Core:AttributeObsolescenceDate' => 'Obsolescence date~~',
	'Core:AttributeObsolescenceDate+' => '',
	'Core:AttributeTagSet' => 'List of tags~~',
	'Core:AttributeTagSet+' => '',
	'Core:AttributeSet:placeholder' => 'click to add~~',
	'Core:AttributeClassAttCodeSet:ItemLabel:AttributeFromClass' => '%1$s (%2$s)~~',
	'Core:AttributeClassAttCodeSet:ItemLabel:AttributeFromOneChildClass' => '%1$s (%2$s from %3$s)~~',
	'Core:AttributeClassAttCodeSet:ItemLabel:AttributeFromSeveralChildClasses' => '%1$s (%2$s from child classes)~~',
	'Core:AttributeCaseLog' => 'Log~~',
	'Core:AttributeCaseLog+' => '',
	'Core:AttributeMetaEnum' => 'Computed enum~~',
	'Core:AttributeMetaEnum+' => '',
	'Core:AttributeLinkedSetIndirect' => 'Pole objektov (N-N)',
	'Core:AttributeLinkedSetIndirect+' => '',
	'Core:AttributeInteger' => 'Celé číslo',
	'Core:AttributeInteger+' => '',
	'Core:AttributeDecimal' => 'Desatinné číslo',
	'Core:AttributeDecimal+' => '',
	'Core:AttributeBoolean' => 'Boolean',
	'Core:AttributeBoolean+' => '',
	'Core:AttributeBoolean/Value:null' => '~~',
	'Core:AttributeBoolean/Value:yes' => 'Yes~~',
	'Core:AttributeBoolean/Value:no' => 'No~~',
	'Core:AttributeArchiveFlag' => 'Archive flag~~',
	'Core:AttributeArchiveFlag/Value:yes' => 'Yes~~',
	'Core:AttributeArchiveFlag/Value:yes+' => 'This object is visible only in archive mode~~',
	'Core:AttributeArchiveFlag/Value:no' => 'No~~',
	'Core:AttributeArchiveFlag/Label' => 'Archived~~',
	'Core:AttributeArchiveFlag/Label+' => '',
	'Core:AttributeArchiveDate/Label' => 'Archive date~~',
	'Core:AttributeArchiveDate/Label+' => '',
	'Core:AttributeObsolescenceFlag' => 'Obsolescence flag~~',
	'Core:AttributeObsolescenceFlag/Value:yes' => 'Yes~~',
	'Core:AttributeObsolescenceFlag/Value:yes+' => 'This object is excluded from the impact analysis, and hidden from search results~~',
	'Core:AttributeObsolescenceFlag/Value:no' => 'No~~',
	'Core:AttributeObsolescenceFlag/Label' => 'Obsolete~~',
	'Core:AttributeObsolescenceFlag/Label+' => 'Computed dynamically on other attributes~~',
	'Core:AttributeObsolescenceDate/Label' => 'Obsolescence date~~',
	'Core:AttributeObsolescenceDate/Label+' => 'Approximative date at which the object has been considered obsolete~~',
	'Core:AttributeString' => 'Reťazec',
	'Core:AttributeString+' => '',
	'Core:AttributeClass' => 'Trieda',
	'Core:AttributeClass+' => '',
	'Core:AttributeApplicationLanguage' => 'Užívateľský jazyk',
	'Core:AttributeApplicationLanguage+' => '',
	'Core:AttributeFinalClass' => 'Trieda (auto)',
	'Core:AttributeFinalClass+' => '',
	'Core:AttributePassword' => 'Heslo',
	'Core:AttributePassword+' => '',
	'Core:AttributeEncryptedString' => 'Zakódovaný reťazec',
	'Core:AttributeEncryptedString+' => '',
	'Core:AttributeEncryptUnknownLibrary' => 'Encryption library specified (%1$s) unknown~~',
	'Core:AttributeEncryptFailedToDecrypt' => '** decryption error **~~',
	'Core:AttributeText' => 'Text',
	'Core:AttributeText+' => '',
	'Core:AttributeHTML' => 'HTML',
	'Core:AttributeHTML+' => '',
	'Core:AttributeEmailAddress' => 'Emailova Adresa',
	'Core:AttributeEmailAddress+' => '',
	'Core:AttributeIPAddress' => 'IP Adresa',
	'Core:AttributeIPAddress+' => '',
	'Core:AttributeOQL' => 'OQL',
	'Core:AttributeOQL+' => '',
	'Core:AttributeEnum' => 'Enum',
	'Core:AttributeEnum+' => '',
	'Core:AttributeTemplateString' => 'Predloha reťazca',
	'Core:AttributeTemplateString+' => '',
	'Core:AttributeTemplateText' => 'Predloha textu',
	'Core:AttributeTemplateText+' => '',
	'Core:AttributeTemplateHTML' => 'Predloha HTML',
	'Core:AttributeTemplateHTML+' => '',
	'Core:AttributeDateTime' => 'Dátum/čas',
	'Core:AttributeDateTime+' => '',
	'Core:AttributeDateTime?SmartSearch' => '
<p>
	Formát dátumu:<br/>
	<b>yyyy-mm-dd hh:mm:ss</b><br/>
	Príklad: 2011-07-19 18:40:00
</p>
<p>
Operatori:<br/>
	<b>&gt;</b><em>dátum</em><br/>
	<b>&lt;</b><em>dátum</em><br/>
	<b>[</b><em>dátum</em>,<em>dátum</em><b>]</b>
</p>
<p>
Ak je čas vynechaný, predvolený čas je 00:00:00
</p>',
	'Core:AttributeDate' => 'Dátum',
	'Core:AttributeDate+' => '',
	'Core:AttributeDate?SmartSearch' => '
<p>
	Formát dátumu:<br/>
	<b>yyyy-mm-dd</b><br/>
	Príklad: 2011-07-19
</p>
<p>
Operatori:<br/>
	<b>&gt;</b><em>dátum</em><br/>
	<b>&lt;</b><em>dátum</em><br/>
	<b>[</b><em>dátum</em>,<em>dátum</em><b>]</b>
</p>',
	'Core:AttributeDeadline' => 'Dátum eskalácie',
	'Core:AttributeDeadline+' => '',
	'Core:AttributeExternalKey' => 'Externý kľúč',
	'Core:AttributeExternalKey+' => '',
	'Core:AttributeHierarchicalKey' => 'Hierarchický kľúč',
	'Core:AttributeHierarchicalKey+' => '',
	'Core:AttributeExternalField' => 'Externé pole',
	'Core:AttributeExternalField+' => '',
	'Core:AttributeURL' => 'URL',
	'Core:AttributeURL+' => '',
	'Core:AttributeBlob' => 'Binarny object',
	'Core:AttributeBlob+' => '',
	'Core:AttributeOneWayPassword' => 'Jednorazové heslo',
	'Core:AttributeOneWayPassword+' => '',
	'Core:AttributeTable' => 'Tabuľka',
	'Core:AttributeTable+' => '',
	'Core:AttributePropertySet' => 'Vlastnosti',
	'Core:AttributePropertySet+' => '',
	'Core:AttributeFriendlyName' => 'Ľahko čitateľný názov',
	'Core:AttributeFriendlyName+' => '',
	'Core:FriendlyName-Label' => 'Ľahko čitateľný názov',
	'Core:FriendlyName-Description' => 'Ľahko čitateľný názov',
	'Core:AttributeTag' => 'Tags~~',
	'Core:AttributeTag+' => '',
	'Core:Context=REST/JSON' => 'REST~~',
	'Core:Context=Synchro' => 'Synchro~~',
	'Core:Context=Setup' => 'Setup~~',
	'Core:Context=GUI:Console' => 'Console~~',
	'Core:Context=CRON' => 'cron~~',
	'Core:Context=GUI:Portal' => 'Portal~~',
));


//////////////////////////////////////////////////////////////////////
// Classes in 'core/cmdb'
//////////////////////////////////////////////////////////////////////
//

//
// Class: CMDBChange
//

Dict::Add('SK SK', 'Slovak', 'Slovenčina', array(
	'Class:CMDBChange' => 'Zmena',
	'Class:CMDBChange+' => '',
	'Class:CMDBChange/Attribute:date' => 'Dátum',
	'Class:CMDBChange/Attribute:date+' => '',
	'Class:CMDBChange/Attribute:userinfo' => 'Rozl. info',
	'Class:CMDBChange/Attribute:userinfo+' => '',
	'Class:CMDBChange/Attribute:origin/Value:interactive' => 'User interaction in the GUI~~',
	'Class:CMDBChange/Attribute:origin/Value:csv-import.php' => 'CSV import script~~',
	'Class:CMDBChange/Attribute:origin/Value:csv-interactive' => 'CSV import in the GUI~~',
	'Class:CMDBChange/Attribute:origin/Value:email-processing' => 'Email processing~~',
	'Class:CMDBChange/Attribute:origin/Value:synchro-data-source' => 'Synchro. data source~~',
	'Class:CMDBChange/Attribute:origin/Value:webservice-rest' => 'REST/JSON webservices~~',
	'Class:CMDBChange/Attribute:origin/Value:webservice-soap' => 'SOAP webservices~~',
	'Class:CMDBChange/Attribute:origin/Value:custom-extension' => 'By an extension~~',
));

//
// Class: CMDBChangeOp
//

Dict::Add('SK SK', 'Slovak', 'Slovenčina', array(
	'Class:CMDBChangeOp' => 'Vykonanie Zmeny',
	'Class:CMDBChangeOp+' => '',
	'Class:CMDBChangeOp/Attribute:change' => 'Zmena',
	'Class:CMDBChangeOp/Attribute:change+' => '',
	'Class:CMDBChangeOp/Attribute:date' => 'dátum',
	'Class:CMDBChangeOp/Attribute:date+' => '',
	'Class:CMDBChangeOp/Attribute:userinfo' => 'užívateľ',
	'Class:CMDBChangeOp/Attribute:userinfo+' => '',
	'Class:CMDBChangeOp/Attribute:objclass' => 'Trieda objektu',
	'Class:CMDBChangeOp/Attribute:objclass+' => '',
	'Class:CMDBChangeOp/Attribute:objkey' => 'ID objektu',
	'Class:CMDBChangeOp/Attribute:objkey+' => '',
	'Class:CMDBChangeOp/Attribute:finalclass' => 'Typ',
	'Class:CMDBChangeOp/Attribute:finalclass+' => '',
));

//
// Class: CMDBChangeOpCreate
//

Dict::Add('SK SK', 'Slovak', 'Slovenčina', array(
	'Class:CMDBChangeOpCreate' => 'Vytvorenie objektu',
	'Class:CMDBChangeOpCreate+' => '',
));

//
// Class: CMDBChangeOpDelete
//

Dict::Add('SK SK', 'Slovak', 'Slovenčina', array(
	'Class:CMDBChangeOpDelete' => 'Vymazanie objektu',
	'Class:CMDBChangeOpDelete+' => '',
));

//
// Class: CMDBChangeOpSetAttribute
//

Dict::Add('SK SK', 'Slovak', 'Slovenčina', array(
	'Class:CMDBChangeOpSetAttribute' => 'Zmena objektu',
	'Class:CMDBChangeOpSetAttribute+' => '',
	'Class:CMDBChangeOpSetAttribute/Attribute:attcode' => 'Atribút',
	'Class:CMDBChangeOpSetAttribute/Attribute:attcode+' => '',
));

//
// Class: CMDBChangeOpSetAttributeScalar
//

Dict::Add('SK SK', 'Slovak', 'Slovenčina', array(
	'Class:CMDBChangeOpSetAttributeScalar' => 'Zmena vlastnosti',
	'Class:CMDBChangeOpSetAttributeScalar+' => '',
	'Class:CMDBChangeOpSetAttributeScalar/Attribute:oldvalue' => 'Predchádzajúca hodnota',
	'Class:CMDBChangeOpSetAttributeScalar/Attribute:oldvalue+' => '',
	'Class:CMDBChangeOpSetAttributeScalar/Attribute:newvalue' => 'Nová hodnota',
	'Class:CMDBChangeOpSetAttributeScalar/Attribute:newvalue+' => '',
));
// Used by CMDBChangeOp... & derived classes
Dict::Add('SK SK', 'Slovak', 'Slovenčina', array(
	'Change:ObjectCreated' => 'Objekt vytvorený',
	'Change:ObjectDeleted' => 'Objekt odstránený',
	'Change:ObjectModified' => 'Objekt upravený',
	'Change:TwoAttributesChanged' => 'Edited %1$s and %2$s~~',
	'Change:ThreeAttributesChanged' => 'Edited %1$s, %2$s and 1 other~~',
	'Change:FourOrMoreAttributesChanged' => 'Edited %1$s, %2$s and %3$s others~~',
	'Change:AttName_SetTo_NewValue_PreviousValue_OldValue' => '%1$s nastavené na %2$s (predchádzajúca hodnota: %3$s)',
	'Change:AttName_SetTo' => '%1$s nastavené na %2$s',
	'Change:Text_AppendedTo_AttName' => '%1$s pripojené k %2$s',
	'Change:AttName_Changed_PreviousValue_OldValue' => '%1$s upravené, predchádzajúca hodnota: %2$s',
	'Change:AttName_Changed' => '%1$s upravené',
	'Change:AttName_EntryAdded' => '%1$s upravené, nový záznam pridaný.',
	'Change:State_Changed_NewValue_OldValue' => 'Changed from %2$s to %1$s~~',
	'Change:LinkSet:Added' => 'Pridané %1$s',
	'Change:LinkSet:Removed' => 'Odstránené %1$s',
	'Change:LinkSet:Modified' => 'Upravené %1$s',
));

//
// Class: CMDBChangeOpSetAttributeBlob
//

Dict::Add('SK SK', 'Slovak', 'Slovenčina', array(
	'Class:CMDBChangeOpSetAttributeBlob' => 'Zmena údajov',
	'Class:CMDBChangeOpSetAttributeBlob+' => '',
	'Class:CMDBChangeOpSetAttributeBlob/Attribute:prevdata' => 'Predchádzajúce údaje',
	'Class:CMDBChangeOpSetAttributeBlob/Attribute:prevdata+' => '',
));

//
// Class: CMDBChangeOpSetAttributeText
//

Dict::Add('SK SK', 'Slovak', 'Slovenčina', array(
	'Class:CMDBChangeOpSetAttributeText' => 'Zmena textu',
	'Class:CMDBChangeOpSetAttributeText+' => '',
	'Class:CMDBChangeOpSetAttributeText/Attribute:prevdata' => 'Predchádzajúce dáta',
	'Class:CMDBChangeOpSetAttributeText/Attribute:prevdata+' => '',
));

//
// Class: Event
//

Dict::Add('SK SK', 'Slovak', 'Slovenčina', array(
	'Class:Event' => 'Logovacia Udalosť',
	'Class:Event+' => '',
	'Class:Event/Attribute:message' => 'Správa',
	'Class:Event/Attribute:message+' => '',
	'Class:Event/Attribute:date' => 'Dátum',
	'Class:Event/Attribute:date+' => '',
	'Class:Event/Attribute:userinfo' => 'Informácie o užívateľovi',
	'Class:Event/Attribute:userinfo+' => '',
	'Class:Event/Attribute:finalclass' => 'Typ',
	'Class:Event/Attribute:finalclass+' => '',
));

//
// Class: EventNotification
//

Dict::Add('SK SK', 'Slovak', 'Slovenčina', array(
	'Class:EventNotification' => 'Notifikačná Udalosť',
	'Class:EventNotification+' => '',
	'Class:EventNotification/Attribute:trigger_id' => 'Spúštač',
	'Class:EventNotification/Attribute:trigger_id+' => '',
	'Class:EventNotification/Attribute:action_id' => 'Akcia',
	'Class:EventNotification/Attribute:action_id+' => '',
	'Class:EventNotification/Attribute:object_id' => 'ID objektu',
	'Class:EventNotification/Attribute:object_id+' => '',
));

//
// Class: EventNotificationEmail
//

Dict::Add('SK SK', 'Slovak', 'Slovenčina', array(
	'Class:EventNotificationEmail' => 'Udalosť emitovania emailu',
	'Class:EventNotificationEmail+' => '',
	'Class:EventNotificationEmail/Attribute:to' => 'Komu',
	'Class:EventNotificationEmail/Attribute:to+' => '',
	'Class:EventNotificationEmail/Attribute:cc' => 'Kópia',
	'Class:EventNotificationEmail/Attribute:cc+' => '',
	'Class:EventNotificationEmail/Attribute:bcc' => 'Skrytá Kópia',
	'Class:EventNotificationEmail/Attribute:bcc+' => '',
	'Class:EventNotificationEmail/Attribute:from' => 'Od',
	'Class:EventNotificationEmail/Attribute:from+' => '',
	'Class:EventNotificationEmail/Attribute:subject' => 'Predmet',
	'Class:EventNotificationEmail/Attribute:subject+' => '',
	'Class:EventNotificationEmail/Attribute:body' => 'Telo',
	'Class:EventNotificationEmail/Attribute:body+' => '',
	'Class:EventNotificationEmail/Attribute:attachments' => 'Prílohy',
	'Class:EventNotificationEmail/Attribute:attachments+' => '',
));

//
// Class: EventIssue
//

Dict::Add('SK SK', 'Slovak', 'Slovenčina', array(
	'Class:EventIssue' => 'Issue event',
	'Class:EventIssue+' => '',
	'Class:EventIssue/Attribute:issue' => 'Issue',
	'Class:EventIssue/Attribute:issue+' => '',
	'Class:EventIssue/Attribute:impact' => 'Dopad',
	'Class:EventIssue/Attribute:impact+' => '',
	'Class:EventIssue/Attribute:page' => 'Strana',
	'Class:EventIssue/Attribute:page+' => '',
	'Class:EventIssue/Attribute:arguments_post' => 'Odoslané argumenty (POST)',
	'Class:EventIssue/Attribute:arguments_post+' => '',
	'Class:EventIssue/Attribute:arguments_get' => 'URL argumenty (GET)',
	'Class:EventIssue/Attribute:arguments_get+' => '',
	'Class:EventIssue/Attribute:callstack' => 'Zásobník volaní',
	'Class:EventIssue/Attribute:callstack+' => '',
	'Class:EventIssue/Attribute:data' => 'Dáta',
	'Class:EventIssue/Attribute:data+' => '',
));

//
// Class: EventWebService
//

Dict::Add('SK SK', 'Slovak', 'Slovenčina', array(
	'Class:EventWebService' => 'Udalosť Webovej služby',
	'Class:EventWebService+' => '',
	'Class:EventWebService/Attribute:verb' => 'Slovný',
	'Class:EventWebService/Attribute:verb+' => '',
	'Class:EventWebService/Attribute:result' => 'Výsledok',
	'Class:EventWebService/Attribute:result+' => '',
	'Class:EventWebService/Attribute:log_info' => 'Záznam Informácie',
	'Class:EventWebService/Attribute:log_info+' => '',
	'Class:EventWebService/Attribute:log_warning' => 'Záznam Upozorenia',
	'Class:EventWebService/Attribute:log_warning+' => '',
	'Class:EventWebService/Attribute:log_error' => 'Záznam Chyby',
	'Class:EventWebService/Attribute:log_error+' => '',
	'Class:EventWebService/Attribute:data' => 'Dáta',
	'Class:EventWebService/Attribute:data+' => '',
));

Dict::Add('SK SK', 'Slovak', 'Slovenčina', array(
	'Class:EventRestService' => 'REST/JSON call~~',
	'Class:EventRestService+' => 'Trace of a REST/JSON service call~~',
	'Class:EventRestService/Attribute:operation' => 'Operation~~',
	'Class:EventRestService/Attribute:operation+' => 'Argument \'operation\'~~',
	'Class:EventRestService/Attribute:version' => 'Version~~',
	'Class:EventRestService/Attribute:version+' => 'Argument \'version\'~~',
	'Class:EventRestService/Attribute:json_input' => 'Input~~',
	'Class:EventRestService/Attribute:json_input+' => 'Argument \'json_data\'~~',
	'Class:EventRestService/Attribute:code' => 'Code~~',
	'Class:EventRestService/Attribute:code+' => 'Result code~~',
	'Class:EventRestService/Attribute:json_output' => 'Response~~',
	'Class:EventRestService/Attribute:json_output+' => 'HTTP response (json)~~',
	'Class:EventRestService/Attribute:provider' => 'Provider~~',
	'Class:EventRestService/Attribute:provider+' => 'PHP class implementing the expected operation~~',
));

//
// Class: EventLoginUsage
//

Dict::Add('SK SK', 'Slovak', 'Slovenčina', array(
	'Class:EventLoginUsage' => 'Využívanosť prihlasovacieho mena',
	'Class:EventLoginUsage+' => '',
	'Class:EventLoginUsage/Attribute:user_id' => 'Prihlasovacie meno',
	'Class:EventLoginUsage/Attribute:user_id+' => '',
	'Class:EventLoginUsage/Attribute:contact_name' => 'Užívateľské meno',
	'Class:EventLoginUsage/Attribute:contact_name+' => '',
	'Class:EventLoginUsage/Attribute:contact_email' => 'Užívateľský email',
	'Class:EventLoginUsage/Attribute:contact_email+' => '',
));

//
// Class: Action
//

Dict::Add('SK SK', 'Slovak', 'Slovenčina', array(
	'Class:Action' => 'Vlastná akcia',
	'Class:Action+' => '',
	'Class:Action/ComplementaryName' => '%1$s: %2$s~~',
	'Class:Action/Attribute:name' => 'Názov',
	'Class:Action/Attribute:name+' => '',
	'Class:Action/Attribute:description' => 'Popis',
	'Class:Action/Attribute:description+' => '',
	'Class:Action/Attribute:status' => 'Stav',
	'Class:Action/Attribute:status+' => '',
	'Class:Action/Attribute:status/Value:test' => 'Test',
	'Class:Action/Attribute:status/Value:test+' => '',
	'Class:Action/Attribute:status/Value:enabled' => 'V produkcií',
	'Class:Action/Attribute:status/Value:enabled+' => '',
	'Class:Action/Attribute:status/Value:disabled' => 'Neaktívna',
	'Class:Action/Attribute:status/Value:disabled+' => '',
	'Class:Action/Attribute:trigger_list' => 'Súvisiace spúštače',
	'Class:Action/Attribute:trigger_list+' => 'Triggers linked to this action~~',
	'Class:Action/Attribute:finalclass' => 'Typ',
	'Class:Action/Attribute:finalclass+' => '',
	'Action:WarningNoTriggerLinked' => 'Warning, no trigger is linked to the action. It will not be active until it has at least 1.~~',
));

//
// Class: ActionNotification
//

Dict::Add('SK SK', 'Slovak', 'Slovenčina', array(
	'Class:ActionNotification' => 'Upozornenie',
	'Class:ActionNotification+' => '',
));

//
// Class: ActionEmail
//

Dict::Add('SK SK', 'Slovak', 'Slovenčina', array(
	'Class:ActionEmail' => 'Emailová notifikácia',
	'Class:ActionEmail+' => '',
	'Class:ActionEmail/Attribute:status+' => 'This status drives who will be notified: just the Test recipient, all (To, cc and Bcc) or no-one~~',
	'Class:ActionEmail/Attribute:status/Value:test+' => 'Only the Test recipient is notified~~',
	'Class:ActionEmail/Attribute:status/Value:enabled+' => 'All To, Cc and Bcc emails are notified~~',
	'Class:ActionEmail/Attribute:status/Value:disabled+' => 'The email notification will not be sent~~',
	'Class:ActionEmail/Attribute:test_recipient' => 'Testovací príjemca',
	'Class:ActionEmail/Attribute:test_recipient+' => '',
	'Class:ActionEmail/Attribute:from' => 'Od~~',
	'Class:ActionEmail/Attribute:from+' => '',
	'Class:ActionEmail/Attribute:from_label' => 'From (label)~~',
	'Class:ActionEmail/Attribute:from_label+' => 'Sender display name will be sent into the email header~~',
	'Class:ActionEmail/Attribute:reply_to' => 'Odpoveď na~~',
	'Class:ActionEmail/Attribute:reply_to+' => '',
	'Class:ActionEmail/Attribute:reply_to_label' => 'Reply to (label)~~',
	'Class:ActionEmail/Attribute:reply_to_label+' => 'Reply to display name will be sent into the email header~~',
	'Class:ActionEmail/Attribute:to' => 'Komu',
	'Class:ActionEmail/Attribute:to+' => '',
	'Class:ActionEmail/Attribute:cc' => 'Kópia',
	'Class:ActionEmail/Attribute:cc+' => '',
	'Class:ActionEmail/Attribute:bcc' => 'Skrytá kópia',
	'Class:ActionEmail/Attribute:bcc+' => '',
	'Class:ActionEmail/Attribute:subject' => 'Predmet',
	'Class:ActionEmail/Attribute:subject+' => '',
	'Class:ActionEmail/Attribute:body' => 'Telo',
	'Class:ActionEmail/Attribute:body+' => '',
	'Class:ActionEmail/Attribute:importance' => 'Dôležitosť',
	'Class:ActionEmail/Attribute:importance+' => '',
	'Class:ActionEmail/Attribute:importance/Value:low' => 'Nízka',
	'Class:ActionEmail/Attribute:importance/Value:low+' => '',
	'Class:ActionEmail/Attribute:importance/Value:normal' => 'Normálna',
	'Class:ActionEmail/Attribute:importance/Value:normal+' => '',
	'Class:ActionEmail/Attribute:importance/Value:high' => 'Vysoká',
	'Class:ActionEmail/Attribute:importance/Value:high+' => '',
	'Class:ActionEmail/Attribute:language' => 'Language~~',
	'Class:ActionEmail/Attribute:language+' => 'Language to use for placeholders ($xxx$) inside the message (state, importance, priority, etc)~~',
	'Class:ActionEmail/Attribute:html_template' => 'HTML template~~',
	'Class:ActionEmail/Attribute:html_template+' => 'Optional HTML template wrapping around the content of the \'Body\' attribute below, useful for tailored email layouts (in the template, content of the \'Body\' attribute will replace the $content$ placeholder)~~',
	'Class:ActionEmail/Attribute:ignore_notify' => 'Ignore the Notify flag~~',
	'Class:ActionEmail/Attribute:ignore_notify+' => 'If set to \'Yes\' the \'Notify\' flag on Contacts has no effect.~~',
	'Class:ActionEmail/Attribute:ignore_notify/Value:no' => 'No~~',
	'Class:ActionEmail/Attribute:ignore_notify/Value:yes' => 'Yes~~',
	'ActionEmail:main' => 'Message~~',
	'ActionEmail:trigger' => 'Triggers~~',
	'ActionEmail:recipients' => 'Contacts~~',
	'ActionEmail:preview_tab' => 'Preview~~',
	'ActionEmail:preview_tab+' => 'Preview of the eMail template~~',
	'ActionEmail:preview_warning' => 'The actual eMail may look different in the eMail client than this preview in your browser.~~',
	'ActionEmail:preview_more_info' => 'For more information about the CSS features supported by the different eMail clients, refer to %1$s~~',
	'ActionEmail:content_placeholder_missing' => 'The placeholder "%1$s" was not found in the HTML template. The content of the field "%2$s" will not be included in the generated emails.~~',
));

//
// Class: Trigger
//

Dict::Add('SK SK', 'Slovak', 'Slovenčina', array(
	'Class:Trigger' => 'Spúštač',
	'Class:Trigger+' => '',
	'Class:Trigger/ComplementaryName' => '%1$s, %2$s~~',
	'Class:Trigger/Attribute:description' => 'Popis',
	'Class:Trigger/Attribute:description+' => '',
	'Class:Trigger/Attribute:action_list' => 'Spúšťané akcie',
	'Class:Trigger/Attribute:action_list+' => 'Actions performed when the trigger is activated~~',
	'Class:Trigger/Attribute:finalclass' => 'Typ',
	'Class:Trigger/Attribute:finalclass+' => '',
	'Class:Trigger/Attribute:context' => 'Context~~',
	'Class:Trigger/Attribute:context+' => 'Context to allow the trigger to start~~',
	'Class:Trigger/Attribute:complement' => 'Additional information~~',
	'Class:Trigger/Attribute:complement+' => 'Further information as provided in english, by this trigger~~',
));

//
// Class: TriggerOnObject
//

Dict::Add('SK SK', 'Slovak', 'Slovenčina', array(
	'Class:TriggerOnObject' => 'Spúštač (pre danú triedu)',
	'Class:TriggerOnObject+' => '',
	'Class:TriggerOnObject/Attribute:target_class' => 'Cieľová trieda',
	'Class:TriggerOnObject/Attribute:target_class+' => '',
	'Class:TriggerOnObject/Attribute:filter' => 'Filter~~',
	'Class:TriggerOnObject/Attribute:filter+' => 'Limit the object list (of the target class) which will activate the trigger~~',
	'TriggerOnObject:WrongFilterQuery' => 'Wrong filter query: %1$s~~',
	'TriggerOnObject:WrongFilterClass' => 'The filter query must return objects of class "%1$s"~~',
));

//
// Class: TriggerOnPortalUpdate
//

Dict::Add('SK SK', 'Slovak', 'Slovenčina', array(
	'Class:TriggerOnPortalUpdate' => 'Spúštač (pri aktualizácií z portálu)',
	'Class:TriggerOnPortalUpdate+' => '',
));

//
// Class: TriggerOnStateChange
//

Dict::Add('SK SK', 'Slovak', 'Slovenčina', array(
	'Class:TriggerOnStateChange' => 'Spúšťač (pri zmene stavu)',
	'Class:TriggerOnStateChange+' => '',
	'Class:TriggerOnStateChange/Attribute:state' => 'Stav',
	'Class:TriggerOnStateChange/Attribute:state+' => '',
));

//
// Class: TriggerOnStateEnter
//

Dict::Add('SK SK', 'Slovak', 'Slovenčina', array(
	'Class:TriggerOnStateEnter' => 'Spúštač (pri vstupe do stavu)',
	'Class:TriggerOnStateEnter+' => '',
));

//
// Class: TriggerOnStateLeave
//

Dict::Add('SK SK', 'Slovak', 'Slovenčina', array(
	'Class:TriggerOnStateLeave' => 'Spúštač (pri opustení stavu)',
	'Class:TriggerOnStateLeave+' => '',
));

//
// Class: TriggerOnObjectCreate
//

Dict::Add('SK SK', 'Slovak', 'Slovenčina', array(
	'Class:TriggerOnObjectCreate' => 'Spúštač (pri vytvoreni objektu)',
	'Class:TriggerOnObjectCreate+' => '',
));

//
// Class: TriggerOnObjectDelete
//

Dict::Add('SK SK', 'Slovak', 'Slovenčina', array(
	'Class:TriggerOnObjectDelete' => 'Trigger (on object deletion)~~',
	'Class:TriggerOnObjectDelete+' => 'Trigger on object deletion of [a child class of] the given class~~',
));

//
// Class: TriggerOnObjectUpdate
//

Dict::Add('SK SK', 'Slovak', 'Slovenčina', array(
	'Class:TriggerOnObjectUpdate' => 'Trigger (on object update)~~',
	'Class:TriggerOnObjectUpdate+' => 'Trigger on object update of [a child class of] the given class~~',
	'Class:TriggerOnObjectUpdate/Attribute:target_attcodes' => 'Target fields~~',
	'Class:TriggerOnObjectUpdate/Attribute:target_attcodes+' => '',
));

//
// Class: TriggerOnObjectMention
//

Dict::Add('SK SK', 'Slovak', 'Slovenčina', array(
	'Class:TriggerOnObjectMention' => 'Trigger (on object mention)~~',
	'Class:TriggerOnObjectMention+' => 'Trigger on mention (@xxx) of an object of [a child class of] the given class in a log attribute~~',
	'Class:TriggerOnObjectMention/Attribute:mentioned_filter' => 'Mentioned filter~~',
	'Class:TriggerOnObjectMention/Attribute:mentioned_filter+' => 'Limit the list of mentioned objects which will activate the trigger. If empty, any mentioned object (of any class) will activate it.~~',
));

//
// Class: TriggerOnAttributeBlobDownload
//

Dict::Add('SK SK', 'Slovak', 'Slovenčina', array(
	'Class:TriggerOnAttributeBlobDownload' => 'Trigger (on object\'s document download)~~',
	'Class:TriggerOnAttributeBlobDownload+' => 'Trigger on object\'s document field download of [a child class of] the given class~~',
	'Class:TriggerOnAttributeBlobDownload/Attribute:target_attcodes' => 'Target fields~~',
	'Class:TriggerOnAttributeBlobDownload/Attribute:target_attcodes+' => '~~',
));

//
// Class: TriggerOnThresholdReached
//

Dict::Add('SK SK', 'Slovak', 'Slovenčina', array(
	'Class:TriggerOnThresholdReached' => 'Spúštač (pri prekročení hranice)',
	'Class:TriggerOnThresholdReached+' => '',
	'Class:TriggerOnThresholdReached/Attribute:stop_watch_code' => 'Stopky',
	'Class:TriggerOnThresholdReached/Attribute:stop_watch_code+' => '',
	'Class:TriggerOnThresholdReached/Attribute:threshold_index' => 'Hranica',
	'Class:TriggerOnThresholdReached/Attribute:threshold_index+' => '',
));

//
// Class: lnkTriggerAction
//

Dict::Add('SK SK', 'Slovak', 'Slovenčina', array(
	'Class:lnkTriggerAction' => 'Akcia/Spúštač',
	'Class:lnkTriggerAction+' => '',
	'Class:lnkTriggerAction/Attribute:action_id' => 'Akcia',
	'Class:lnkTriggerAction/Attribute:action_id+' => '',
	'Class:lnkTriggerAction/Attribute:action_name' => 'Akcia',
	'Class:lnkTriggerAction/Attribute:action_name+' => '',
	'Class:lnkTriggerAction/Attribute:trigger_id' => 'Spúštač',
	'Class:lnkTriggerAction/Attribute:trigger_id+' => '',
	'Class:lnkTriggerAction/Attribute:trigger_name' => 'Spúštač',
	'Class:lnkTriggerAction/Attribute:trigger_name+' => '',
	'Class:lnkTriggerAction/Attribute:order' => 'Príkaz',
	'Class:lnkTriggerAction/Attribute:order+' => '',
));

//
// Synchro Data Source
//
Dict::Add('SK SK', 'Slovak', 'Slovenčina', array(
	'Class:SynchroDataSource' => 'Synchronizovaný zdroj dát',
	'Class:SynchroDataSource/Attribute:name' => 'Názov',
	'Class:SynchroDataSource/Attribute:name+' => '',
	'Class:SynchroDataSource/Attribute:description' => 'Popis',
	'Class:SynchroDataSource/Attribute:status' => 'Stav',
	'Class:SynchroDataSource/Attribute:scope_class' => 'Cieľová trieda',
	'Class:SynchroDataSource/Attribute:scope_class+' => 'A Synchro Data Source can only populate a single '.ITOP_APPLICATION_SHORT.' class~~',
	'Class:SynchroDataSource/Attribute:user_id' => 'Užívateľ',
	'Class:SynchroDataSource/Attribute:notify_contact_id' => 'Notifikovať kontakt',
	'Class:SynchroDataSource/Attribute:notify_contact_id+' => '',
	'Class:SynchroDataSource/Attribute:url_icon' => 'URL ikonky',
	'Class:SynchroDataSource/Attribute:url_icon+' => '',
	'Class:SynchroDataSource/Attribute:url_application' => 'URL aplikácie',
	'Class:SynchroDataSource/Attribute:url_application+' => '',
	'Class:SynchroDataSource/Attribute:reconciliation_policy' => 'Harmonizačná politika',
	'Class:SynchroDataSource/Attribute:reconciliation_policy+' => '"Use the attributes": '.ITOP_APPLICATION_SHORT.' object matches replica values for each Synchro attributes flagged for Reconciliation.
"Use primary_key": the column primary_key of the replica is expected to contain the identifier of the '.ITOP_APPLICATION_SHORT.' object~~',
	'Class:SynchroDataSource/Attribute:full_load_periodicity' => 'Intervaly plného zaťaženia',
	'Class:SynchroDataSource/Attribute:full_load_periodicity+' => '',
	'Class:SynchroDataSource/Attribute:action_on_zero' => 'Akcia pri hodnote nula',
	'Class:SynchroDataSource/Attribute:action_on_zero+' => '',
	'Class:SynchroDataSource/Attribute:action_on_one' => 'Akcia pri hodnote jedna',
	'Class:SynchroDataSource/Attribute:action_on_one+' => '',
	'Class:SynchroDataSource/Attribute:action_on_multiple' => 'Akcia pri viacerých',
	'Class:SynchroDataSource/Attribute:action_on_multiple+' => '',
	'Class:SynchroDataSource/Attribute:user_delete_policy' => 'Užívatelia s povolením',
	'Class:SynchroDataSource/Attribute:user_delete_policy+' => '',
	'Class:SynchroDataSource/Attribute:delete_policy/Value:never' => 'Nikto',
	'Class:SynchroDataSource/Attribute:delete_policy/Value:depends' => 'Len administrátori',
	'Class:SynchroDataSource/Attribute:delete_policy/Value:always' => 'Všetci povolení užívatelia',
	'Class:SynchroDataSource/Attribute:delete_policy_update' => 'Aktualizačné pravidlá',
	'Class:SynchroDataSource/Attribute:delete_policy_update+' => '',
	'Class:SynchroDataSource/Attribute:delete_policy_retention' => 'Doba po ktorú je odstraňovanie pozdržané',
	'Class:SynchroDataSource/Attribute:delete_policy_retention+' => '',
	'Class:SynchroDataSource/Attribute:database_table_name' => 'Tabuľka dát',
	'Class:SynchroDataSource/Attribute:database_table_name+' => '',
	'Class:SynchroDataSource/Attribute:status/Value:implementation' => 'Implementácia',
	'Class:SynchroDataSource/Attribute:status/Value:obsolete' => 'Vyradené',
	'Class:SynchroDataSource/Attribute:status/Value:production' => 'Produkcia',
	'Class:SynchroDataSource/Attribute:scope_restriction' => 'Obmedzenie rozsahu',
	'Class:SynchroDataSource/Attribute:reconciliation_policy/Value:use_attributes' => 'Použiť atribúty',
	'Class:SynchroDataSource/Attribute:reconciliation_policy/Value:use_primary_key' => 'Použiť pole "Primárny kľúč"',
	'Class:SynchroDataSource/Attribute:action_on_zero/Value:create' => 'Vytvoriť',
	'Class:SynchroDataSource/Attribute:action_on_zero/Value:error' => 'Chyba',
	'Class:SynchroDataSource/Attribute:action_on_one/Value:error' => 'Chyba',
	'Class:SynchroDataSource/Attribute:action_on_one/Value:update' => 'Aktualizácia',
	'Class:SynchroDataSource/Attribute:action_on_multiple/Value:create' => 'Vytvoriť',
	'Class:SynchroDataSource/Attribute:action_on_multiple/Value:error' => 'Chyba',
	'Class:SynchroDataSource/Attribute:action_on_multiple/Value:take_first' => 'Vziať prvý (náhodný?)',
	'Class:SynchroDataSource/Attribute:delete_policy' => 'Politika odstraňovania',
	'Class:SynchroDataSource/Attribute:delete_policy+' => 'What to do when a replica becomes obsolete:
"Ignore": do nothing, the associated object remains as is in iTop.
"Delete": Delete the associated object in iTop (and the replica in the data table).
"Update": Update the associated object as specified by the Update rules (see below).
"Update then Delete": apply the "Update rules". When Retention Duration expires, execute a "Delete" ~~',
	'Class:SynchroDataSource/Attribute:delete_policy/Value:delete' => 'Odstrániť',
	'Class:SynchroDataSource/Attribute:delete_policy/Value:ignore' => 'Ignorovať',
	'Class:SynchroDataSource/Attribute:delete_policy/Value:update' => 'Aktualizovať',
	'Class:SynchroDataSource/Attribute:delete_policy/Value:update_then_delete' => 'Aktualizovať, potom odstrániť',
	'Class:SynchroDataSource/Attribute:attribute_list' => 'Zoznam atribútov',
	'Class:SynchroDataSource/Attribute:user_delete_policy/Value:administrators' => 'Len administrátori',
	'Class:SynchroDataSource/Attribute:user_delete_policy/Value:everybody' => 'Všetci majú povolené odstraňovať takéto objekty',
	'Class:SynchroDataSource/Attribute:user_delete_policy/Value:nobody' => 'Nikto',
	'SynchroDataSource:Description' => 'Popis',
	'SynchroDataSource:Reconciliation' => 'Hľadať &amp; harmonizáciu',
	'SynchroDataSource:Deletion' => 'Pravidlá odstraňovania',
	'SynchroDataSource:Status' => 'Stav',
	'SynchroDataSource:Information' => 'Informácia',
	'SynchroDataSource:Definition' => 'Definícia',
	'Core:SynchroAttributes' => 'Atribúty',
	'Core:SynchroStatus' => 'Stav',
	'Core:Synchro:ErrorsLabel' => 'Chyby',
	'Core:Synchro:CreatedLabel' => 'Vytvorené',
	'Core:Synchro:ModifiedLabel' => 'Upravené',
	'Core:Synchro:UnchangedLabel' => 'Nezmenené',
	'Core:Synchro:ReconciledErrorsLabel' => 'Chyby',
	'Core:Synchro:ReconciledLabel' => 'Schválené',
	'Core:Synchro:ReconciledNewLabel' => 'Vytvorené',
	'Core:SynchroReconcile:Yes' => 'Áno',
	'Core:SynchroReconcile:No' => 'Nie',
	'Core:SynchroUpdate:Yes' => 'Áno',
	'Core:SynchroUpdate:No' => 'Nie',
	'Core:Synchro:LastestStatus' => 'Posledný stav',
	'Core:Synchro:History' => 'Synchronizačná História',
	'Core:Synchro:NeverRun' => 'Táto synchronizácia nikdy nebežala. Zatiaľ bez záznamu .',
	'Core:Synchro:SynchroEndedOn_Date' => 'Posledná synchronizácia skončila: %1$s.',
	'Core:Synchro:SynchroRunningStartedOn_Date' => 'The Synchronizácia spustené %1$s stále beží...',
	'Menu:DataSources' => 'Synchronizované zdroje dát',
    // Duplicated into itop-welcome-itil (will be removed from here...)
	'Menu:DataSources+' => '',
    // Duplicated into itop-welcome-itil (will be removed from here...)
	'Core:Synchro:label_repl_ignored' => 'Ignorované (%1$s)',
	'Core:Synchro:label_repl_disappeared' => 'Zmiznuté (%1$s)',
	'Core:Synchro:label_repl_existing' => 'Existujúce (%1$s)',
	'Core:Synchro:label_repl_new' => 'Nové (%1$s)',
	'Core:Synchro:label_obj_deleted' => 'Odstránené (%1$s)',
	'Core:Synchro:label_obj_obsoleted' => 'Vyradené (%1$s)',
	'Core:Synchro:label_obj_disappeared_errors' => 'Chyby (%1$s)',
	'Core:Synchro:label_obj_disappeared_no_action' => 'Bez akcie (%1$s)',
	'Core:Synchro:label_obj_unchanged' => 'Nezmenené (%1$s)',
	'Core:Synchro:label_obj_updated' => 'Aktualizované (%1$s)',
	'Core:Synchro:label_obj_updated_errors' => 'Chyby (%1$s)',
	'Core:Synchro:label_obj_new_unchanged' => 'Nezmenené (%1$s)',
	'Core:Synchro:label_obj_new_updated' => 'Aktualizované (%1$s)',
	'Core:Synchro:label_obj_created' => 'Vytvorené (%1$s)',
	'Core:Synchro:label_obj_new_errors' => 'Chyby (%1$s)',
	'Core:SynchroLogTitle' => '%1$s - %2$s',
	'Core:Synchro:Nb_Replica' => 'Spracovaných replík: %1$s',
	'Core:Synchro:Nb_Class:Objects' => '%1$s: %2$s',
	'Class:SynchroDataSource/Error:AtLeastOneReconciliationKeyMustBeSpecified' => 'Aspoň jeden harmonizačný kľúč musí byť špecifikovaný, alebo harmonizačná politika musí obsahovať používanie primárneho kľúča.',
	'Class:SynchroDataSource/Error:DeleteRetentionDurationMustBeSpecified' => 'Doba po ktorú je odstraňovanie pozdržané musí byť špecifikovaná, keďže objekty budú odstránené po ich označení ako vyradené',
	'Class:SynchroDataSource/Error:DeletePolicyUpdateMustBeSpecified' => 'Vyradené objekty majú byť aktualizované, ale žiadna aktualizácia nie je špecifikovaná.',
	'Class:SynchroDataSource/Error:DataTableAlreadyExists' => 'Tabuľka %1$s už existuje v databáze. Prosím použite iné meno pre synchronizačnú dátovú tabuľku.',
	'Core:SynchroReplica:PublicData' => 'Verejné dáta',
	'Core:SynchroReplica:PrivateDetails' => 'Skryté detaily',
	'Core:SynchroReplica:BackToDataSource' => 'Návrat späť na synchronizáčný zdroj dát: %1$s',
	'Core:SynchroReplica:ListOfReplicas' => 'Zoznam replík',
	'Core:SynchroAttExtKey:ReconciliationById' => 'ID (primárny kľúč)',
	'Core:SynchroAtt:attcode' => 'Atribút',
	'Core:SynchroAtt:attcode+' => '',
	'Core:SynchroAtt:reconciliation' => 'Harmonizácia ?',
	'Core:SynchroAtt:reconciliation+' => '',
	'Core:SynchroAtt:update' => 'Aktualizácia',
	'Core:SynchroAtt:update+' => '',
	'Core:SynchroAtt:update_policy' => 'Politika aktualizácií',
	'Core:SynchroAtt:update_policy+' => '',
	'Core:SynchroAtt:reconciliation_attcode' => 'Harmonizačný kľúč',
	'Core:SynchroAtt:reconciliation_attcode+' => '',
	'Core:SyncDataExchangeComment' => '(Synchronizácia dát)',
	'Core:Synchro:ListOfDataSources' => 'Zoznam zdrojov dát:',
	'Core:Synchro:LastSynchro' => 'Posledná synchronizácia:',
	'Core:Synchro:ThisObjectIsSynchronized' => 'Tento objekt je synchronizovaný s externým zdrojom dát',
	'Core:Synchro:TheObjectWasCreatedBy_Source' => 'Objekt bol <b>vytvorený</b> externým zdrojom dát %1$s',
	'Core:Synchro:TheObjectCanBeDeletedBy_Source' => 'Objekt <b>môže byť odstránený</b> externým zdrojom dát %1$s',
	'Core:Synchro:TheObjectCannotBeDeletedByUser_Source' => '<b>Nemôžete odstrániť tento objekt</b> pretože je vlastnený externým zdrojom dát %1$s',
	'TitleSynchroExecution' => 'Vykonanie synchronizácie',
	'Class:SynchroDataSource:DataTable' => 'Databázová tabuľka: %1$s',
	'Core:SyncDataSourceObsolete' => 'Dátový zdroj je označený ako vyradený. Operácia zrušená.',
	'Core:SyncDataSourceAccessRestriction' => 'Iba adminstrátori alebo užívateľ špecifikovaný v dátovom zdroji môžu vykonať túto operáciu. Operácia zrušená.',
	'Core:SyncTooManyMissingReplicas' => 'Žiaden záznam nebol po určitý čas dotknutý (všetky objekty by mohli byť odstránené). Prosím skontrolujte, že proces, ktorý zapisuje do synchronizačnej tabuľky, stále beží. Operácia zrušená.',
	'Core:SyncSplitModeCLIOnly' => 'Synchronizácia môže byť vykonaná po častiach iba ak bola spustená v móde CLI',
	'Core:Synchro:ListReplicas_AllReplicas_Errors_Warnings' => '%1$s replík, %2$s chýb, %3$s upozornení.',
	'Core:SynchroReplica:TargetObject' => 'Synchronizovaný objekt: %1$s',
	'Class:AsyncSendEmail' => 'Email (asynchrónny)',
	'Class:AsyncSendEmail/Attribute:to' => 'Komu',
	'Class:AsyncSendEmail/Attribute:subject' => 'Predmet',
	'Class:AsyncSendEmail/Attribute:body' => 'Telo',
	'Class:AsyncSendEmail/Attribute:header' => 'Hlavička',
	'Class:CMDBChangeOpSetAttributeOneWayPassword' => 'Zakódované heslo',
	'Class:CMDBChangeOpSetAttributeOneWayPassword/Attribute:prev_pwd' => 'Predchádzajúca hodnota',
	'Class:CMDBChangeOpSetAttributeEncrypted' => 'Zakódované pole',
	'Class:CMDBChangeOpSetAttributeEncrypted/Attribute:prevstring' => 'Predchádzajúca hodnota',
	'Class:CMDBChangeOpSetAttributeCaseLog' => 'Záznam o riešení',
	'Class:CMDBChangeOpSetAttributeCaseLog/Attribute:lastentry' => 'Posledný záznam',
	'Class:SynchroAttribute' => 'Synchronizovaný atribút',
	'Class:SynchroAttribute/Attribute:sync_source_id' => 'Synchronizovaný zdroj dát',
	'Class:SynchroAttribute/Attribute:attcode' => 'Kód atribútu',
	'Class:SynchroAttribute/Attribute:update' => 'Aktualizovať',
	'Class:SynchroAttribute/Attribute:reconcile' => 'Harmonizovať',
	'Class:SynchroAttribute/Attribute:update_policy' => 'Politika aktualizácií',
	'Class:SynchroAttribute/Attribute:update_policy/Value:master_locked' => 'Uzamknuté',
	'Class:SynchroAttribute/Attribute:update_policy/Value:master_unlocked' => 'Odomknuté',
	'Class:SynchroAttribute/Attribute:update_policy/Value:write_if_empty' => 'Inicializovať, ak je prázdne',
	'Class:SynchroAttribute/Attribute:finalclass' => 'Trieda',
	'Class:SynchroAttExtKey' => 'Synchronizačný atribút (ExtKey)',
	'Class:SynchroAttExtKey/Attribute:reconciliation_attcode' => 'Harmonizačný atribút',
	'Class:SynchroAttLinkSet' => 'Synchronizačný atribút (linkset)',
	'Class:SynchroAttLinkSet/Attribute:row_separator' => 'Oddelovač riadkov',
	'Class:SynchroAttLinkSet/Attribute:attribute_separator' => 'Oddelovač atribútov',
	'Class:SynchroLog' => 'Synchronizačný záznam',
	'Class:SynchroLog/Attribute:sync_source_id' => 'Synchronizovaný zdroj dát',
	'Class:SynchroLog/Attribute:start_date' => 'Dátum začiatku',
	'Class:SynchroLog/Attribute:end_date' => 'Dátum ukončenia',
	'Class:SynchroLog/Attribute:status' => 'Stav',
	'Class:SynchroLog/Attribute:status/Value:completed' => 'Ukončené',
	'Class:SynchroLog/Attribute:status/Value:error' => 'Chyba',
	'Class:SynchroLog/Attribute:status/Value:running' => 'Stále bežiace',
	'Class:SynchroLog/Attribute:stats_nb_replica_seen' => 'Počet videných replík',
	'Class:SynchroLog/Attribute:stats_nb_replica_total' => 'Počet replík celkom',
	'Class:SynchroLog/Attribute:stats_nb_obj_deleted' => 'Počet odstránených objektov',
	'Class:SynchroLog/Attribute:stats_nb_obj_deleted_errors' => 'Počet chýb počas odstraňovania',
	'Class:SynchroLog/Attribute:stats_nb_obj_obsoleted' => 'Počet objektov označených ako vyradené',
	'Class:SynchroLog/Attribute:stats_nb_obj_obsoleted_errors' => 'Počet chýb počas označovania objektov ako vyradené',
	'Class:SynchroLog/Attribute:stats_nb_obj_created' => 'Počet vytvorených objektov',
	'Class:SynchroLog/Attribute:stats_nb_obj_created_errors' => 'Počet chýb počas vytvárania',
	'Class:SynchroLog/Attribute:stats_nb_obj_updated' => 'Počet aktualizovaných objektov',
	'Class:SynchroLog/Attribute:stats_nb_obj_updated_errors' => 'Počet chýb počas aktualizácie',
	'Class:SynchroLog/Attribute:stats_nb_replica_reconciled_errors' => 'Počet chýb počas harmonizácie',
	'Class:SynchroLog/Attribute:stats_nb_replica_disappeared_no_action' => 'Počet zmiznutých replík',
	'Class:SynchroLog/Attribute:stats_nb_obj_new_updated' => 'Počet aktualizovaných objektov',
	'Class:SynchroLog/Attribute:stats_nb_obj_new_unchanged' => 'Počet nezmenených objektov',
	'Class:SynchroLog/Attribute:last_error' => 'Posledná chyba',
	'Class:SynchroLog/Attribute:traces' => 'Stopy',
	'Class:SynchroReplica' => 'Synchronizačná replika',
	'Class:SynchroReplica/Attribute:sync_source_id' => 'Synchronizovaný zdroj dát',
	'Class:SynchroReplica/Attribute:dest_id' => 'Cieľový objekt (ID)',
	'Class:SynchroReplica/Attribute:dest_class' => 'Cieľový Typ',
	'Class:SynchroReplica/Attribute:status_last_seen' => 'Naposledy videná',
	'Class:SynchroReplica/Attribute:status' => 'Stav',
	'Class:SynchroReplica/Attribute:status/Value:modified' => 'Upravená',
	'Class:SynchroReplica/Attribute:status/Value:new' => 'Nová',
	'Class:SynchroReplica/Attribute:status/Value:obsolete' => 'Vyradená',
	'Class:SynchroReplica/Attribute:status/Value:orphan' => 'Sirota',
	'Class:SynchroReplica/Attribute:status/Value:synchronized' => 'Synchronizovaná',
	'Class:SynchroReplica/Attribute:status_dest_creator' => 'Objekt vytvorený ?',
	'Class:SynchroReplica/Attribute:status_last_error' => 'Posledná chyba',
	'Class:SynchroReplica/Attribute:status_last_warning' => 'Upozornenia',
	'Class:SynchroReplica/Attribute:info_creation_date' => 'Dátum vytvorenia',
	'Class:SynchroReplica/Attribute:info_last_modified' => 'Dátum poslednej úpravy',
	'Class:appUserPreferences' => 'Užívateľské preferencie',
	'Class:appUserPreferences/Attribute:userid' => 'Užívateľ',
	'Class:appUserPreferences/Attribute:preferences' => 'Preferencie',
	'Core:ExecProcess:Code1' => 'Nesprávny príkaz alebo príkaz skončil s chybami (napr. nesprávne meno skriptu)',
	'Core:ExecProcess:Code255' => 'PHP chyba (pri parsovaní, alebo počas behu)',
    // Attribute Duration
	'Core:Duration_Seconds' => '%1$ds',
	'Core:Duration_Minutes_Seconds' => '%1$dmin %2$ds',
	'Core:Duration_Hours_Minutes_Seconds' => '%1$dh %2$dmin %3$ds',
	'Core:Duration_Days_Hours_Minutes_Seconds' => '%1$sd %2$dh %3$dmin %4$ds',
    // Explain working time computing
	'Core:ExplainWTC:ElapsedTime' => 'Time elapsed (stored as "%1$s")~~',
	'Core:ExplainWTC:StopWatch-TimeSpent' => 'Time spent for "%1$s"~~',
	'Core:ExplainWTC:StopWatch-Deadline' => 'Deadline for "%1$s" at %2$d%%~~',
    // Bulk export
	'Core:BulkExport:MissingParameter_Param' => 'Missing parameter "%1$s"~~',
	'Core:BulkExport:InvalidParameter_Query' => 'Invalid value for the parameter "query". There is no Query Phrasebook corresponding to the id: "%1$s".~~',
	'Core:BulkExport:ExportFormatPrompt' => 'Export format:~~',
	'Core:BulkExportOf_Class' => '%1$s Export~~',
	'Core:BulkExport:ClickHereToDownload_FileName' => 'Click here to download %1$s~~',
	'Core:BulkExport:ExportResult' => 'Result of the export:~~',
	'Core:BulkExport:RetrievingData' => 'Retrieving data...~~',
	'Core:BulkExport:HTMLFormat' => 'Web Page (*.html)~~',
	'Core:BulkExport:CSVFormat' => 'Comma Separated Values (*.csv)~~',
	'Core:BulkExport:XLSXFormat' => 'Excel 2007 or newer (*.xlsx)~~',
	'Core:BulkExport:PDFFormat' => 'PDF Document (*.pdf)~~',
	'Core:BulkExport:DragAndDropHelp' => 'Drag and drop the columns\' headers to arrange the columns. Preview of %1$s lines. Total number of lines to export: %2$s.~~',
	'Core:BulkExport:EmptyPreview' => 'Select the columns to be exported from the list above~~',
	'Core:BulkExport:ColumnsOrder' => 'Columns order~~',
	'Core:BulkExport:AvailableColumnsFrom_Class' => 'Available columns from %1$s~~',
	'Core:BulkExport:NoFieldSelected' => 'Select at least one column to be exported~~',
	'Core:BulkExport:CheckAll' => 'Check All~~',
	'Core:BulkExport:UncheckAll' => 'Uncheck All~~',
	'Core:BulkExport:ExportCancelledByUser' => 'Export cancelled by the user~~',
	'Core:BulkExport:CSVOptions' => 'CSV Options~~',
	'Core:BulkExport:CSVLocalization' => 'Localization~~',
	'Core:BulkExport:PDFOptions' => 'PDF Options~~',
	'Core:BulkExport:PDFPageFormat' => 'Page Format~~',
	'Core:BulkExport:PDFPageSize' => 'Page Size:~~',
	'Core:BulkExport:PageSize-A4' => 'A4~~',
	'Core:BulkExport:PageSize-A3' => 'A3~~',
	'Core:BulkExport:PageSize-Letter' => 'Letter~~',
	'Core:BulkExport:PDFPageOrientation' => 'Page Orientation:~~',
	'Core:BulkExport:PageOrientation-L' => 'Landscape~~',
	'Core:BulkExport:PageOrientation-P' => 'Portrait~~',
	'Core:BulkExport:XMLFormat' => 'XML file (*.xml)~~',
	'Core:BulkExport:XMLOptions' => 'XML Options~~',
	'Core:BulkExport:SpreadsheetFormat' => 'Spreadsheet HTML format (*.html)~~',
	'Core:BulkExport:SpreadsheetOptions' => 'Spreadsheet Options~~',
	'Core:BulkExport:OptionNoLocalize' => 'Export Code instead of Label~~',
	'Core:BulkExport:OptionLinkSets' => 'Include linked objects~~',
	'Core:BulkExport:OptionFormattedText' => 'Preserve text formatting~~',
	'Core:BulkExport:ScopeDefinition' => 'Definition of the objects to export~~',
	'Core:BulkExportLabelOQLExpression' => 'OQL Query:~~',
	'Core:BulkExportLabelPhrasebookEntry' => 'Query Phrasebook Entry:~~',
	'Core:BulkExportMessageEmptyOQL' => 'Please enter a valid OQL query.~~',
	'Core:BulkExportMessageEmptyPhrasebookEntry' => 'Please select a valid phrasebook entry.~~',
	'Core:BulkExportQueryPlaceholder' => 'Type an OQL query here...~~',
	'Core:BulkExportCanRunNonInteractive' => 'Click here to run the export in non-interactive mode.~~',
	'Core:BulkExportLegacyExport' => 'Click here to access the legacy export.~~',
	'Core:BulkExport:XLSXOptions' => 'Excel Options~~',
	'Core:BulkExport:TextFormat' => 'Text fields containing some HTML markup~~',
	'Core:BulkExport:DateTimeFormat' => 'Date and Time format~~',
	'Core:BulkExport:DateTimeFormatDefault_Example' => 'Default format (%1$s), e.g. %2$s~~',
	'Core:BulkExport:DateTimeFormatCustom_Format' => 'Custom format: %1$s~~',
	'Core:BulkExport:PDF:PageNumber' => 'Page %1$s~~',
	'Core:DateTime:Placeholder_d' => 'DD~~',
    // Day of the month: 2 digits (with leading zero)
	'Core:DateTime:Placeholder_j' => 'D~~',
    // Day of the month: 1 or 2 digits (without leading zero)
	'Core:DateTime:Placeholder_m' => 'MM~~',
    // Month on 2 digits i.e. 01-12
	'Core:DateTime:Placeholder_n' => 'M~~',
    // Month on 1 or 2 digits 1-12
	'Core:DateTime:Placeholder_Y' => 'YYYY~~',
    // Year on 4 digits
	'Core:DateTime:Placeholder_y' => 'YY~~',
    // Year on 2 digits
	'Core:DateTime:Placeholder_H' => 'hh~~',
    // Hour 00..23
	'Core:DateTime:Placeholder_h' => 'h~~',
    // Hour 01..12
	'Core:DateTime:Placeholder_G' => 'hh~~',
    // Hour 0..23
	'Core:DateTime:Placeholder_g' => 'h~~',
    // Hour 1..12
	'Core:DateTime:Placeholder_a' => 'am/pm~~',
    // am/pm (lowercase)
	'Core:DateTime:Placeholder_A' => 'AM/PM~~',
    // AM/PM (uppercase)
	'Core:DateTime:Placeholder_i' => 'mm~~',
    // minutes, 2 digits: 00..59
	'Core:DateTime:Placeholder_s' => 'ss~~',
    // seconds, 2 digits 00..59
	'Core:Validator:Default' => 'Wrong format~~',
	'Core:Validator:Mandatory' => 'Please, fill this field~~',
	'Core:Validator:MustBeInteger' => 'Must be an integer~~',
	'Core:Validator:MustSelectOne' => 'Please, select one~~',
));

//
// Class: TagSetFieldData
//
Dict::Add('SK SK', 'Slovak', 'Slovenčina', array(
	'Class:TagSetFieldData' => '%2$s for class %1$s~~',
	'Class:TagSetFieldData+' => '',
	'Class:TagSetFieldData/Attribute:code' => 'Code~~',
	'Class:TagSetFieldData/Attribute:code+' => 'Internal code. Must contain at least 3 alphanumeric characters~~',
	'Class:TagSetFieldData/Attribute:label' => 'Label~~',
	'Class:TagSetFieldData/Attribute:label+' => 'Displayed label~~',
	'Class:TagSetFieldData/Attribute:description' => 'Description~~',
	'Class:TagSetFieldData/Attribute:description+' => '',
	'Class:TagSetFieldData/Attribute:finalclass' => 'Tag class~~~~',
	'Class:TagSetFieldData/Attribute:obj_class' => 'Object class~~~~',
	'Class:TagSetFieldData/Attribute:obj_attcode' => 'Field code~~~~',
	'Core:TagSetFieldData:ErrorDeleteUsedTag' => 'Used tags cannot be deleted~~',
	'Core:TagSetFieldData:ErrorDuplicateTagCodeOrLabel' => 'Tags codes or labels must be unique~~',
	'Core:TagSetFieldData:ErrorTagCodeSyntax' => 'Tags code must contain between 3 and %1$d alphanumeric characters, starting with a letter.~~',
	'Core:TagSetFieldData:ErrorTagCodeReservedWord' => 'The chosen tag code is a reserved word~~',
	'Core:TagSetFieldData:ErrorTagLabelSyntax' => 'Tags label must not contain \'%1$s\' nor be empty~~',
	'Core:TagSetFieldData:ErrorCodeUpdateNotAllowed' => 'Tags Code cannot be changed when used~~',
	'Core:TagSetFieldData:ErrorClassUpdateNotAllowed' => 'Tags "Object Class" cannot be changed~~',
	'Core:TagSetFieldData:ErrorAttCodeUpdateNotAllowed' => 'Tags "Attribute Code" cannot be changed~~',
	'Core:TagSetFieldData:WhereIsThisTagTab' => 'Tag usage (%1$d)~~',
	'Core:TagSetFieldData:NoEntryFound' => 'No entry found for this tag~~',
));

//
// Class: DBProperty
//
Dict::Add('SK SK', 'Slovak', 'Slovenčina', array(
	'Class:DBProperty' => 'DB property~~',
	'Class:DBProperty+' => '',
	'Class:DBProperty/Attribute:name' => 'Name~~',
	'Class:DBProperty/Attribute:name+' => '',
	'Class:DBProperty/Attribute:description' => 'Description~~',
	'Class:DBProperty/Attribute:description+' => '',
	'Class:DBProperty/Attribute:value' => 'Value~~',
	'Class:DBProperty/Attribute:value+' => '',
	'Class:DBProperty/Attribute:change_date' => 'Change date~~',
	'Class:DBProperty/Attribute:change_date+' => '',
	'Class:DBProperty/Attribute:change_comment' => 'Change comment~~',
	'Class:DBProperty/Attribute:change_comment+' => '',
));

//
// Class: BackgroundTask
//
Dict::Add('SK SK', 'Slovak', 'Slovenčina', array(
	'Class:BackgroundTask' => 'Background task~~',
	'Class:BackgroundTask+' => '',
	'Class:BackgroundTask/Attribute:class_name' => 'Class name~~',
	'Class:BackgroundTask/Attribute:class_name+' => '',
	'Class:BackgroundTask/Attribute:first_run_date' => 'First run date~~',
	'Class:BackgroundTask/Attribute:first_run_date+' => '',
	'Class:BackgroundTask/Attribute:latest_run_date' => 'Latest run date~~',
	'Class:BackgroundTask/Attribute:latest_run_date+' => '',
	'Class:BackgroundTask/Attribute:next_run_date' => 'Next run date~~',
	'Class:BackgroundTask/Attribute:next_run_date+' => '',
	'Class:BackgroundTask/Attribute:total_exec_count' => 'Total exec. count~~',
	'Class:BackgroundTask/Attribute:total_exec_count+' => '',
	'Class:BackgroundTask/Attribute:latest_run_duration' => 'Latest run duration~~',
	'Class:BackgroundTask/Attribute:latest_run_duration+' => '',
	'Class:BackgroundTask/Attribute:min_run_duration' => 'Min. run duration~~',
	'Class:BackgroundTask/Attribute:min_run_duration+' => '',
	'Class:BackgroundTask/Attribute:max_run_duration' => 'Max. run duration~~',
	'Class:BackgroundTask/Attribute:max_run_duration+' => '',
	'Class:BackgroundTask/Attribute:average_run_duration' => 'Average run duration~~',
	'Class:BackgroundTask/Attribute:average_run_duration+' => '',
	'Class:BackgroundTask/Attribute:running' => 'Running~~',
	'Class:BackgroundTask/Attribute:running+' => '',
	'Class:BackgroundTask/Attribute:status' => 'Status~~',
	'Class:BackgroundTask/Attribute:status+' => '',
));

//
// Class: AsyncTask
//
Dict::Add('SK SK', 'Slovak', 'Slovenčina', array(
	'Class:AsyncTask' => 'Async. task~~',
	'Class:AsyncTask+' => '',
	'Class:AsyncTask/Attribute:created' => 'Created~~',
	'Class:AsyncTask/Attribute:created+' => '',
	'Class:AsyncTask/Attribute:started' => 'Started~~',
	'Class:AsyncTask/Attribute:started+' => '',
	'Class:AsyncTask/Attribute:planned' => 'Planned~~',
	'Class:AsyncTask/Attribute:planned+' => '',
	'Class:AsyncTask/Attribute:event_id' => 'Event~~',
	'Class:AsyncTask/Attribute:event_id+' => '',
	'Class:AsyncTask/Attribute:finalclass' => 'Final class~~',
	'Class:AsyncTask/Attribute:finalclass+' => '',
	'Class:AsyncTask/Attribute:status' => 'Status~~',
	'Class:AsyncTask/Attribute:status+' => '',
	'Class:AsyncTask/Attribute:remaining_retries' => 'Remaining retries~~',
	'Class:AsyncTask/Attribute:remaining_retries+' => '',
	'Class:AsyncTask/Attribute:last_error_code' => 'Last error code~~',
	'Class:AsyncTask/Attribute:last_error_code+' => '',
	'Class:AsyncTask/Attribute:last_error' => 'Last error~~',
	'Class:AsyncTask/Attribute:last_error+' => '',
	'Class:AsyncTask/Attribute:last_attempt' => 'Last attempt~~',
	'Class:AsyncTask/Attribute:last_attempt+' => '',
	'Class:AsyncTask:InvalidConfig_Class_Keys' => 'Invalid format for the configuration of "async_task_retries[%1$s]". Expecting an array with the following keys: %2$s~~',
	'Class:AsyncTask:InvalidConfig_Class_InvalidKey_Keys' => 'Invalid format for the configuration of "async_task_retries[%1$s]": unexpected key "%2$s". Expecting only the following keys: %3$s~~',
));

//
// Class: AbstractResource
//

Dict::Add('SK SK', 'Slovak', 'Slovenčina', array(
	'Class:AbstractResource' => 'Abstract Resource~~',
	'Class:AbstractResource+' => '',
));

//
// Class: ResourceAdminMenu
//

Dict::Add('SK SK', 'Slovak', 'Slovenčina', array(
	'Class:ResourceAdminMenu' => 'Resource Admin Menu~~',
	'Class:ResourceAdminMenu+' => '',
));

//
// Class: ResourceRunQueriesMenu
//

Dict::Add('SK SK', 'Slovak', 'Slovenčina', array(
	'Class:ResourceRunQueriesMenu' => 'Resource Run Queries Menu~~',
	'Class:ResourceRunQueriesMenu+' => '',
));

//
// Class: Action
//

Dict::Add('SK SK', 'Slovak', 'Slovenčina', array(
	'Class:ResourceSystemMenu' => 'Resource System Menu~~',
	'Class:ResourceSystemMenu+' => '',
));
// Additional language entries not present in English dict
Dict::Add('SK SK', 'Slovak', 'Slovenčina', array(
	'Class:lnkVirtualDeviceToVolume' => 'väzba Virtuálne zariadenie / Logický disk',
	'Class:lnkVirtualDeviceToVolume+' => '',
	'Class:lnkVirtualDeviceToVolume/Attribute:volume_id' => 'Logický disk',
	'Class:lnkVirtualDeviceToVolume/Attribute:volume_id+' => '',
	'Class:lnkVirtualDeviceToVolume/Attribute:virtualdevice_id' => 'Virtuálne zariadenie',
	'Class:lnkVirtualDeviceToVolume/Attribute:virtualdevice_id+' => '',
	'Class:lnkVirtualDeviceToVolume/Attribute:size_used' => 'Použité miesto',
	'Class:lnkVirtualDeviceToVolume/Attribute:size_used+' => '',
	'Class:Organization' => 'Organizácia',
	'Class:Organization+' => '',
	'Class:Organization/Attribute:name' => 'Názov',
	'Class:Organization/Attribute:name+' => '',
	'Class:Organization/Attribute:code' => 'Kód',
	'Class:Organization/Attribute:code+' => '',
	'Class:Organization/Attribute:status' => 'Stav',
	'Class:Organization/Attribute:status+' => '',
	'Class:Organization/Attribute:status/Value:active' => 'Aktívna',
	'Class:Organization/Attribute:status/Value:active+' => '',
	'Class:Organization/Attribute:status/Value:inactive' => 'Neaktívna',
	'Class:Organization/Attribute:status/Value:inactive+' => '',
	'Class:Organization/Attribute:parent_id' => 'Nadradená organizácia',
	'Class:Organization/Attribute:parent_id+' => '',
	'Class:Organization/Attribute:deliverymodel_id' => 'Model dodávky',
	'Class:Organization/Attribute:deliverymodel_id+' => '',
	'Class:Location' => 'Poloha',
	'Class:Location+' => '',
	'Class:Location/Attribute:name' => 'Názov',
	'Class:Location/Attribute:name+' => '',
	'Class:Location/Attribute:status' => 'Stav',
	'Class:Location/Attribute:status+' => '',
	'Class:Location/Attribute:status/Value:active' => 'Aktívna',
	'Class:Location/Attribute:status/Value:active+' => '',
	'Class:Location/Attribute:status/Value:inactive' => 'Neaktívna',
	'Class:Location/Attribute:status/Value:inactive+' => '',
	'Class:Location/Attribute:org_id' => 'Organizácia vlastníka',
	'Class:Location/Attribute:org_id+' => '',
	'Class:Location/Attribute:address' => 'Adresa',
	'Class:Location/Attribute:address+' => '',
	'Class:Location/Attribute:postal_code' => 'PSČ',
	'Class:Location/Attribute:postal_code+' => '',
	'Class:Location/Attribute:city' => 'Mesto',
	'Class:Location/Attribute:city+' => '',
	'Class:Location/Attribute:country' => 'Štát',
	'Class:Location/Attribute:country+' => '',
	'Class:Location/Attribute:physicaldevice_list' => 'Zariadenia',
	'Class:Location/Attribute:physicaldevice_list+' => 'All the devices in this location~~',
	'Class:Location/Attribute:person_list' => 'Kontakty',
	'Class:Location/Attribute:person_list+' => 'All the contacts located on this location~~',
	'Class:Person' => 'Osoba',
	'Class:Person+' => '',
	'Class:Person/Attribute:first_name' => 'Krstné meno',
	'Class:Person/Attribute:first_name+' => '',
	'Class:Person/Attribute:employee_number' => 'Číslo zamestnanca',
	'Class:Person/Attribute:employee_number+' => '',
	'Class:Person/Attribute:mobile_phone' => 'Telefónne číslo',
	'Class:Person/Attribute:mobile_phone+' => '',
	'Class:Person/Attribute:location_id' => 'Poloha',
	'Class:Person/Attribute:location_id+' => '',
	'Class:Person/Attribute:manager_id' => 'Manažér',
	'Class:Person/Attribute:manager_id+' => '',
	'Class:Person/Attribute:team_list' => 'Tímy',
	'Class:Person/Attribute:team_list+' => 'All the teams this person belongs to~~',
	'Class:Person/Attribute:tickets_list' => 'Tickety',
	'Class:Person/Attribute:tickets_list+' => 'All the tickets this person is the caller~~',
	'Class:Team' => 'Tím',
	'Class:Team+' => '',
	'Class:Team/Attribute:persons_list' => 'Osoby',
	'Class:Team/Attribute:persons_list+' => 'All the people belonging to this team~~',
	'Class:Team/Attribute:tickets_list' => 'Tickety',
	'Class:Team/Attribute:tickets_list+' => 'All the tickets assigned to this team~~',
	'Class:DocumentFile' => 'Dokumentový súbor',
	'Class:DocumentFile+' => '',
	'Class:DocumentFile/Attribute:file' => 'Súbor',
	'Class:DocumentFile/Attribute:file+' => '',
	'Class:DocumentNote' => 'Poznámka dokumentu',
	'Class:DocumentNote+' => '',
	'Class:DocumentNote/Attribute:text' => 'Text',
	'Class:DocumentNote/Attribute:text+' => '',
	'Class:DocumentWeb' => 'Web stránka dokumentu',
	'Class:DocumentWeb+' => '',
	'Class:DocumentWeb/Attribute:url' => 'URL',
	'Class:DocumentWeb/Attribute:url+' => '',
	'Class:NetworkDevice' => 'Sieťové zariadenie',
	'Class:NetworkDevice+' => '',
	'Class:NetworkDevice/Attribute:networkdevicetype_id' => 'Typ sieťového zariadenia',
	'Class:NetworkDevice/Attribute:networkdevicetype_id+' => '',
	'Class:NetworkDevice/Attribute:connectablecis_list' => 'Zariadenia',
	'Class:NetworkDevice/Attribute:connectablecis_list+' => 'All the devices connected to this network device~~',
	'Class:NetworkDevice/Attribute:iosversion_id' => 'IVerzia OS',
	'Class:NetworkDevice/Attribute:iosversion_id+' => '',
	'Class:NetworkDevice/Attribute:ram' => 'Operačná pamäť',
	'Class:NetworkDevice/Attribute:ram+' => '',
	'Class:Server' => 'Server',
	'Class:Server+' => '',
	'Class:Server/Attribute:osfamily_id' => 'Kategória OS',
	'Class:Server/Attribute:osfamily_id+' => '',
	'Class:Server/Attribute:osversion_id' => 'Verzia OS',
	'Class:Server/Attribute:osversion_id+' => '',
	'Class:Server/Attribute:oslicence_id' => 'Licencia OS',
	'Class:Server/Attribute:oslicence_id+' => '',
	'Class:Server/Attribute:cpu' => 'Procesor',
	'Class:Server/Attribute:cpu+' => '',
	'Class:Server/Attribute:ram' => 'Operačna pamäť',
	'Class:Server/Attribute:ram+' => '',
	'Class:Server/Attribute:logicalvolumes_list' => 'Logické disky',
	'Class:Server/Attribute:logicalvolumes_list+' => 'All the logical volumes connected to this server~~',
	'Class:ApplicationSolution' => 'Aplikačné riešenie',
	'Class:ApplicationSolution+' => '',
	'Class:ApplicationSolution/Attribute:functionalcis_list' => 'Komponenty',
	'Class:ApplicationSolution/Attribute:functionalcis_list+' => 'All the configuration items that compose this application solution~~',
	'Class:ApplicationSolution/Attribute:businessprocess_list' => 'Biznis procesy',
	'Class:ApplicationSolution/Attribute:businessprocess_list+' => 'All the business processes depending on this application solution~~',
	'Class:ApplicationSolution/Attribute:status' => 'Stav',
	'Class:ApplicationSolution/Attribute:status+' => '',
	'Class:ApplicationSolution/Attribute:status/Value:active' => 'Aktívne',
	'Class:ApplicationSolution/Attribute:status/Value:active+' => '',
	'Class:ApplicationSolution/Attribute:status/Value:inactive' => 'Neaktívne',
	'Class:ApplicationSolution/Attribute:status/Value:inactive+' => '',
	'Class:BusinessProcess' => 'Biznis proces',
	'Class:BusinessProcess+' => '',
	'Class:BusinessProcess/Attribute:applicationsolutions_list' => 'Aplikačné riešenia',
	'Class:BusinessProcess/Attribute:applicationsolutions_list+' => 'All the application solutions that impact this business process~~',
	'Class:BusinessProcess/Attribute:status' => 'Stav',
	'Class:BusinessProcess/Attribute:status+' => '',
	'Class:BusinessProcess/Attribute:status/Value:active' => 'Aktívny',
	'Class:BusinessProcess/Attribute:status/Value:active+' => '',
	'Class:BusinessProcess/Attribute:status/Value:inactive' => 'Neaktívny',
	'Class:BusinessProcess/Attribute:status/Value:inactive+' => '',
	'Class:Middleware' => 'Middleware',
	'Class:Middleware+' => '',
	'Class:Middleware/Attribute:middlewareinstance_list' => 'Middleware inštancie',
	'Class:Middleware/Attribute:middlewareinstance_list+' => 'All the middleware instances provided by this middleware~~',
	'Class:DBServer' => 'DB Server',
	'Class:DBServer+' => '',
	'Class:DBServer/Attribute:dbschema_list' => 'DB schémy',
	'Class:DBServer/Attribute:dbschema_list+' => 'All the database schemas for this DB server~~',
	'Class:WebServer' => 'Web server',
	'Class:WebServer+' => '',
	'Class:WebServer/Attribute:webapp_list' => 'Webové aplikácie',
	'Class:WebServer/Attribute:webapp_list+' => 'All the web applications available on this web server~~',
	'Class:PCSoftware' => 'PC softvér',
	'Class:PCSoftware+' => '',
	'Class:OtherSoftware' => 'Iný softvér',
	'Class:OtherSoftware+' => '',
	'Class:MiddlewareInstance' => 'Middleware inštancia',
	'Class:MiddlewareInstance+' => '',
	'Class:MiddlewareInstance/Attribute:middleware_id' => 'Middleware',
	'Class:MiddlewareInstance/Attribute:middleware_id+' => '',
	'Class:DatabaseSchema' => 'Databázová schéma',
	'Class:DatabaseSchema+' => '',
	'Class:DatabaseSchema/Attribute:dbserver_id' => 'DB server',
	'Class:DatabaseSchema/Attribute:dbserver_id+' => '',
	'Class:WebApplication' => 'Webová Aplikácia',
	'Class:WebApplication+' => '',
	'Class:WebApplication/Attribute:webserver_id' => 'Web server',
	'Class:WebApplication/Attribute:webserver_id+' => '',
	'Class:WebApplication/Attribute:url' => 'URL',
	'Class:WebApplication/Attribute:url+' => '',
	'Class:Software' => 'Softvér',
	'Class:Software+' => '',
	'Class:Software/Attribute:name' => 'Názov',
	'Class:Software/Attribute:name+' => '',
	'Class:Software/Attribute:vendor' => 'Dodávateľ',
	'Class:Software/Attribute:vendor+' => '',
	'Class:Software/Attribute:version' => 'Verzia',
	'Class:Software/Attribute:version+' => '',
	'Class:Software/Attribute:documents_list' => 'Dokumenty',
	'Class:Software/Attribute:documents_list+' => 'All the documents linked to this software~~',
	'Class:Software/Attribute:type' => 'Typ',
	'Class:Software/Attribute:type+' => '',
	'Class:Software/Attribute:type/Value:DBServer' => 'DB Server',
	'Class:Software/Attribute:type/Value:DBServer+' => '',
	'Class:Software/Attribute:type/Value:Middleware' => 'Middleware',
	'Class:Software/Attribute:type/Value:Middleware+' => '',
	'Class:Software/Attribute:type/Value:OtherSoftware' => 'Iný softvér',
	'Class:Software/Attribute:type/Value:OtherSoftware+' => '',
	'Class:Software/Attribute:type/Value:PCSoftware' => 'PC softvér',
	'Class:Software/Attribute:type/Value:PCSoftware+' => '',
	'Class:Software/Attribute:type/Value:WebServer' => 'Web Server',
	'Class:Software/Attribute:type/Value:WebServer+' => '',
	'Class:Software/Attribute:softwareinstance_list' => 'Softvérové inštancie',
	'Class:Software/Attribute:softwareinstance_list+' => 'All the software instances for this software~~',
	'Class:Software/Attribute:softwarepatch_list' => 'Softvérové záplaty',
	'Class:Software/Attribute:softwarepatch_list+' => 'All the patchs for this software~~',
	'Class:Software/Attribute:softwarelicence_list' => 'Softvérové licencie',
	'Class:Software/Attribute:softwarelicence_list+' => 'All the licenses for this software~~',
	'Class:OSPatch' => 'Záplata OS',
	'Class:OSPatch+' => '',
	'Class:OSPatch/Attribute:functionalcis_list' => 'Zariadenia',
	'Class:OSPatch/Attribute:functionalcis_list+' => 'All the systems where this patch is installed~~',
	'Class:OSPatch/Attribute:osversion_id' => 'Verzia OS',
	'Class:OSPatch/Attribute:osversion_id+' => '',
	'Class:SoftwarePatch' => 'Softvérová záplata',
	'Class:SoftwarePatch+' => '',
	'Class:SoftwarePatch/Attribute:software_id' => 'Softvér',
	'Class:SoftwarePatch/Attribute:software_id+' => '',
	'Class:SoftwarePatch/Attribute:softwareinstances_list' => 'Inštancie softvéru',
	'Class:SoftwarePatch/Attribute:softwareinstances_list+' => 'All the systems where this software patch is installed~~',
	'Class:OSLicence' => 'Licencia OS',
	'Class:OSLicence+' => '',
	'Class:OSLicence/Attribute:osversion_id' => 'Verzia OS',
	'Class:OSLicence/Attribute:osversion_id+' => '',
	'Class:OSLicence/Attribute:virtualmachines_list' => 'Virtuálne zariadenia',
	'Class:OSLicence/Attribute:virtualmachines_list+' => 'All the virtual machines where this license is used~~',
	'Class:OSLicence/Attribute:servers_list' => 'Servery',
	'Class:OSLicence/Attribute:servers_list+' => 'All the servers where this license is used~~',
	'Class:SoftwareLicence' => 'Softvérová licencia',
	'Class:SoftwareLicence+' => '',
	'Class:SoftwareLicence/Attribute:software_id' => 'Softvér',
	'Class:SoftwareLicence/Attribute:software_id+' => '',
	'Class:SoftwareLicence/Attribute:softwareinstance_list' => 'Inštancie softvéru',
	'Class:SoftwareLicence/Attribute:softwareinstance_list+' => 'All the systems where this license is used~~',
	'Class:lnkDocumentToLicence' => 'väzba Dokument/Licencia',
	'Class:lnkDocumentToLicence+' => '',
	'Class:lnkDocumentToLicence/Attribute:licence_id' => 'Licencia',
	'Class:lnkDocumentToLicence/Attribute:licence_id+' => '',
	'Class:lnkDocumentToLicence/Attribute:document_id' => 'Dokument',
	'Class:lnkDocumentToLicence/Attribute:document_id+' => '',
	'Class:OSVersion' => 'Verzia OS',
	'Class:OSVersion+' => '',
	'Class:OSVersion/Attribute:osfamily_id' => 'Kategória OS',
	'Class:OSVersion/Attribute:osfamily_id+' => '',
	'Class:OSFamily' => 'Kategória OS',
	'Class:OSFamily+' => '',
	'Class:DocumentType' => 'Typ dokumentu',
	'Class:DocumentType+' => '',
	'Class:ContactType' => 'Typ kontaktu',
	'Class:ContactType+' => '',
	'Class:Brand' => 'Značka',
	'Class:Brand+' => '',
	'Class:Brand/Attribute:physicaldevices_list' => 'Zariadenia',
	'Class:Brand/Attribute:physicaldevices_list+' => 'All the physical devices corresponding to this brand~~',
	'Class:Model' => 'Model',
	'Class:Model+' => '',
	'Class:Model/Attribute:brand_id' => 'Značka',
	'Class:Model/Attribute:brand_id+' => '',
	'Class:Model/Attribute:type' => 'Typ zariadena',
	'Class:Model/Attribute:type+' => '',
	'Class:Model/Attribute:type/Value:DiskArray' => 'Diskové pole',
	'Class:Model/Attribute:type/Value:DiskArray+' => '',
	'Class:Model/Attribute:type/Value:Enclosure' => 'Kryt',
	'Class:Model/Attribute:type/Value:Enclosure+' => '',
	'Class:Model/Attribute:type/Value:IPPhone' => 'IP Telefón',
	'Class:Model/Attribute:type/Value:IPPhone+' => '',
	'Class:Model/Attribute:type/Value:MobilePhone' => 'Mobilný telefón',
	'Class:Model/Attribute:type/Value:MobilePhone+' => '',
	'Class:Model/Attribute:type/Value:NAS' => 'NAS',
	'Class:Model/Attribute:type/Value:NAS+' => '',
	'Class:Model/Attribute:type/Value:NetworkDevice' => 'Sieťové zariadenie',
	'Class:Model/Attribute:type/Value:NetworkDevice+' => '',
	'Class:Model/Attribute:type/Value:PC' => 'PC',
	'Class:Model/Attribute:type/Value:PC+' => '',
	'Class:Model/Attribute:type/Value:PDU' => 'PDU',
	'Class:Model/Attribute:type/Value:PDU+' => '',
	'Class:Model/Attribute:type/Value:Peripheral' => 'Periférie',
	'Class:Model/Attribute:type/Value:Peripheral+' => '',
	'Class:Model/Attribute:type/Value:PowerSource' => 'Zdroj napájania',
	'Class:Model/Attribute:type/Value:PowerSource+' => '',
	'Class:Model/Attribute:type/Value:Printer' => 'Tlačiareň',
	'Class:Model/Attribute:type/Value:Printer+' => '',
	'Class:Model/Attribute:type/Value:Rack' => 'stojan (Rack)',
	'Class:Model/Attribute:type/Value:Rack+' => '',
	'Class:Model/Attribute:type/Value:SANSwitch' => 'SAN prepínač',
	'Class:Model/Attribute:type/Value:SANSwitch+' => '',
	'Class:Model/Attribute:type/Value:Server' => 'Server',
	'Class:Model/Attribute:type/Value:Server+' => '',
	'Class:Model/Attribute:type/Value:StorageSystem' => 'Úložiskový systém',
	'Class:Model/Attribute:type/Value:StorageSystem+' => '',
	'Class:Model/Attribute:type/Value:Tablet' => 'Tablet',
	'Class:Model/Attribute:type/Value:Tablet+' => '',
	'Class:Model/Attribute:type/Value:TapeLibrary' => 'Pásková knižnica',
	'Class:Model/Attribute:type/Value:TapeLibrary+' => '',
	'Class:Model/Attribute:type/Value:Telephone' => 'Telefón',
	'Class:Model/Attribute:type/Value:Telephone+' => '',
	'Class:Model/Attribute:physicaldevices_list' => 'Zariadenia',
	'Class:Model/Attribute:physicaldevices_list+' => 'All the physical devices corresponding to this model~~',
	'Class:NetworkDeviceType' => 'Typ sieťového zariadenia',
	'Class:NetworkDeviceType+' => '',
	'Class:NetworkDeviceType/Attribute:networkdevicesdevices_list' => 'Sieťové zariadenia',
	'Class:NetworkDeviceType/Attribute:networkdevicesdevices_list+' => 'All the network devices corresponding to this type~~',
	'Class:IOSVersion' => 'Verzia IOSu',
	'Class:IOSVersion+' => '',
	'Class:IOSVersion/Attribute:brand_id' => 'Značka',
	'Class:IOSVersion/Attribute:brand_id+' => '',
	'Class:lnkDocumentToPatch' => 'väzba - Dokument / Záplata',
	'Class:lnkDocumentToPatch+' => '',
	'Class:lnkDocumentToPatch/Attribute:patch_id' => 'Záplata',
	'Class:lnkDocumentToPatch/Attribute:patch_id+' => '',
	'Class:lnkDocumentToPatch/Attribute:document_id' => 'Dokument',
	'Class:lnkDocumentToPatch/Attribute:document_id+' => '',
	'Class:lnkSoftwareInstanceToSoftwarePatch' => 'väzba - Softvérová inštancia / Softvérová záplata',
	'Class:lnkSoftwareInstanceToSoftwarePatch+' => '',
	'Class:lnkSoftwareInstanceToSoftwarePatch/Attribute:softwarepatch_id' => 'Softvérová záplata',
	'Class:lnkSoftwareInstanceToSoftwarePatch/Attribute:softwarepatch_id+' => '',
	'Class:lnkSoftwareInstanceToSoftwarePatch/Attribute:softwareinstance_id' => 'Softvérová inštancia',
	'Class:lnkSoftwareInstanceToSoftwarePatch/Attribute:softwareinstance_id+' => '',
	'Class:lnkFunctionalCIToOSPatch' => 'väzba - Komponent / Záplata OS',
	'Class:lnkFunctionalCIToOSPatch+' => '',
	'Class:lnkFunctionalCIToOSPatch/Attribute:ospatch_id' => 'Záplata OS',
	'Class:lnkFunctionalCIToOSPatch/Attribute:ospatch_id+' => '',
	'Class:lnkFunctionalCIToOSPatch/Attribute:functionalci_id' => 'Komponent',
	'Class:lnkFunctionalCIToOSPatch/Attribute:functionalci_id+' => '',
	'Class:lnkDocumentToSoftware' => 'väzba Dokument / Softvér',
	'Class:lnkDocumentToSoftware+' => '',
	'Class:lnkDocumentToSoftware/Attribute:software_id' => 'Softvér',
	'Class:lnkDocumentToSoftware/Attribute:software_id+' => '',
	'Class:lnkDocumentToSoftware/Attribute:document_id' => 'Dokument',
	'Class:lnkDocumentToSoftware/Attribute:document_id+' => '',
	'Class:lnkContactToFunctionalCI' => 'väzba - Kontakt / Komponent',
	'Class:lnkContactToFunctionalCI+' => '',
	'Class:lnkContactToFunctionalCI/Attribute:functionalci_id' => 'Komponent',
	'Class:lnkContactToFunctionalCI/Attribute:functionalci_id+' => '',
	'Class:lnkContactToFunctionalCI/Attribute:contact_id' => 'Kontakt',
	'Class:lnkContactToFunctionalCI/Attribute:contact_id+' => '',
	'Class:lnkDocumentToFunctionalCI' => 'väzba - Dokument / Komponent',
	'Class:lnkDocumentToFunctionalCI+' => '',
	'Class:lnkDocumentToFunctionalCI/Attribute:functionalci_id' => 'Komponent',
	'Class:lnkDocumentToFunctionalCI/Attribute:functionalci_id+' => '',
	'Class:lnkDocumentToFunctionalCI/Attribute:document_id' => 'Dokument',
	'Class:lnkDocumentToFunctionalCI/Attribute:document_id+' => '',
	'Class:Subnet' => 'Podsieť',
	'Class:Subnet+' => '',
	'Class:Subnet/Attribute:description' => 'Popis',
	'Class:Subnet/Attribute:description+' => '',
	'Class:Subnet/Attribute:org_id' => 'Organizácia',
	'Class:Subnet/Attribute:org_id+' => '',
	'Class:Subnet/Attribute:ip' => 'IP Adresa',
	'Class:Subnet/Attribute:ip+' => '',
	'Class:Subnet/Attribute:ip_mask' => 'Maska IP adresy',
	'Class:Subnet/Attribute:ip_mask+' => '',
	'Class:PhysicalInterface' => 'Fyzické rozhranie',
	'Class:PhysicalInterface+' => '',
	'Class:PhysicalInterface/Attribute:connectableci_id' => 'Pripojitelné Zariadenie',
	'Class:PhysicalInterface/Attribute:connectableci_id+' => '',
	'Class:lnkConnectableCIToNetworkDevice' => 'väzba - Komponent / Sieťové zariadenie',
	'Class:lnkConnectableCIToNetworkDevice+' => '',
	'Class:lnkConnectableCIToNetworkDevice/Attribute:networkdevice_id' => 'Sieťové zariadenie',
	'Class:lnkConnectableCIToNetworkDevice/Attribute:networkdevice_id+' => '',
	'Class:lnkConnectableCIToNetworkDevice/Attribute:connectableci_id' => 'Pripojiteľné zariadenie',
	'Class:lnkConnectableCIToNetworkDevice/Attribute:connectableci_id+' => '',
	'Class:lnkConnectableCIToNetworkDevice/Attribute:network_port' => 'Sieťový port',
	'Class:lnkConnectableCIToNetworkDevice/Attribute:network_port+' => '',
	'Class:lnkConnectableCIToNetworkDevice/Attribute:device_port' => 'Port zariadenia',
	'Class:lnkConnectableCIToNetworkDevice/Attribute:device_port+' => '',
	'Class:lnkConnectableCIToNetworkDevice/Attribute:connection_type' => 'Typ pripojenia',
	'Class:lnkConnectableCIToNetworkDevice/Attribute:connection_type+' => '',
	'Class:lnkConnectableCIToNetworkDevice/Attribute:connection_type/Value:downlink' => 'downlink',
	'Class:lnkConnectableCIToNetworkDevice/Attribute:connection_type/Value:downlink+' => '',
	'Class:lnkConnectableCIToNetworkDevice/Attribute:connection_type/Value:uplink' => 'uplink',
	'Class:lnkConnectableCIToNetworkDevice/Attribute:connection_type/Value:uplink+' => '',
	'Class:lnkApplicationSolutionToFunctionalCI' => 'väzba - Aplikačné riešenie / Komponent',
	'Class:lnkApplicationSolutionToFunctionalCI+' => '',
	'Class:lnkApplicationSolutionToFunctionalCI/Attribute:applicationsolution_id' => 'Aplikačné riešenie',
	'Class:lnkApplicationSolutionToFunctionalCI/Attribute:applicationsolution_id+' => '',
	'Class:lnkApplicationSolutionToFunctionalCI/Attribute:functionalci_id' => 'Komponent',
	'Class:lnkApplicationSolutionToFunctionalCI/Attribute:functionalci_id+' => '',
	'Class:lnkApplicationSolutionToBusinessProcess' => 'väzba - Aplikačné riešenie / Biznis proces',
	'Class:lnkApplicationSolutionToBusinessProcess+' => '',
	'Class:lnkApplicationSolutionToBusinessProcess/Attribute:businessprocess_id' => 'Biznis proces',
	'Class:lnkApplicationSolutionToBusinessProcess/Attribute:businessprocess_id+' => '',
	'Class:lnkApplicationSolutionToBusinessProcess/Attribute:applicationsolution_id' => 'Aplikačné riešenie',
	'Class:lnkApplicationSolutionToBusinessProcess/Attribute:applicationsolution_id+' => '',
	'Class:lnkPersonToTeam' => 'väzba - Osoba / Tím',
	'Class:lnkPersonToTeam+' => '',
	'Class:lnkPersonToTeam/Attribute:team_id' => 'Tím',
	'Class:lnkPersonToTeam/Attribute:team_id+' => '',
	'Class:lnkPersonToTeam/Attribute:person_id' => 'Osoba',
	'Class:lnkPersonToTeam/Attribute:person_id+' => '',
	'Class:lnkPersonToTeam/Attribute:role_id' => 'Rola',
	'Class:lnkPersonToTeam/Attribute:role_id+' => '',
	'Class:Group' => 'Skupina',
	'Class:Group+' => '',
	'Class:Group/Attribute:name' => 'Názov',
	'Class:Group/Attribute:name+' => '',
	'Class:Group/Attribute:status' => 'Stav',
	'Class:Group/Attribute:status+' => '',
	'Class:Group/Attribute:status/Value:implementation' => 'Implementácia',
	'Class:Group/Attribute:status/Value:implementation+' => '',
	'Class:Group/Attribute:status/Value:obsolete' => 'Vyradená',
	'Class:Group/Attribute:status/Value:obsolete+' => '',
	'Class:Group/Attribute:status/Value:production' => 'Produkcia',
	'Class:Group/Attribute:status/Value:production+' => '',
	'Class:Group/Attribute:org_id' => 'Organizácia',
	'Class:Group/Attribute:org_id+' => '',
	'Class:Group/Attribute:description' => 'Popis',
	'Class:Group/Attribute:description+' => '',
	'Class:Group/Attribute:type' => 'Typ',
	'Class:Group/Attribute:type+' => '',
	'Class:Group/Attribute:parent_id' => 'Nadradená skupina',
	'Class:Group/Attribute:parent_id+' => '',
	'Class:Group/Attribute:ci_list' => 'Prislúchajúce zariadenia',
	'Class:Group/Attribute:ci_list+' => 'All the configuration items linked to this group~~',
	'Class:lnkGroupToCI' => 'väzba - Skupina / Zariadenie',
	'Class:lnkGroupToCI+' => '',
	'Class:lnkGroupToCI/Attribute:group_id' => 'Skupina',
	'Class:lnkGroupToCI/Attribute:group_id+' => '',
	'Class:lnkGroupToCI/Attribute:ci_id' => 'Zariadenie',
	'Class:lnkGroupToCI/Attribute:ci_id+' => '',
	'Class:lnkGroupToCI/Attribute:reason' => 'Dôvod',
	'Class:lnkGroupToCI/Attribute:reason+' => '',
	'Class:Rack' => 'stojan (Rack)',
	'Class:Rack+' => '',
	'Class:Rack/Attribute:nb_u' => 'NB U',
	'Class:Rack/Attribute:nb_u+' => '',
	'Class:Rack/Attribute:device_list' => 'Zariadenia',
	'Class:Rack/Attribute:device_list+' => 'All the physical devices racked into this rack~~',
	'Class:Rack/Attribute:enclosure_list' => 'Kryt',
	'Class:Rack/Attribute:enclosure_list+' => 'All the enclosures in this rack~~',
	'Class:Enclosure' => 'Kryt (enclosure)',
	'Class:Enclosure+' => '',
	'Class:Enclosure/Attribute:rack_id' => 'stojan (Rack)',
	'Class:Enclosure/Attribute:rack_id+' => '',
	'Class:Enclosure/Attribute:nb_u' => 'NB U',
	'Class:Enclosure/Attribute:nb_u+' => '',
	'Class:Enclosure/Attribute:device_list' => 'Zariadenia',
	'Class:Enclosure/Attribute:device_list+' => 'All the devices in this enclosure~~',
	'Class:PowerSource' => 'Napájací zdroj',
	'Class:PowerSource+' => '',
	'Class:PowerSource/Attribute:pdus_list' => 'Napäťové distribučné jednotky (PDU)',
	'Class:PowerSource/Attribute:pdus_list+' => 'All the PDUs using this power source~~',
	'Class:PDU' => 'Napäťová distribučná jednotka (PDU)',
	'Class:PDU+' => '',
	'Class:PDU/Attribute:rack_id' => 'stojan (Rack)',
	'Class:PDU/Attribute:rack_id+' => '',
	'Class:PDU/Attribute:powerstart_id' => 'Power start',
	'Class:PDU/Attribute:powerstart_id+' => '',
	'Class:PC' => 'PC',
	'Class:PC+' => '',
	'Class:PC/Attribute:osfamily_id' => 'Kategória OS',
	'Class:PC/Attribute:osfamily_id+' => '',
	'Class:PC/Attribute:osversion_id' => 'Verzia OS',
	'Class:PC/Attribute:osversion_id+' => '',
	'Class:PC/Attribute:cpu' => 'Procesor',
	'Class:PC/Attribute:cpu+' => '',
	'Class:PC/Attribute:ram' => 'Operačná pamäť',
	'Class:PC/Attribute:ram+' => '',
	'Class:PC/Attribute:type' => 'Typ',
	'Class:PC/Attribute:type+' => '',
	'Class:PC/Attribute:type/Value:desktop' => 'Stolový počítač',
	'Class:PC/Attribute:type/Value:desktop+' => '',
	'Class:PC/Attribute:type/Value:laptop' => 'Laptop',
	'Class:PC/Attribute:type/Value:laptop+' => '',
	'Class:Printer' => 'Tlačiareň',
	'Class:Printer+' => '',
	'Class:Phone' => 'Telefón',
	'Class:Phone+' => '',
	'Class:MobilePhone' => 'Mobilný telefón',
	'Class:MobilePhone+' => '',
	'Class:MobilePhone/Attribute:imei' => 'IMEI',
	'Class:MobilePhone/Attribute:imei+' => '',
	'Class:MobilePhone/Attribute:hw_pin' => 'HW PIN',
	'Class:MobilePhone/Attribute:hw_pin+' => '',
	'Class:IPPhone' => 'IP telefón',
	'Class:IPPhone+' => '',
	'Class:Tablet' => 'Tablet',
	'Class:Tablet+' => '',
	'Class:Peripheral' => 'Periférie',
	'Class:Peripheral+' => '',
	'Class:ContractType' => 'Typ zmluvy',
	'Class:ContractType+' => '',
	'Class:CustomerContract' => 'Zákaznícka zmluva',
	'Class:CustomerContract+' => '',
	'Class:CustomerContract/Attribute:services_list' => 'Služby',
	'Class:CustomerContract/Attribute:services_list+' => 'All the services purchased for this contract~~',
	'Class:ProviderContract' => 'Poskytovateľská zmluva',
	'Class:ProviderContract+' => '',
	'Class:ProviderContract/Attribute:functionalcis_list' => 'Zariadenia',
	'Class:ProviderContract/Attribute:functionalcis_list+' => 'All the configuration items covered by this provider contract~~',
	'Class:ProviderContract/Attribute:sla' => 'SLA',
	'Class:ProviderContract/Attribute:sla+' => '',
	'Class:ProviderContract/Attribute:coverage' => 'Časy pokrytia',
	'Class:ProviderContract/Attribute:coverage+' => '',
	'Class:lnkContactToContract' => 'väzba - Kontakt / zmluva',
	'Class:lnkContactToContract+' => '',
	'Class:lnkContactToContract/Attribute:contract_id' => 'zmluva',
	'Class:lnkContactToContract/Attribute:contract_id+' => '',
	'Class:lnkContactToContract/Attribute:contact_id' => 'Kontakt',
	'Class:lnkContactToContract/Attribute:contact_id+' => '',
	'Class:lnkContractToDocument' => 'väzba - zmluva / Dokument',
	'Class:lnkContractToDocument+' => '',
	'Class:lnkContractToDocument/Attribute:contract_id' => 'zmluva',
	'Class:lnkContractToDocument/Attribute:contract_id+' => '',
	'Class:lnkContractToDocument/Attribute:document_id' => 'Dokument',
	'Class:lnkContractToDocument/Attribute:document_id+' => '',
	'Class:lnkFunctionalCIToProviderContract' => 'väzba - Komponent / Poskytovateľská zmluva',
	'Class:lnkFunctionalCIToProviderContract+' => '',
	'Class:lnkFunctionalCIToProviderContract/Attribute:providercontract_id' => 'Poskytovateľská zmluva',
	'Class:lnkFunctionalCIToProviderContract/Attribute:providercontract_id+' => '',
	'Class:lnkFunctionalCIToProviderContract/Attribute:functionalci_id' => 'Zariadenie',
	'Class:lnkFunctionalCIToProviderContract/Attribute:functionalci_id+' => '',
	'Class:ServiceFamily' => 'Kategória služieb',
	'Class:ServiceFamily+' => '',
	'Class:ServiceFamily/Attribute:name' => 'Názov',
	'Class:ServiceFamily/Attribute:name+' => '',
	'Class:ServiceFamily/Attribute:services_list' => 'Služby',
	'Class:ServiceFamily/Attribute:services_list+' => 'All the services in this category~~',
	'Class:Service' => 'Služby',
	'Class:Service+' => '',
	'Class:Service/Attribute:name' => 'Názov',
	'Class:Service/Attribute:name+' => '',
	'Class:Service/Attribute:org_id' => 'Poskytovateľ',
	'Class:Service/Attribute:org_id+' => '',
	'Class:Service/Attribute:servicefamily_id' => 'Kategória služieb',
	'Class:Service/Attribute:servicefamily_id+' => '',
	'Class:Service/Attribute:description' => 'Popis',
	'Class:Service/Attribute:description+' => '',
	'Class:Service/Attribute:documents_list' => 'Dokumenty',
	'Class:Service/Attribute:documents_list+' => 'All the documents linked to the service~~',
	'Class:Service/Attribute:contacts_list' => 'Kontakty',
	'Class:Service/Attribute:contacts_list+' => 'All the contacts for this service~~',
	'Class:Service/Attribute:status' => 'Stav',
	'Class:Service/Attribute:status+' => '',
	'Class:Service/Attribute:status/Value:implementation' => 'Implementácia',
	'Class:Service/Attribute:status/Value:implementation+' => '',
	'Class:Service/Attribute:status/Value:obsolete' => 'Vyradená',
	'Class:Service/Attribute:status/Value:obsolete+' => '',
	'Class:Service/Attribute:status/Value:production' => 'Produkcia',
	'Class:Service/Attribute:status/Value:production+' => '',
	'Class:Service/Attribute:customercontracts_list' => 'Zákaznícke zmluvy',
	'Class:Service/Attribute:customercontracts_list+' => 'All the customer contracts that have purchased this service~~',
	'Class:Service/Attribute:providercontracts_list' => 'Poskytovateľské zmluvy',
	'Class:Service/Attribute:providercontracts_list+' => 'All the provider contracts to support this service~~',
	'Class:Service/Attribute:functionalcis_list' => 'Zariadenia',
	'Class:Service/Attribute:functionalcis_list+' => 'All the configuration items that are used to provide this service~~',
	'Class:Service/Attribute:servicesubcategories_list' => 'Podkategórie služieb',
	'Class:Service/Attribute:servicesubcategories_list+' => 'All the sub categories for this service~~',
	'Class:lnkDocumentToService' => 'väzba - Dokument / Služba',
	'Class:lnkDocumentToService+' => '',
	'Class:lnkDocumentToService/Attribute:service_id' => 'Služba',
	'Class:lnkDocumentToService/Attribute:service_id+' => '',
	'Class:lnkDocumentToService/Attribute:document_id' => 'Dokument',
	'Class:lnkDocumentToService/Attribute:document_id+' => '',
	'Class:lnkContactToService' => 'väzba - Kontakt / Služba',
	'Class:lnkContactToService+' => '',
	'Class:lnkContactToService/Attribute:service_id' => 'Služba',
	'Class:lnkContactToService/Attribute:service_id+' => '',
	'Class:lnkContactToService/Attribute:contact_id' => 'Kontakt',
	'Class:lnkContactToService/Attribute:contact_id+' => '',
	'Class:ServiceSubcategory' => 'Podkategória služieb',
	'Class:ServiceSubcategory+' => '',
	'Class:ServiceSubcategory/Attribute:name' => 'Názov',
	'Class:ServiceSubcategory/Attribute:name+' => '',
	'Class:ServiceSubcategory/Attribute:description' => 'Popis',
	'Class:ServiceSubcategory/Attribute:description+' => '',
	'Class:ServiceSubcategory/Attribute:service_id' => 'Služba',
	'Class:ServiceSubcategory/Attribute:service_id+' => '',
	'Class:ServiceSubcategory/Attribute:request_type' => 'Typ požiadavky',
	'Class:ServiceSubcategory/Attribute:request_type+' => '',
	'Class:ServiceSubcategory/Attribute:request_type/Value:incident' => 'Incident',
	'Class:ServiceSubcategory/Attribute:request_type/Value:incident+' => '',
	'Class:ServiceSubcategory/Attribute:request_type/Value:service_request' => 'Požiadavka',
	'Class:ServiceSubcategory/Attribute:request_type/Value:service_request+' => '',
	'Class:ServiceSubcategory/Attribute:status' => 'Stav',
	'Class:ServiceSubcategory/Attribute:status+' => '',
	'Class:ServiceSubcategory/Attribute:status/Value:implementation' => 'Implementácia',
	'Class:ServiceSubcategory/Attribute:status/Value:implementation+' => '',
	'Class:ServiceSubcategory/Attribute:status/Value:obsolete' => 'Vyradená',
	'Class:ServiceSubcategory/Attribute:status/Value:obsolete+' => '',
	'Class:ServiceSubcategory/Attribute:status/Value:production' => 'Produkcia',
	'Class:ServiceSubcategory/Attribute:status/Value:production+' => '',
	'Class:SLA' => 'SLA',
	'Class:SLA+' => '',
	'Class:SLA/Attribute:name' => 'Názov',
	'Class:SLA/Attribute:name+' => '',
	'Class:SLA/Attribute:description' => 'Popis',
	'Class:SLA/Attribute:description+' => '',
	'Class:SLA/Attribute:org_id' => 'Poskytovateľ',
	'Class:SLA/Attribute:org_id+' => '',
	'Class:SLA/Attribute:slts_list' => 'SLTs',
	'Class:SLA/Attribute:slts_list+' => 'All the service level targets for this SLA~~',
	'Class:SLA/Attribute:customercontracts_list' => 'Zákaznícke zmluvy',
	'Class:SLA/Attribute:customercontracts_list+' => 'All the customer contracts using this SLA~~',
	'Class:SLT' => 'SLT',
	'Class:SLT+' => '',
	'Class:SLT/Attribute:name' => 'Názov',
	'Class:SLT/Attribute:name+' => '',
	'Class:SLT/Attribute:priority' => 'Priorita',
	'Class:SLT/Attribute:priority+' => '',
	'Class:SLT/Attribute:priority/Value:1' => 'Kritická',
	'Class:SLT/Attribute:priority/Value:1+' => '',
	'Class:SLT/Attribute:priority/Value:2' => 'Vysoká',
	'Class:SLT/Attribute:priority/Value:2+' => '',
	'Class:SLT/Attribute:priority/Value:3' => 'Stredná',
	'Class:SLT/Attribute:priority/Value:3+' => '',
	'Class:SLT/Attribute:priority/Value:4' => 'Nízka',
	'Class:SLT/Attribute:priority/Value:4+' => '',
	'Class:SLT/Attribute:request_type' => 'Typ požiadavky',
	'Class:SLT/Attribute:request_type+' => '',
	'Class:SLT/Attribute:request_type/Value:incident' => 'Incident',
	'Class:SLT/Attribute:request_type/Value:incident+' => '',
	'Class:SLT/Attribute:request_type/Value:service_request' => 'Požiadavka',
	'Class:SLT/Attribute:request_type/Value:service_request+' => '',
	'Class:SLT/Attribute:metric' => 'Metrika',
	'Class:SLT/Attribute:metric+' => '',
	'Class:SLT/Attribute:metric/Value:tto' => 'TTO',
	'Class:SLT/Attribute:metric/Value:tto+' => '',
	'Class:SLT/Attribute:metric/Value:ttr' => 'TTR',
	'Class:SLT/Attribute:metric/Value:ttr+' => '',
	'Class:SLT/Attribute:value' => 'Hodnota',
	'Class:SLT/Attribute:value+' => '',
	'Class:SLT/Attribute:unit' => 'Jednotka',
	'Class:SLT/Attribute:unit+' => '',
	'Class:SLT/Attribute:unit/Value:hours' => 'Hodiny',
	'Class:SLT/Attribute:unit/Value:hours+' => '',
	'Class:SLT/Attribute:unit/Value:minutes' => 'Minúty',
	'Class:SLT/Attribute:unit/Value:minutes+' => '',
	'Class:lnkSLAToSLT' => 'väzba - SLA / SLT',
	'Class:lnkSLAToSLT+' => '',
	'Class:lnkSLAToSLT/Attribute:sla_id' => 'SLA',
	'Class:lnkSLAToSLT/Attribute:sla_id+' => '',
	'Class:lnkSLAToSLT/Attribute:slt_id' => 'SLT',
	'Class:lnkSLAToSLT/Attribute:slt_id+' => '',
	'Class:lnkCustomerContractToService' => 'väzba - Zákaznícka zmluva / Služba',
	'Class:lnkCustomerContractToService+' => '',
	'Class:lnkCustomerContractToService/Attribute:customercontract_id' => 'Zákaznícka zmluva',
	'Class:lnkCustomerContractToService/Attribute:customercontract_id+' => '',
	'Class:lnkCustomerContractToService/Attribute:service_id' => 'Služba',
	'Class:lnkCustomerContractToService/Attribute:service_id+' => '',
	'Class:lnkCustomerContractToService/Attribute:sla_id' => 'SLA',
	'Class:lnkCustomerContractToService/Attribute:sla_id+' => '',
	'Class:lnkProviderContractToService' => 'väzba - Poskytovateľská zmluva / Služba',
	'Class:lnkProviderContractToService+' => '',
	'Class:lnkProviderContractToService/Attribute:service_id' => 'Služba',
	'Class:lnkProviderContractToService/Attribute:service_id+' => '',
	'Class:lnkProviderContractToService/Attribute:providercontract_id' => 'Poskytovateľská zmluva',
	'Class:lnkProviderContractToService/Attribute:providercontract_id+' => '',
	'Class:lnkFunctionalCIToService' => 'väzba - Komponent / Služba',
	'Class:lnkFunctionalCIToService+' => '',
	'Class:lnkFunctionalCIToService/Attribute:service_id' => 'Služba',
	'Class:lnkFunctionalCIToService/Attribute:service_id+' => '',
	'Class:lnkFunctionalCIToService/Attribute:functionalci_id' => 'Zariadenie',
	'Class:lnkFunctionalCIToService/Attribute:functionalci_id+' => '',
	'Class:DeliveryModel' => 'Model dodávky',
	'Class:DeliveryModel+' => '',
	'Class:DeliveryModel/Attribute:name' => 'Názov',
	'Class:DeliveryModel/Attribute:name+' => '',
	'Class:DeliveryModel/Attribute:org_id' => 'Organizácia',
	'Class:DeliveryModel/Attribute:org_id+' => '',
	'Class:DeliveryModel/Attribute:description' => 'Popis',
	'Class:DeliveryModel/Attribute:description+' => '',
	'Class:DeliveryModel/Attribute:contacts_list' => 'Kontakty',
	'Class:DeliveryModel/Attribute:contacts_list+' => 'All the contacts (Teams and Person) for this delivery model~~',
	'Class:DeliveryModel/Attribute:customers_list' => 'Zákazníci',
	'Class:DeliveryModel/Attribute:customers_list+' => 'All the customers having this delivering model~~',
	'Class:lnkDeliveryModelToContact' => 'väzba - Model dodávky / Kontakt',
	'Class:lnkDeliveryModelToContact+' => '',
	'Class:lnkDeliveryModelToContact/Attribute:deliverymodel_id' => 'Model dodávky',
	'Class:lnkDeliveryModelToContact/Attribute:deliverymodel_id+' => '',
	'Class:lnkDeliveryModelToContact/Attribute:contact_id' => 'Kontakt',
	'Class:lnkDeliveryModelToContact/Attribute:contact_id+' => '',
	'Class:lnkDeliveryModelToContact/Attribute:role_id' => 'Rola',
	'Class:lnkDeliveryModelToContact/Attribute:role_id+' => '',
	'Class:StorageSystem' => 'Úložiskový systém',
	'Class:StorageSystem+' => '',
	'Class:StorageSystem/Attribute:logicalvolume_list' => 'Logické disky',
	'Class:StorageSystem/Attribute:logicalvolume_list+' => 'All the logical volumes in this storage system~~',
	'Class:SANSwitch' => 'SAN prepínač',
	'Class:SANSwitch+' => '',
	'Class:SANSwitch/Attribute:datacenterdevice_list' => 'Zariadenia',
	'Class:SANSwitch/Attribute:datacenterdevice_list+' => 'All the devices connected to this SAN switch~~',
	'Class:TapeLibrary' => 'Pásková knižnica',
	'Class:TapeLibrary+' => '',
	'Class:TapeLibrary/Attribute:tapes_list' => 'Pásky',
	'Class:TapeLibrary/Attribute:tapes_list+' => 'All the tapes in the tape library~~',
	'Class:NAS' => 'NAS',
	'Class:NAS+' => '',
	'Class:NAS/Attribute:nasfilesystem_list' => 'Súborové systémy',
	'Class:NAS/Attribute:nasfilesystem_list+' => 'All the file systems in this NAS~~',
	'Class:FiberChannelInterface' => 'Optické rozhranie',
	'Class:FiberChannelInterface+' => '',
	'Class:FiberChannelInterface/Attribute:speed' => 'Rýchlosť',
	'Class:FiberChannelInterface/Attribute:speed+' => '',
	'Class:FiberChannelInterface/Attribute:topology' => 'Topológia',
	'Class:FiberChannelInterface/Attribute:topology+' => '',
	'Class:FiberChannelInterface/Attribute:wwn' => 'WWN',
	'Class:FiberChannelInterface/Attribute:wwn+' => '',
	'Class:FiberChannelInterface/Attribute:datacenterdevice_id' => 'Zariadenie',
	'Class:FiberChannelInterface/Attribute:datacenterdevice_id+' => '',
	'Class:Tape' => 'Páska',
	'Class:Tape+' => '',
	'Class:Tape/Attribute:name' => 'Názov',
	'Class:Tape/Attribute:name+' => '',
	'Class:Tape/Attribute:description' => 'Popis',
	'Class:Tape/Attribute:description+' => '',
	'Class:Tape/Attribute:size' => 'Veľkosť',
	'Class:Tape/Attribute:size+' => '',
	'Class:Tape/Attribute:tapelibrary_id' => 'Pásková knižnica',
	'Class:Tape/Attribute:tapelibrary_id+' => '',
	'Class:NASFileSystem' => 'NAS Súborový systém',
	'Class:NASFileSystem+' => '',
	'Class:NASFileSystem/Attribute:name' => 'Názov',
	'Class:NASFileSystem/Attribute:name+' => '',
	'Class:NASFileSystem/Attribute:description' => 'Popis',
	'Class:NASFileSystem/Attribute:description+' => '',
	'Class:NASFileSystem/Attribute:raid_level' => 'Raid úroveň',
	'Class:NASFileSystem/Attribute:raid_level+' => '',
	'Class:NASFileSystem/Attribute:size' => 'Veľkosť',
	'Class:NASFileSystem/Attribute:size+' => '',
	'Class:NASFileSystem/Attribute:nas_id' => 'NAS',
	'Class:NASFileSystem/Attribute:nas_id+' => '',
	'Class:LogicalVolume' => 'Logické disky',
	'Class:LogicalVolume+' => '',
	'Class:LogicalVolume/Attribute:name' => 'Názov',
	'Class:LogicalVolume/Attribute:name+' => '',
	'Class:LogicalVolume/Attribute:lun_id' => 'LUN ID',
	'Class:LogicalVolume/Attribute:lun_id+' => '',
	'Class:LogicalVolume/Attribute:description' => 'Popis',
	'Class:LogicalVolume/Attribute:description+' => '',
	'Class:LogicalVolume/Attribute:raid_level' => 'Raid úroveň',
	'Class:LogicalVolume/Attribute:raid_level+' => '',
	'Class:LogicalVolume/Attribute:size' => 'Veľkosť',
	'Class:LogicalVolume/Attribute:size+' => '',
	'Class:LogicalVolume/Attribute:storagesystem_id' => 'Úložiskový systém',
	'Class:LogicalVolume/Attribute:storagesystem_id+' => '',
	'Class:LogicalVolume/Attribute:servers_list' => 'Servery',
	'Class:LogicalVolume/Attribute:servers_list+' => 'All the servers using this volume~~',
	'Class:LogicalVolume/Attribute:virtualdevices_list' => 'Virtuálne zariadenia',
	'Class:LogicalVolume/Attribute:virtualdevices_list+' => 'All the virtual devices using this volume~~',
	'Class:lnkServerToVolume' => 'väzba - Server / Logický Disk',
	'Class:lnkServerToVolume+' => '',
	'Class:lnkServerToVolume/Attribute:volume_id' => 'Logický Disk',
	'Class:lnkServerToVolume/Attribute:volume_id+' => '',
	'Class:lnkServerToVolume/Attribute:server_id' => 'Server',
	'Class:lnkServerToVolume/Attribute:server_id+' => '',
	'Class:lnkServerToVolume/Attribute:size_used' => 'Použité miesto',
	'Class:lnkServerToVolume/Attribute:size_used+' => '',
	'Class:lnkSanToDatacenterDevice' => 'väzba - SAN / Zariadenie',
	'Class:lnkSanToDatacenterDevice+' => '',
	'Class:lnkSanToDatacenterDevice/Attribute:san_id' => 'SAN prepínač',
	'Class:lnkSanToDatacenterDevice/Attribute:san_id+' => '',
	'Class:lnkSanToDatacenterDevice/Attribute:datacenterdevice_id' => 'Zariadenie',
	'Class:lnkSanToDatacenterDevice/Attribute:datacenterdevice_id+' => '',
	'Class:lnkSanToDatacenterDevice/Attribute:san_port' => 'SAN port',
	'Class:lnkSanToDatacenterDevice/Attribute:san_port+' => '',
	'Class:lnkSanToDatacenterDevice/Attribute:datacenterdevice_port' => '(FC) Port zariadenia',
	'Class:lnkSanToDatacenterDevice/Attribute:datacenterdevice_port+' => '',
	'Class:Ticket' => 'Ticket',
	'Class:Ticket+' => '',
	'Class:Ticket/Attribute:ref' => 'Referencia',
	'Class:Ticket/Attribute:ref+' => '',
	'Class:Ticket/Attribute:org_id' => 'Organizácia',
	'Class:Ticket/Attribute:org_id+' => '',
	'Class:Ticket/Attribute:caller_id' => 'Zadávateľ',
	'Class:Ticket/Attribute:caller_id+' => '',
	'Class:Ticket/Attribute:team_id' => 'Tím',
	'Class:Ticket/Attribute:team_id+' => '',
	'Class:Ticket/Attribute:agent_id' => 'Agent',
	'Class:Ticket/Attribute:agent_id+' => '',
	'Class:Ticket/Attribute:title' => 'Nadpis',
	'Class:Ticket/Attribute:title+' => '',
	'Class:Ticket/Attribute:description' => 'Popis',
	'Class:Ticket/Attribute:description+' => '',
	'Class:Ticket/Attribute:start_date' => 'Dátum začiatku',
	'Class:Ticket/Attribute:start_date+' => '',
	'Class:Ticket/Attribute:end_date' => 'Dátum ukončenia',
	'Class:Ticket/Attribute:end_date+' => '',
	'Class:Ticket/Attribute:last_update' => 'Posledná aktualizácia',
	'Class:Ticket/Attribute:last_update+' => '',
	'Class:Ticket/Attribute:close_date' => 'Dátum uzavretia',
	'Class:Ticket/Attribute:close_date+' => '',
	'Class:Ticket/Attribute:private_log' => 'Skrytý záznam',
	'Class:Ticket/Attribute:private_log+' => '',
	'Class:Ticket/Attribute:contacts_list' => 'Kontakty',
	'Class:Ticket/Attribute:contacts_list+' => 'All the contacts linked to this ticket~~',
	'Class:Ticket/Attribute:functionalcis_list' => 'Komponenty',
	'Class:Ticket/Attribute:functionalcis_list+' => 'All the configuration items impacted by this ticket. Items marked as "Computed" have been automatically marked as impacted. Items marked as "Not impacted" are excluded from the impact.~~',
	'Class:Ticket/Attribute:workorders_list' => 'Pracovné príkazy',
	'Class:Ticket/Attribute:workorders_list+' => 'All the work orders for this ticket~~',
	'Class:Ticket/Attribute:finalclass' => 'Typ',
	'Class:Ticket/Attribute:finalclass+' => '',
	'Class:lnkContactToTicket' => 'väzba - Kontakt / Ticket',
	'Class:lnkContactToTicket+' => '',
	'Class:lnkContactToTicket/Attribute:ticket_id' => 'Ticket',
	'Class:lnkContactToTicket/Attribute:ticket_id+' => '',
	'Class:lnkContactToTicket/Attribute:contact_id' => 'Kontakt',
	'Class:lnkContactToTicket/Attribute:contact_id+' => '',
	'Class:lnkContactToTicket/Attribute:role' => 'Rola',
	'Class:lnkContactToTicket/Attribute:role+' => '',
	'Class:lnkFunctionalCIToTicket' => 'väzba - Komponent / Ticket',
	'Class:lnkFunctionalCIToTicket+' => '',
	'Class:lnkFunctionalCIToTicket/Attribute:ticket_id' => 'Ticket',
	'Class:lnkFunctionalCIToTicket/Attribute:ticket_id+' => '',
	'Class:lnkFunctionalCIToTicket/Attribute:functionalci_id' => 'Komponent',
	'Class:lnkFunctionalCIToTicket/Attribute:functionalci_id+' => '',
	'Class:lnkFunctionalCIToTicket/Attribute:impact' => 'Dopad',
	'Class:lnkFunctionalCIToTicket/Attribute:impact+' => '',
	'Class:WorkOrder' => 'Pracovný príkaz',
	'Class:WorkOrder+' => '',
	'Class:WorkOrder/Attribute:name' => 'Názov',
	'Class:WorkOrder/Attribute:name+' => '',
	'Class:WorkOrder/Attribute:status' => 'Stav',
	'Class:WorkOrder/Attribute:status+' => '',
	'Class:WorkOrder/Attribute:status/Value:open' => 'Otvorený',
	'Class:WorkOrder/Attribute:status/Value:open+' => '',
	'Class:WorkOrder/Attribute:status/Value:closed' => 'Zatvorený',
	'Class:WorkOrder/Attribute:status/Value:closed+' => '',
	'Class:WorkOrder/Attribute:description' => 'Popis',
	'Class:WorkOrder/Attribute:description+' => '',
	'Class:WorkOrder/Attribute:ticket_id' => 'Ticket',
	'Class:WorkOrder/Attribute:ticket_id+' => '',
	'Class:WorkOrder/Attribute:team_id' => 'Tím',
	'Class:WorkOrder/Attribute:team_id+' => '',
	'Class:WorkOrder/Attribute:agent_id' => 'Agent',
	'Class:WorkOrder/Attribute:agent_id+' => '',
	'Class:WorkOrder/Attribute:start_date' => 'Dátum začiatku',
	'Class:WorkOrder/Attribute:start_date+' => '',
	'Class:WorkOrder/Attribute:end_date' => 'Dátum ukončenia',
	'Class:WorkOrder/Attribute:end_date+' => '',
	'Class:WorkOrder/Attribute:log' => 'Záznam',
	'Class:WorkOrder/Attribute:log+' => '',
	'Class:WorkOrder/Stimulus:ev_close' => 'Zatvoriť',
	'Class:WorkOrder/Stimulus:ev_close+' => '',
	'Class:Hypervisor' => 'Hypervisor',
	'Class:Hypervisor+' => '',
	'Class:Hypervisor/Attribute:farm_id' => 'Farma',
	'Class:Hypervisor/Attribute:farm_id+' => '',
	'Class:Hypervisor/Attribute:server_id' => 'Server',
	'Class:Hypervisor/Attribute:server_id+' => '',
	'Class:Farm' => 'Farma',
	'Class:Farm+' => '',
	'Class:Farm/Attribute:hypervisor_list' => 'Hypervisori',
	'Class:Farm/Attribute:hypervisor_list+' => 'All the hypervisors that compose this farm~~',
	'Class:VirtualMachine' => 'Virtuálne zariadenie',
	'Class:VirtualMachine+' => '',
	'Class:VirtualMachine/Attribute:virtualhost_id' => 'Virtuálny host',
	'Class:VirtualMachine/Attribute:virtualhost_id+' => '',
	'Class:VirtualMachine/Attribute:osfamily_id' => 'Kategória OS',
	'Class:VirtualMachine/Attribute:osfamily_id+' => '',
	'Class:VirtualMachine/Attribute:osversion_id' => 'Verzia OS',
	'Class:VirtualMachine/Attribute:osversion_id+' => '',
	'Class:VirtualMachine/Attribute:oslicence_id' => 'Licencia OS',
	'Class:VirtualMachine/Attribute:oslicence_id+' => '',
	'Class:VirtualMachine/Attribute:cpu' => 'Procesor',
	'Class:VirtualMachine/Attribute:cpu+' => '',
	'Class:VirtualMachine/Attribute:ram' => 'Operačná pamäť',
	'Class:VirtualMachine/Attribute:ram+' => '',
	'Class:VirtualMachine/Attribute:logicalinterface_list' => 'Zoznam sieťových rozhraní',
	'Class:VirtualMachine/Attribute:logicalinterface_list+' => 'All the logical network interfaces~~',
	'Class:LogicalInterface' => 'Logické rozhranie',
	'Class:LogicalInterface+' => '',
	'Class:LogicalInterface/Attribute:virtualmachine_id' => 'Virtuálne zariadenie',
	'Class:LogicalInterface/Attribute:virtualmachine_id+' => '',
	'Class:Change' => 'Zmena',
	'Class:Change+' => '',
	'Class:Change/Attribute:status' => 'Stav',
	'Class:Change/Attribute:status+' => '',
	'Class:Change/Attribute:status/Value:new' => 'Nová',
	'Class:Change/Attribute:status/Value:new+' => '',
	'Class:Change/Attribute:status/Value:assigned' => 'Pridelená',
	'Class:Change/Attribute:status/Value:assigned+' => '',
	'Class:Change/Attribute:status/Value:planned' => 'Plánovaná',
	'Class:Change/Attribute:status/Value:planned+' => '',
	'Class:Change/Attribute:status/Value:rejected' => 'Zamietnutá',
	'Class:Change/Attribute:status/Value:rejected+' => '',
	'Class:Change/Attribute:status/Value:approved' => 'Schválená',
	'Class:Change/Attribute:status/Value:approved+' => '',
	'Class:Change/Attribute:status/Value:closed' => 'Zatvorená',
	'Class:Change/Attribute:status/Value:closed+' => '',
	'Class:Change/Attribute:category' => 'Kategória',
	'Class:Change/Attribute:category+' => '',
	'Class:Change/Attribute:category/Value:application' => 'Aplikácia',
	'Class:Change/Attribute:category/Value:application+' => '',
	'Class:Change/Attribute:category/Value:hardware' => 'Hardvér',
	'Class:Change/Attribute:category/Value:hardware+' => '',
	'Class:Change/Attribute:category/Value:network' => 'Sieť',
	'Class:Change/Attribute:category/Value:network+' => '',
	'Class:Change/Attribute:category/Value:other' => 'Iné',
	'Class:Change/Attribute:category/Value:other+' => '',
	'Class:Change/Attribute:category/Value:software' => 'Softvér',
	'Class:Change/Attribute:category/Value:software+' => '',
	'Class:Change/Attribute:category/Value:system' => 'Systém',
	'Class:Change/Attribute:category/Value:system+' => '',
	'Class:Change/Attribute:reject_reason' => 'Dôvod zamietnutia',
	'Class:Change/Attribute:reject_reason+' => '',
	'Class:Change/Attribute:changeManažér_id' => 'Manažér zmien',
	'Class:Change/Attribute:changemanager_id+' => '',
	'Class:Change/Attribute:parent_id' => 'Nadradená zmena',
	'Class:Change/Attribute:parent_id+' => '',
	'Class:Change/Attribute:creation_date' => 'Dátum vytvorenia',
	'Class:Change/Attribute:creation_date+' => '',
	'Class:Change/Attribute:approval_date' => 'Dátum schválenia',
	'Class:Change/Attribute:approval_date+' => '',
	'Class:Change/Attribute:fallback_plan' => 'Návratový plán',
	'Class:Change/Attribute:fallback_plan+' => '',
	'Class:Change/Attribute:related_request_list' => 'Súvisiace požiadavky',
	'Class:Change/Attribute:related_request_list+' => 'All the user requests linked to this change~~',
	'Class:Change/Attribute:child_changes_list' => 'Podriadené zmeny',
	'Class:Change/Attribute:child_changes_list+' => 'All the sub changes linked to this change~~',
	'Class:Change/Stimulus:ev_assign' => 'Prideiť',
	'Class:Change/Stimulus:ev_assign+' => '',
	'Class:Change/Stimulus:ev_plan' => 'Naplánuj',
	'Class:Change/Stimulus:ev_plan+' => '',
	'Class:Change/Stimulus:ev_reject' => 'Zamietnúť',
	'Class:Change/Stimulus:ev_reject+' => '',
	'Class:Change/Stimulus:ev_reopen' => 'Znova otvoriť',
	'Class:Change/Stimulus:ev_reopen+' => '',
	'Class:Change/Stimulus:ev_approve' => 'Schváliť',
	'Class:Change/Stimulus:ev_approve+' => '',
	'Class:Change/Stimulus:ev_finish' => 'Zatvoriť',
	'Class:Change/Stimulus:ev_finish+' => '',
	'Class:UserRequest' => 'Požiadavka užívateľa',
	'Class:UserRequest+' => '',
	'Class:UserRequest/Attribute:status' => 'Stav',
	'Class:UserRequest/Attribute:status+' => '',
	'Class:UserRequest/Attribute:status/Value:new' => 'Nová',
	'Class:UserRequest/Attribute:status/Value:new+' => '',
	'Class:UserRequest/Attribute:status/Value:escalated_tto' => 'Eskalované TTO',
	'Class:UserRequest/Attribute:status/Value:escalated_tto+' => '',
	'Class:UserRequest/Attribute:status/Value:assigned' => 'Pridelené',
	'Class:UserRequest/Attribute:status/Value:assigned+' => '',
	'Class:UserRequest/Attribute:status/Value:escalated_ttr' => 'Eskalované TTR',
	'Class:UserRequest/Attribute:status/Value:escalated_ttr+' => '',
	'Class:UserRequest/Attribute:status/Value:waiting_for_approval' => 'Čaká sa na schválenie',
	'Class:UserRequest/Attribute:status/Value:waiting_for_approval+' => '',
	'Class:UserRequest/Attribute:status/Value:approved' => 'Schválená',
	'Class:UserRequest/Attribute:status/Value:approved+' => '',
	'Class:UserRequest/Attribute:status/Value:rejected' => 'Zamietnutá',
	'Class:UserRequest/Attribute:status/Value:rejected+' => '',
	'Class:UserRequest/Attribute:status/Value:pending' => 'Pozdržaná',
	'Class:UserRequest/Attribute:status/Value:pending+' => '',
	'Class:UserRequest/Attribute:status/Value:resolved' => 'Vyriešená',
	'Class:UserRequest/Attribute:status/Value:resolved+' => '',
	'Class:UserRequest/Attribute:status/Value:closed' => 'Zatvorená',
	'Class:UserRequest/Attribute:status/Value:closed+' => '',
	'Class:UserRequest/Attribute:request_type' => 'Typ požiadavky',
	'Class:UserRequest/Attribute:request_type+' => '',
	'Class:UserRequest/Attribute:request_type/Value:incident' => 'Incident',
	'Class:UserRequest/Attribute:request_type/Value:incident+' => '',
	'Class:UserRequest/Attribute:request_type/Value:service_request' => 'Požiadavka',
	'Class:UserRequest/Attribute:request_type/Value:service_request+' => '',
	'Class:UserRequest/Attribute:impact' => 'Dopad',
	'Class:UserRequest/Attribute:impact+' => '',
	'Class:UserRequest/Attribute:impact/Value:1' => 'Oddelenie',
	'Class:UserRequest/Attribute:impact/Value:1+' => '',
	'Class:UserRequest/Attribute:impact/Value:2' => 'Služba',
	'Class:UserRequest/Attribute:impact/Value:2+' => '',
	'Class:UserRequest/Attribute:impact/Value:3' => 'Osoba',
	'Class:UserRequest/Attribute:impact/Value:3+' => '',
	'Class:UserRequest/Attribute:priority' => 'Priorita',
	'Class:UserRequest/Attribute:priority+' => '',
	'Class:UserRequest/Attribute:priority/Value:1' => 'Kritická',
	'Class:UserRequest/Attribute:priority/Value:1+' => '',
	'Class:UserRequest/Attribute:priority/Value:2' => 'Vysoká',
	'Class:UserRequest/Attribute:priority/Value:2+' => '',
	'Class:UserRequest/Attribute:priority/Value:3' => 'Stredná',
	'Class:UserRequest/Attribute:priority/Value:3+' => '',
	'Class:UserRequest/Attribute:priority/Value:4' => 'Nízka',
	'Class:UserRequest/Attribute:priority/Value:4+' => '',
	'Class:UserRequest/Attribute:urgency' => 'Naliehavosť',
	'Class:UserRequest/Attribute:urgency+' => '',
	'Class:UserRequest/Attribute:urgency/Value:1' => 'Kritická',
	'Class:UserRequest/Attribute:urgency/Value:1+' => '',
	'Class:UserRequest/Attribute:urgency/Value:2' => 'Vysoká',
	'Class:UserRequest/Attribute:urgency/Value:2+' => '',
	'Class:UserRequest/Attribute:urgency/Value:3' => 'Stredná',
	'Class:UserRequest/Attribute:urgency/Value:3+' => '',
	'Class:UserRequest/Attribute:urgency/Value:4' => 'Nízka',
	'Class:UserRequest/Attribute:urgency/Value:4+' => '',
	'Class:UserRequest/Attribute:origin' => 'Pôvod',
	'Class:UserRequest/Attribute:origin+' => '',
	'Class:UserRequest/Attribute:origin/Value:mail' => 'Mail',
	'Class:UserRequest/Attribute:origin/Value:mail+' => '',
	'Class:UserRequest/Attribute:origin/Value:monitoring' => 'Dohľad',
	'Class:UserRequest/Attribute:origin/Value:monitoring+' => '',
	'Class:UserRequest/Attribute:origin/Value:phone' => 'Telefón',
	'Class:UserRequest/Attribute:origin/Value:phone+' => '',
	'Class:UserRequest/Attribute:origin/Value:portal' => 'Portál',
	'Class:UserRequest/Attribute:origin/Value:portal+' => '',
	'Class:UserRequest/Attribute:approver_id' => 'Schvalovateľ',
	'Class:UserRequest/Attribute:approver_id+' => '',
	'Class:UserRequest/Attribute:service_id' => 'Služba',
	'Class:UserRequest/Attribute:service_id+' => '',
	'Class:UserRequest/Attribute:servicesubcategory_id' => 'Subkategórie služieb',
	'Class:UserRequest/Attribute:servicesubcategory_id+' => '',
	'Class:UserRequest/Attribute:escalation_flag' => 'Eskalačný príznak',
	'Class:UserRequest/Attribute:escalation_flag+' => '',
	'Class:UserRequest/Attribute:escalation_flag/Value:no' => 'Nie',
	'Class:UserRequest/Attribute:escalation_flag/Value:no+' => '',
	'Class:UserRequest/Attribute:escalation_flag/Value:yes' => 'Áno',
	'Class:UserRequest/Attribute:escalation_flag/Value:yes+' => '',
	'Class:UserRequest/Attribute:escalation_reason' => 'Dôvod eskalácie',
	'Class:UserRequest/Attribute:escalation_reason+' => '',
	'Class:UserRequest/Attribute:assignment_date' => 'Dátum pridelenia',
	'Class:UserRequest/Attribute:assignment_date+' => '',
	'Class:UserRequest/Attribute:resolution_date' => 'Dátum vyriešenia',
	'Class:UserRequest/Attribute:resolution_date+' => '',
	'Class:UserRequest/Attribute:last_pending_date' => 'Posledný dátum pozdržania',
	'Class:UserRequest/Attribute:last_pending_date+' => '',
	'Class:UserRequest/Attribute:tto' => 'TTO',
	'Class:UserRequest/Attribute:tto+' => '',
	'Class:UserRequest/Attribute:ttr' => 'TTR',
	'Class:UserRequest/Attribute:ttr+' => '',
	'Class:UserRequest/Attribute:tto_escalation_deadline' => 'Dátum eskalácie TTO',
	'Class:UserRequest/Attribute:tto_escalation_deadline+' => '',
	'Class:UserRequest/Attribute:sla_tto_passed' => 'SLA TTO dodržané',
	'Class:UserRequest/Attribute:sla_tto_passed+' => '',
	'Class:UserRequest/Attribute:sla_tto_over' => 'SLA TTO prekročené',
	'Class:UserRequest/Attribute:sla_tto_over+' => '',
	'Class:UserRequest/Attribute:ttr_escalation_deadline' => 'Dátum eskalácie TTR',
	'Class:UserRequest/Attribute:ttr_escalation_deadline+' => '',
	'Class:UserRequest/Attribute:sla_ttr_passed' => 'SLA TTR dodržané',
	'Class:UserRequest/Attribute:sla_ttr_passed+' => '',
	'Class:UserRequest/Attribute:sla_ttr_over' => 'SLA TTR prekročené',
	'Class:UserRequest/Attribute:sla_ttr_over+' => '',
	'Class:UserRequest/Attribute:time_spent' => 'Oneskorenie vyriešenia',
	'Class:UserRequest/Attribute:time_spent+' => '',
	'Class:UserRequest/Attribute:resolution_code' => 'Kód riešenia',
	'Class:UserRequest/Attribute:resolution_code+' => '',
	'Class:UserRequest/Attribute:resolution_code/Value:assistance' => 'Asistencia',
	'Class:UserRequest/Attribute:resolution_code/Value:assistance+' => '',
	'Class:UserRequest/Attribute:resolution_code/Value:bug fixed' => 'Chyba opravená',
	'Class:UserRequest/Attribute:resolution_code/Value:bug fixed+' => '',
	'Class:UserRequest/Attribute:resolution_code/Value:hardware repair' => 'Oprava hardvéru',
	'Class:UserRequest/Attribute:resolution_code/Value:hardware repair+' => '',
	'Class:UserRequest/Attribute:resolution_code/Value:other' => 'Iné',
	'Class:UserRequest/Attribute:resolution_code/Value:other+' => '',
	'Class:UserRequest/Attribute:resolution_code/Value:software patch' => 'Softvérová záplata',
	'Class:UserRequest/Attribute:resolution_code/Value:software patch+' => '',
	'Class:UserRequest/Attribute:resolution_code/Value:system update' => 'Aktualizácia systému',
	'Class:UserRequest/Attribute:resolution_code/Value:system update+' => '',
	'Class:UserRequest/Attribute:resolution_code/Value:training' => 'Školenie',
	'Class:UserRequest/Attribute:resolution_code/Value:training+' => '',
	'Class:UserRequest/Attribute:solution' => 'Riešenie',
	'Class:UserRequest/Attribute:solution+' => '',
	'Class:UserRequest/Attribute:pending_reason' => 'Dôvod pozdržania',
	'Class:UserRequest/Attribute:pending_reason+' => '',
	'Class:UserRequest/Attribute:parent_request_id' => 'Nadradená Požiadavka',
	'Class:UserRequest/Attribute:parent_request_id+' => '',
	'Class:UserRequest/Attribute:parent_change_id' => 'Nadradená Zmena',
	'Class:UserRequest/Attribute:parent_change_id+' => '',
	'Class:UserRequest/Attribute:related_request_list' => 'Podriadené požiadavky',
	'Class:UserRequest/Attribute:related_request_list+' => 'All the requests that are linked to this parent request~~',
	'Class:UserRequest/Attribute:public_log' => 'Verejný záznam',
	'Class:UserRequest/Attribute:public_log+' => '',
	'Class:UserRequest/Attribute:user_satisfaction' => 'Spokojnosť užívateľa',
	'Class:UserRequest/Attribute:user_satisfaction+' => '',
	'Class:UserRequest/Attribute:user_satisfaction/Value:1' => 'Veľmi spokojný',
	'Class:UserRequest/Attribute:user_satisfaction/Value:1+' => '',
	'Class:UserRequest/Attribute:user_satisfaction/Value:2' => 'Pomerne spokojný',
	'Class:UserRequest/Attribute:user_satisfaction/Value:2+' => '',
	'Class:UserRequest/Attribute:user_satisfaction/Value:3' => 'Skôr nespokojný',
	'Class:UserRequest/Attribute:user_satisfaction/Value:3+' => '',
	'Class:UserRequest/Attribute:user_satisfaction/Value:4' => 'Veľmi nespokojný',
	'Class:UserRequest/Attribute:user_satisfaction/Value:4+' => '',
	'Class:UserRequest/Attribute:user_comment' => 'Komentár užívateľa',
	'Class:UserRequest/Attribute:user_comment+' => '',
	'Class:UserRequest/Stimulus:ev_assign' => 'Prideiť',
	'Class:UserRequest/Stimulus:ev_assign+' => '',
	'Class:UserRequest/Stimulus:ev_reassign' => 'Znovu Prideiť',
	'Class:UserRequest/Stimulus:ev_reassign+' => '',
	'Class:UserRequest/Stimulus:ev_approve' => 'Schváliť',
	'Class:UserRequest/Stimulus:ev_approve+' => '',
	'Class:UserRequest/Stimulus:ev_reject' => 'Zamietnúť',
	'Class:UserRequest/Stimulus:ev_reject+' => '',
	'Class:UserRequest/Stimulus:ev_pending' => 'Pozdržať',
	'Class:UserRequest/Stimulus:ev_pending+' => '',
	'Class:UserRequest/Stimulus:ev_timeout' => 'Vypršanie času',
	'Class:UserRequest/Stimulus:ev_timeout+' => '',
	'Class:UserRequest/Stimulus:ev_autoresolve' => 'Automatické vyriešenie',
	'Class:UserRequest/Stimulus:ev_autoresolve+' => '',
	'Class:UserRequest/Stimulus:ev_autoclose' => 'Automatické zatvorenie',
	'Class:UserRequest/Stimulus:ev_autoclose+' => '',
	'Class:UserRequest/Stimulus:ev_resolve' => 'Vyriešiť',
	'Class:UserRequest/Stimulus:ev_resolve+' => '',
	'Class:UserRequest/Stimulus:ev_close' => 'Zatvoriť',
	'Class:UserRequest/Stimulus:ev_close+' => '',
	'Class:UserRequest/Stimulus:ev_reopen' => 'Znova otvoriť',
	'Class:UserRequest/Stimulus:ev_reopen+' => '',
	'Class:UserRequest/Stimulus:ev_wait_for_approval' => 'Počkať na schválenie',
	'Class:UserRequest/Stimulus:ev_wait_for_approval+' => '',
	'Class:UserExternal' => 'Externý užívateľ',
	'Class:UserExternal+' => '',
	'Class:UserLDAP' => 'LDAP užívateľ',
	'Class:UserLDAP+' => '',
	'Class:UserLocal' => ITOP_APPLICATION_SHORT.' užívateľ',
	'Class:UserLocal+' => '',
	'Class:UserLocal/Attribute:password' => 'Heslo',
	'Class:UserLocal/Attribute:password+' => '',
	'Attachments:TabTitle_Count' => 'Prílohy (%1$d)',
	'Attachments:EmptyTabTitle' => 'Prílohy',
	'Attachments:FieldsetTitle' => 'Prílohy',
	'Attachments:DeleteBtn' => 'Odstrániť',
	'Attachments:History_File_Added' => 'Príloha %1$s pridaná.',
	'Attachments:History_File_Removed' => 'Príloha %1$s odstránená.',
	'Attachments:AddAttachment' => 'Pridaj prílohu: ',
	'Attachments:UploadNotAllowedOnThisSystem' => 'Nahrávanie súboru NIE JE povolené na tomto systéme.',
	'Attachment:Max_Go' => '(Maximálna Veľkosť súboru : %1$s Go)',
	'Attachment:Max_Mo' => '(Maximálna Veľkosť súboru : %1$s Mo)',
	'Attachment:Max_Ko' => '(Maximálna Veľkosť súboru : %1$s Ko)',
	'Attachments:NoAttachment' => 'Bez prílohy. ',
	'Relation:impacts/Description' => 'Prvky zasiahnuté',
	'Relation:impacts/VerbUp' => 'Dopad...',
	'Relation:impacts/VerbDown' => 'Prvky zasiahnuté ...',
	'Relation:depends on/Description' => 'Prvky, od ktorých závisí tento prvok',
	'Relation:depends on/VerbUp' => 'Závisí od...',
	'Relation:depends on/VerbDown' => 'Dopady...',
	'Class:Organization/Attribute:parent_name' => 'Nadradená organizácia',
	'Class:Organization/Attribute:parent_name+' => '',
	'Class:Organization/Attribute:deliverymodel_name' => 'Názov modelu dodávky',
	'Class:Organization/Attribute:deliverymodel_name+' => '',
	'Class:Organization/Attribute:parent_id_friendlyname' => 'Nadradená organizácia',
	'Class:Organization/Attribute:parent_id_friendlyname+' => '',
	'Class:Location/Attribute:org_name' => 'Názov organizácie vlastníka',
	'Class:Location/Attribute:org_name+' => '',
	'Class:Contact' => 'Kontakt',
	'Class:Contact+' => '',
	'Class:Contact/Attribute:name' => 'Meno',
	'Class:Contact/Attribute:name+' => '',
	'Class:Contact/Attribute:status' => 'Stav',
	'Class:Contact/Attribute:status+' => '',
	'Class:Contact/Attribute:status/Value:active' => 'Aktívny',
	'Class:Contact/Attribute:status/Value:active+' => '',
	'Class:Contact/Attribute:status/Value:inactive' => 'Neaktívny',
	'Class:Contact/Attribute:status/Value:inactive+' => '',
	'Class:Contact/Attribute:org_id' => 'Organizácia',
	'Class:Contact/Attribute:org_id+' => '',
	'Class:Contact/Attribute:org_name' => 'Názov Organizácie',
	'Class:Contact/Attribute:org_name+' => '',
	'Class:Contact/Attribute:email' => 'Email',
	'Class:Contact/Attribute:email+' => '',
	'Class:Contact/Attribute:phone' => 'Telefón',
	'Class:Contact/Attribute:phone+' => '',
	'Class:Contact/Attribute:notify' => 'Upozornenie',
	'Class:Contact/Attribute:notify+' => '',
	'Class:Contact/Attribute:notify/Value:no' => 'nie',
	'Class:Contact/Attribute:notify/Value:no+' => '',
	'Class:Contact/Attribute:notify/Value:yes' => 'áno',
	'Class:Contact/Attribute:notify/Value:yes+' => '',
	'Class:Contact/Attribute:function' => 'Funkcia',
	'Class:Contact/Attribute:function+' => '',
	'Class:Contact/Attribute:cis_list' => 'Zariadenia',
	'Class:Contact/Attribute:cis_list+' => 'All the configuration items linked to this contact~~',
	'Class:Contact/Attribute:finalclass' => 'Typ kontaktu',
	'Class:Contact/Attribute:finalclass+' => '',
	'Class:Person/Attribute:name' => 'Priezvisko',
	'Class:Person/Attribute:name+' => '',
	'Class:Person/Attribute:location_name' => 'Názov lokality',
	'Class:Person/Attribute:location_name+' => '',
	'Class:Person/Attribute:manager_name' => 'Meno manažéra',
	'Class:Person/Attribute:manager_name+' => '',
	'Class:Person/Attribute:manager_id_friendlyname' => 'Ľahko čitateľné meno manažéra',
	'Class:Person/Attribute:manager_id_friendlyname+' => '',
	'Class:Document' => 'Dokument',
	'Class:Document+' => '',
	'Class:Document/Attribute:name' => 'Názov',
	'Class:Document/Attribute:name+' => '',
	'Class:Document/Attribute:org_id' => 'Organizácia',
	'Class:Document/Attribute:org_id+' => '',
	'Class:Document/Attribute:org_name' => 'Názov Organizácie',
	'Class:Document/Attribute:org_name+' => '',
	'Class:Document/Attribute:documenttype_id' => 'Typ dokumentu',
	'Class:Document/Attribute:documenttype_id+' => '',
	'Class:Document/Attribute:documenttype_name' => 'Názov typu dokumentu',
	'Class:Document/Attribute:documenttype_name+' => '',
	'Class:Document/Attribute:description' => 'Popis',
	'Class:Document/Attribute:description+' => '',
	'Class:Document/Attribute:status' => 'Stav',
	'Class:Document/Attribute:status+' => '',
	'Class:Document/Attribute:status/Value:draft' => 'Návrh',
	'Class:Document/Attribute:status/Value:draft+' => '',
	'Class:Document/Attribute:status/Value:obsolete' => 'Vyradený',
	'Class:Document/Attribute:status/Value:obsolete+' => '',
	'Class:Document/Attribute:status/Value:published' => 'Publikovaný',
	'Class:Document/Attribute:status/Value:published+' => '',
	'Class:Document/Attribute:cis_list' => 'Komponenty',
	'Class:Document/Attribute:cis_list+' => 'All the configuration items linked to this document~~',
	'Class:Document/Attribute:contracts_list' => 'Zmluvy',
	'Class:Document/Attribute:contracts_list+' => 'All the contracts linked to this document~~',
	'Class:Document/Attribute:services_list' => 'Služby',
	'Class:Document/Attribute:services_list+' => 'All the services linked to this document~~',
	'Class:Document/Attribute:finalclass' => 'Typ dokumentu',
	'Class:Document/Attribute:finalclass+' => '',
	'Class:FunctionalCI' => 'Komponent',
	'Class:FunctionalCI+' => '',
	'Class:FunctionalCI/Attribute:name' => 'Názov',
	'Class:FunctionalCI/Attribute:name+' => '',
	'Class:FunctionalCI/Attribute:description' => 'Popis',
	'Class:FunctionalCI/Attribute:description+' => '',
	'Class:FunctionalCI/Attribute:org_id' => 'Organizácia',
	'Class:FunctionalCI/Attribute:org_id+' => '',
	'Class:FunctionalCI/Attribute:organization_name' => 'Názov Organizácie',
	'Class:FunctionalCI/Attribute:organization_name+' => '',
	'Class:FunctionalCI/Attribute:business_criticity' => 'Dôležitosť pre biznis',
	'Class:FunctionalCI/Attribute:business_criticity+' => '',
	'Class:FunctionalCI/Attribute:business_criticity/Value:high' => 'vysoká',
	'Class:FunctionalCI/Attribute:business_criticity/Value:high+' => '',
	'Class:FunctionalCI/Attribute:business_criticity/Value:low' => 'nízka',
	'Class:FunctionalCI/Attribute:business_criticity/Value:low+' => '',
	'Class:FunctionalCI/Attribute:business_criticity/Value:medium' => 'stredná',
	'Class:FunctionalCI/Attribute:business_criticity/Value:medium+' => '',
	'Class:FunctionalCI/Attribute:move2production' => 'Dátum presunu do produkcie',
	'Class:FunctionalCI/Attribute:move2production+' => '',
	'Class:FunctionalCI/Attribute:contacts_list' => 'Kontakty',
	'Class:FunctionalCI/Attribute:contacts_list+' => 'All the contacts for this configuration item~~',
	'Class:FunctionalCI/Attribute:documents_list' => 'Zoznam dokumentov',
	'Class:FunctionalCI/Attribute:documents_list+' => 'All the documents linked to this configuration item~~',
	'Class:FunctionalCI/Attribute:applicationsolution_list' => 'Zoznam aplikačných riešení',
	'Class:FunctionalCI/Attribute:applicationsolution_list+' => 'All the application solutions depending on this configuration item~~',
	'Class:FunctionalCI/Attribute:providercontracts_list' => 'Poskytovateľské zmluvy',
	'Class:FunctionalCI/Attribute:providercontracts_list+' => 'All the provider contracts for this configuration item~~',
	'Class:FunctionalCI/Attribute:services_list' => 'Služby',
	'Class:FunctionalCI/Attribute:services_list+' => '',
	'Class:FunctionalCI/Attribute:softwares_list' => 'Softvér',
	'Class:FunctionalCI/Attribute:softwares_list+' => 'All the softwares installed on this configuration item~~',
	'Class:FunctionalCI/Attribute:tickets_list' => 'Tickety',
	'Class:FunctionalCI/Attribute:tickets_list+' => '',
	'Class:FunctionalCI/Attribute:finalclass' => 'Typ komponentu',
	'Class:FunctionalCI/Attribute:finalclass+' => '',
	'Class:PhysicalDevice' => 'Fyzické zariadenie',
	'Class:PhysicalDevice+' => '',
	'Class:PhysicalDevice/Attribute:serialnumber' => 'Sériové číslo',
	'Class:PhysicalDevice/Attribute:serialnumber+' => '',
	'Class:PhysicalDevice/Attribute:location_id' => 'Lokalita',
	'Class:PhysicalDevice/Attribute:location_id+' => '',
	'Class:PhysicalDevice/Attribute:location_name' => 'Názov lokality',
	'Class:PhysicalDevice/Attribute:location_name+' => '',
	'Class:PhysicalDevice/Attribute:status' => 'Stav',
	'Class:PhysicalDevice/Attribute:status+' => '',
	'Class:PhysicalDevice/Attribute:status/Value:implementation' => 'Implementácia',
	'Class:PhysicalDevice/Attribute:status/Value:implementation+' => '',
	'Class:PhysicalDevice/Attribute:status/Value:obsolete' => 'vyradené',
	'Class:PhysicalDevice/Attribute:status/Value:obsolete+' => '',
	'Class:PhysicalDevice/Attribute:status/Value:production' => 'v produkcií',
	'Class:PhysicalDevice/Attribute:status/Value:production+' => '',
	'Class:PhysicalDevice/Attribute:status/Value:stock' => 'na sklade',
	'Class:PhysicalDevice/Attribute:status/Value:stock+' => '',
	'Class:PhysicalDevice/Attribute:brand_id' => 'Značka',
	'Class:PhysicalDevice/Attribute:brand_id+' => '',
	'Class:PhysicalDevice/Attribute:brand_name' => 'Názov značky',
	'Class:PhysicalDevice/Attribute:brand_name+' => '',
	'Class:PhysicalDevice/Attribute:model_id' => 'Model',
	'Class:PhysicalDevice/Attribute:model_id+' => '',
	'Class:PhysicalDevice/Attribute:model_name' => 'Názov modelu',
	'Class:PhysicalDevice/Attribute:model_name+' => '',
	'Class:PhysicalDevice/Attribute:asset_number' => 'Číslo položky',
	'Class:PhysicalDevice/Attribute:asset_number+' => '',
	'Class:PhysicalDevice/Attribute:purchase_date' => 'Dátum zakúpenia',
	'Class:PhysicalDevice/Attribute:purchase_date+' => '',
	'Class:PhysicalDevice/Attribute:end_of_warranty' => 'Koniec záruky',
	'Class:PhysicalDevice/Attribute:end_of_warranty+' => '',
	'Class:TelephonyCI' => 'Telefónne zariadenie',
	'Class:TelephonyCI+' => '',
	'Class:TelephonyCI/Attribute:phonenumber' => 'Telefónne číslo',
	'Class:TelephonyCI/Attribute:phonenumber+' => '',
	'Class:ConnectableCI' => 'Pripojiteľné zariadenie',
	'Class:ConnectableCI+' => '',
	'Class:ConnectableCI/Attribute:networkdevice_list' => 'Sieťové zariadenia',
	'Class:ConnectableCI/Attribute:networkdevice_list+' => 'All network devices connected to this device~~',
	'Class:ConnectableCI/Attribute:physicalinterface_list' => 'Sieťové rozhrania',
	'Class:ConnectableCI/Attribute:physicalinterface_list+' => 'All the physical network interfaces~~',
	'Class:DatacenterDevice' => 'Zariadenie dátového centra',
	'Class:DatacenterDevice+' => '',
	'Class:DatacenterDevice/Attribute:rack_id' => 'stojan (Rack)',
	'Class:DatacenterDevice/Attribute:rack_id+' => '',
	'Class:DatacenterDevice/Attribute:rack_name' => 'Názov stojanu',
	'Class:DatacenterDevice/Attribute:rack_name+' => '',
	'Class:DatacenterDevice/Attribute:enclosure_id' => 'Kryt',
	'Class:DatacenterDevice/Attribute:enclosure_id+' => '',
	'Class:DatacenterDevice/Attribute:enclosure_name' => 'Názov krytu',
	'Class:DatacenterDevice/Attribute:enclosure_name+' => '',
	'Class:DatacenterDevice/Attribute:nb_u' => 'NB U',
	'Class:DatacenterDevice/Attribute:nb_u+' => '',
	'Class:DatacenterDevice/Attribute:managementip' => 'Menežmentová IP adresa',
	'Class:DatacenterDevice/Attribute:managementip+' => '',
	'Class:DatacenterDevice/Attribute:powerA_id' => 'Zdroj napájania A',
	'Class:DatacenterDevice/Attribute:powerA_id+' => '',
	'Class:DatacenterDevice/Attribute:powerA_name' => 'Názov zdroja napájania A',
	'Class:DatacenterDevice/Attribute:powerA_name+' => '',
	'Class:DatacenterDevice/Attribute:powerB_id' => 'Zdroj napájania B',
	'Class:DatacenterDevice/Attribute:powerB_id+' => '',
	'Class:DatacenterDevice/Attribute:powerB_name' => 'Názov zdroja napájania B',
	'Class:DatacenterDevice/Attribute:powerB_name+' => '',
	'Class:DatacenterDevice/Attribute:fiberinterfacelist_list' => 'Zoznam optických rozhraní',
	'Class:DatacenterDevice/Attribute:fiberinterfacelist_list+' => 'All the fiber channel interfaces for this device~~',
	'Class:DatacenterDevice/Attribute:san_list' => 'Úložiská (SAN)',
	'Class:DatacenterDevice/Attribute:san_list+' => 'All the SAN switches connected to this device~~',
	'Class:NetworkDevice/Attribute:networkdevicetype_name' => 'Názov typu sieťového zariadenia',
	'Class:NetworkDevice/Attribute:networkdevicetype_name+' => '',
	'Class:NetworkDevice/Attribute:iosversion_name' => 'Názov IOS verzie',
	'Class:NetworkDevice/Attribute:iosversion_name+' => '',
	'Class:Server/Attribute:osfamily_name' => 'Názov kategórie OS',
	'Class:Server/Attribute:osfamily_name+' => '',
	'Class:Server/Attribute:osversion_name' => 'Názov verzie OS',
	'Class:Server/Attribute:osversion_name+' => '',
	'Class:Server/Attribute:oslicence_name' => 'Názov licence OS',
	'Class:Server/Attribute:oslicence_name+' => '',
	'Class:PC/Attribute:osfamily_name' => 'Názov kategórie OS',
	'Class:PC/Attribute:osfamily_name+' => '',
	'Class:PC/Attribute:osversion_name' => 'Názov verzie OS',
	'Class:PC/Attribute:osversion_name+' => '',
	'Class:PowerConnection' => 'Elektrická prípojka',
	'Class:PowerConnection+' => '',
	'Class:PDU/Attribute:rack_name' => 'Názov stojanu (rack)',
	'Class:PDU/Attribute:rack_name+' => '',
	'Class:PDU/Attribute:powerstart_name' => 'Názov Power start-u',
	'Class:PDU/Attribute:powerstart_name+' => '',
	'Class:Enclosure/Attribute:rack_name' => 'Názov stojanu (rack)',
	'Class:Enclosure/Attribute:rack_name+' => '',
	'Class:SoftwareInstance' => 'Softvérová inštancia',
	'Class:SoftwareInstance+' => '',
	'Class:SoftwareInstance/Attribute:system_id' => 'Systém',
	'Class:SoftwareInstance/Attribute:system_id+' => '',
	'Class:SoftwareInstance/Attribute:system_name' => 'Názov systému',
	'Class:SoftwareInstance/Attribute:system_name+' => '',
	'Class:SoftwareInstance/Attribute:software_id' => 'Softvér',
	'Class:SoftwareInstance/Attribute:software_id+' => '',
	'Class:SoftwareInstance/Attribute:software_name' => 'Názov softvéru',
	'Class:SoftwareInstance/Attribute:software_name+' => '',
	'Class:SoftwareInstance/Attribute:softwarelicence_id' => 'Softvérová licencia',
	'Class:SoftwareInstance/Attribute:softwarelicence_id+' => '',
	'Class:SoftwareInstance/Attribute:softwarelicence_name' => 'Názov softvérovej licencie',
	'Class:SoftwareInstance/Attribute:softwarelicence_name+' => '',
	'Class:SoftwareInstance/Attribute:path' => 'Cesta',
	'Class:SoftwareInstance/Attribute:path+' => '',
	'Class:SoftwareInstance/Attribute:status' => 'Stav',
	'Class:SoftwareInstance/Attribute:status+' => '',
	'Class:SoftwareInstance/Attribute:status/Value:active' => 'aktívna',
	'Class:SoftwareInstance/Attribute:status/Value:active+' => '',
	'Class:SoftwareInstance/Attribute:status/Value:inactive' => 'neaktívna',
	'Class:SoftwareInstance/Attribute:status/Value:inactive+' => '',
	'Class:MiddlewareInstance/Attribute:middleware_name' => 'Názov Middleware-u',
	'Class:MiddlewareInstance/Attribute:middleware_name+' => '',
	'Class:DatabaseSchema/Attribute:dbserver_name' => 'Názov DB serveru',
	'Class:DatabaseSchema/Attribute:dbserver_name+' => '',
	'Class:WebApplication/Attribute:webserver_name' => 'Názov Web serveru',
	'Class:WebApplication/Attribute:webserver_name+' => '',
	'Class:VirtualDevice' => 'Virtuálne zariadenie',
	'Class:VirtualDevice+' => '',
	'Class:VirtualDevice/Attribute:status' => 'Stav',
	'Class:VirtualDevice/Attribute:status+' => '',
	'Class:VirtualDevice/Attribute:status/Value:implementation' => 'Implementácia',
	'Class:VirtualDevice/Attribute:status/Value:implementation+' => '',
	'Class:VirtualDevice/Attribute:status/Value:obsolete' => 'Vyradené',
	'Class:VirtualDevice/Attribute:status/Value:obsolete+' => '',
	'Class:VirtualDevice/Attribute:status/Value:production' => 'Produkcia',
	'Class:VirtualDevice/Attribute:status/Value:production+' => '',
	'Class:VirtualDevice/Attribute:status/Value:stock' => 'Zásoby',
	'Class:VirtualDevice/Attribute:status/Value:stock+' => '',
	'Class:VirtualDevice/Attribute:logicalvolumes_list' => 'Zoznam logických dielov',
	'Class:VirtualDevice/Attribute:logicalvolumes_list+' => 'All the logical volumes used by this device~~',
	'Class:VirtualHost' => 'Virtuálny host',
	'Class:VirtualHost+' => '',
	'Class:VirtualHost/Attribute:virtualmachine_list' => 'Zoznam virtuálnych strojov',
	'Class:VirtualHost/Attribute:virtualmachine_list+' => 'All the virtual machines hosted by this host~~',
	'Class:Hypervisor/Attribute:farm_name' => 'Názov farmy',
	'Class:Hypervisor/Attribute:farm_name+' => '',
	'Class:Hypervisor/Attribute:server_name' => 'Názov serveru',
	'Class:Hypervisor/Attribute:server_name+' => '',
	'Class:VirtualMachine/Attribute:virtualhost_name' => 'Názov virtuálneho hosta',
	'Class:VirtualMachine/Attribute:virtualhost_name+' => '',
	'Class:VirtualMachine/Attribute:osfamily_name' => 'Názov kategórie OS',
	'Class:VirtualMachine/Attribute:osfamily_name+' => '',
	'Class:VirtualMachine/Attribute:osversion_name' => 'Názov OS verzie',
	'Class:VirtualMachine/Attribute:osversion_name+' => '',
	'Class:VirtualMachine/Attribute:oslicence_name' => 'OS licence Názov',
	'Class:VirtualMachine/Attribute:oslicence_name+' => '',
	'Class:LogicalVolume/Attribute:storagesystem_name' => 'Názov úložného systému',
	'Class:LogicalVolume/Attribute:storagesystem_name+' => '',
	'Class:lnkServerToVolume/Attribute:volume_name' => 'Názov dielu',
	'Class:lnkServerToVolume/Attribute:volume_name+' => '',
	'Class:lnkServerToVolume/Attribute:server_name' => 'Názov serveru',
	'Class:lnkServerToVolume/Attribute:server_name+' => '',
	'Class:lnkVirtualDeviceToVolume/Attribute:volume_name' => 'Názov dielu',
	'Class:lnkVirtualDeviceToVolume/Attribute:volume_name+' => '',
	'Class:lnkVirtualDeviceToVolume/Attribute:virtualdevice_name' => 'Názov virtuálneho zariadenia',
	'Class:lnkVirtualDeviceToVolume/Attribute:virtualdevice_name+' => '',
	'Class:lnkSanToDatacenterDevice/Attribute:san_name' => 'Názov SAN prepínaču',
	'Class:lnkSanToDatacenterDevice/Attribute:san_name+' => '',
	'Class:lnkSanToDatacenterDevice/Attribute:datacenterdevice_name' => 'Názov zariadenia',
	'Class:lnkSanToDatacenterDevice/Attribute:datacenterdevice_name+' => '',
	'Class:Tape/Attribute:tapelibrary_name' => 'Názov knižnice pásiek',
	'Class:Tape/Attribute:tapelibrary_name+' => '',
	'Class:NASFileSystem/Attribute:nas_name' => 'Názov NAS',
	'Class:NASFileSystem/Attribute:nas_name+' => '',
	'Class:Patch' => 'Záplata',
	'Class:Patch+' => '',
	'Class:Patch/Attribute:name' => 'Názov',
	'Class:Patch/Attribute:name+' => '',
	'Class:Patch/Attribute:documents_list' => 'Zoznam dokumentov',
	'Class:Patch/Attribute:documents_list+' => 'All the documents linked to this patch~~',
	'Class:Patch/Attribute:description' => 'Popis',
	'Class:Patch/Attribute:description+' => '',
	'Class:Patch/Attribute:finalclass' => 'Typ',
	'Class:Patch/Attribute:finalclass+' => '',
	'Class:OSPatch/Attribute:osversion_name' => 'Názov OS verzie',
	'Class:OSPatch/Attribute:osversion_name+' => '',
	'Class:SoftwarePatch/Attribute:software_name' => 'Názov softvéru',
	'Class:SoftwarePatch/Attribute:software_name+' => '',
	'Class:Licence' => 'Licencia',
	'Class:Licence+' => '',
	'Class:Licence/Attribute:name' => 'Názov',
	'Class:Licence/Attribute:name+' => '',
	'Class:Licence/Attribute:documents_list' => 'Zoznam dokumentov',
	'Class:Licence/Attribute:documents_list+' => 'All the documents linked to this license~~',
	'Class:Licence/Attribute:org_id' => 'Organizácia',
	'Class:Licence/Attribute:org_id+' => '',
	'Class:Licence/Attribute:organization_name' => 'Názov organizácie',
	'Class:Licence/Attribute:organization_name+' => '',
	'Class:Licence/Attribute:usage_limit' => 'Limit používania',
	'Class:Licence/Attribute:usage_limit+' => '',
	'Class:Licence/Attribute:description' => 'Popis',
	'Class:Licence/Attribute:description+' => '',
	'Class:Licence/Attribute:start_date' => 'Dátum začiatku',
	'Class:Licence/Attribute:start_date+' => '',
	'Class:Licence/Attribute:end_date' => 'Dátum ukončenia',
	'Class:Licence/Attribute:end_date+' => '',
	'Class:Licence/Attribute:licence_key' => 'Licenčný kľúč',
	'Class:Licence/Attribute:licence_key+' => '',
	'Class:Licence/Attribute:perpetual' => 'Pretrvávajúci',
	'Class:Licence/Attribute:perpetual+' => '',
	'Class:Licence/Attribute:perpetual/Value:no' => 'Nie',
	'Class:Licence/Attribute:perpetual/Value:no+' => '',
	'Class:Licence/Attribute:perpetual/Value:yes' => 'Áno',
	'Class:Licence/Attribute:perpetual/Value:yes+' => '',
	'Class:Licence/Attribute:finalclass' => 'Typ',
	'Class:Licence/Attribute:finalclass+' => '',
	'Class:OSLicence/Attribute:osversion_name' => 'Názov OS verzie',
	'Class:OSLicence/Attribute:osversion_name+' => '',
	'Class:SoftwareLicence/Attribute:software_name' => 'Názov softvéru',
	'Class:SoftwareLicence/Attribute:software_name+' => '',
	'Class:lnkDocumentToLicence/Attribute:licence_name' => 'Názov licence',
	'Class:lnkDocumentToLicence/Attribute:licence_name+' => '',
	'Class:lnkDocumentToLicence/Attribute:document_name' => 'Názov dokumentu',
	'Class:lnkDocumentToLicence/Attribute:document_name+' => '',
	'Class:Typology' => 'Typológia',
	'Class:Typology+' => '',
	'Class:Typology/Attribute:name' => 'Názov',
	'Class:Typology/Attribute:name+' => '',
	'Class:Typology/Attribute:finalclass' => 'Typ',
	'Class:Typology/Attribute:finalclass+' => '',
	'Class:OSVersion/Attribute:osfamily_name' => 'Názov kategórie OS',
	'Class:OSVersion/Attribute:osfamily_name+' => '',
	'Class:Model/Attribute:brand_name' => 'Názov značky',
	'Class:Model/Attribute:brand_name+' => '',
	'Class:IOSVersion/Attribute:brand_name' => 'Názov značky',
	'Class:IOSVersion/Attribute:brand_name+' => '',
	'Class:lnkDocumentToPatch/Attribute:patch_name' => 'Názov záplaty',
	'Class:lnkDocumentToPatch/Attribute:patch_name+' => '',
	'Class:lnkDocumentToPatch/Attribute:document_name' => 'Názov dokumentu',
	'Class:lnkDocumentToPatch/Attribute:document_name+' => '',
	'Class:lnkSoftwareInstanceToSoftwarePatch/Attribute:softwarepatch_name' => 'Názov softvérovej záplaty',
	'Class:lnkSoftwareInstanceToSoftwarePatch/Attribute:softwarepatch_name+' => '',
	'Class:lnkSoftwareInstanceToSoftwarePatch/Attribute:softwareinstance_name' => 'Názov softvérovej inštancie',
	'Class:lnkSoftwareInstanceToSoftwarePatch/Attribute:softwareinstance_name+' => '',
	'Class:lnkFunctionalCIToOSPatch/Attribute:ospatch_name' => 'Názov OS záplaty',
	'Class:lnkFunctionalCIToOSPatch/Attribute:ospatch_name+' => '',
	'Class:lnkFunctionalCIToOSPatch/Attribute:functionalci_name' => 'Názov funkčných CI',
	'Class:lnkFunctionalCIToOSPatch/Attribute:functionalci_name+' => '',
	'Class:lnkDocumentToSoftware/Attribute:software_name' => 'Názov softvéru',
	'Class:lnkDocumentToSoftware/Attribute:software_name+' => '',
	'Class:lnkDocumentToSoftware/Attribute:document_name' => 'Názov dokumentu',
	'Class:lnkDocumentToSoftware/Attribute:document_name+' => '',
	'Class:lnkContactToFunctionalCI/Attribute:functionalci_name' => 'Názov funkčných CI',
	'Class:lnkContactToFunctionalCI/Attribute:functionalci_name+' => '',
	'Class:lnkContactToFunctionalCI/Attribute:contact_name' => 'Názov kontaktu',
	'Class:lnkContactToFunctionalCI/Attribute:contact_name+' => '',
	'Class:lnkDocumentToFunctionalCI/Attribute:functionalci_name' => 'Názov funkčných CI',
	'Class:lnkDocumentToFunctionalCI/Attribute:functionalci_name+' => '',
	'Class:lnkDocumentToFunctionalCI/Attribute:document_name' => 'Názov dokumentu',
	'Class:lnkDocumentToFunctionalCI/Attribute:document_name+' => '',
	'Class:Subnet/Attribute:org_name' => 'Názov organizácie',
	'Class:Subnet/Attribute:org_name+' => '',
	'Class:NetworkInterface' => 'Sieťové rozhranie',
	'Class:NetworkInterface+' => '',
	'Class:NetworkInterface/Attribute:name' => 'Názov',
	'Class:NetworkInterface/Attribute:name+' => '',
	'Class:NetworkInterface/Attribute:finalclass' => 'Typ',
	'Class:NetworkInterface/Attribute:finalclass+' => '',
	'Class:IPInterface' => 'IP rozhranie',
	'Class:IPInterface+' => '',
	'Class:IPInterface/Attribute:ipaddress' => 'IP Adresa',
	'Class:IPInterface/Attribute:ipaddress+' => '',
	'Class:IPInterface/Attribute:macaddress' => 'MAC Adresa',
	'Class:IPInterface/Attribute:macaddress+' => '',
	'Class:IPInterface/Attribute:comment' => 'Komentár',
	'Class:IPInterface/Attribute:coment+' => '',
	'Class:IPInterface/Attribute:ipgateway' => 'Východzia brána IP',
	'Class:IPInterface/Attribute:ipgateway+' => '',
	'Class:IPInterface/Attribute:ipmask' => 'Maska IP adresy',
	'Class:IPInterface/Attribute:ipmask+' => '',
	'Class:IPInterface/Attribute:speed' => 'Rýchlosť',
	'Class:IPInterface/Attribute:speed+' => '',
	'Class:PhysicalInterface/Attribute:connectableci_name' => 'Názov zariadenia',
	'Class:PhysicalInterface/Attribute:connectableci_name+' => '',
	'Class:LogicalInterface/Attribute:virtualmachine_name' => 'Názov virtuálneho stroja',
	'Class:LogicalInterface/Attribute:virtualmachine_name+' => '',
	'Class:FiberChannelInterface/Attribute:datacenterdevice_name' => 'Názov zariadenia',
	'Class:FiberChannelInterface/Attribute:datacenterdevice_name+' => '',
	'Class:lnkConnectableCIToNetworkDevice/Attribute:networkdevice_name' => 'Názov sieťového zariadenia',
	'Class:lnkConnectableCIToNetworkDevice/Attribute:networkdevice_name+' => '',
	'Class:lnkConnectableCIToNetworkDevice/Attribute:connectableci_name' => 'Názov pripojeného zariadenia',
	'Class:lnkConnectableCIToNetworkDevice/Attribute:connectableci_name+' => '',
	'Class:lnkApplicationSolutionToFunctionalCI/Attribute:applicationsolution_name' => 'Názov aplikačného riešenia',
	'Class:lnkApplicationSolutionToFunctionalCI/Attribute:applicationsolution_name+' => '',
	'Class:lnkApplicationSolutionToFunctionalCI/Attribute:functionalci_name' => 'Názov funkčných CI',
	'Class:lnkApplicationSolutionToFunctionalCI/Attribute:functionalci_name+' => '',
	'Class:lnkApplicationSolutionToBusinessProcess/Attribute:businessprocess_name' => 'Názov biznisových procesov',
	'Class:lnkApplicationSolutionToBusinessProcess/Attribute:businessprocess_name+' => '',
	'Class:lnkApplicationSolutionToBusinessProcess/Attribute:applicationsolution_name' => 'Názov aplikačného riešenia',
	'Class:lnkApplicationSolutionToBusinessProcess/Attribute:applicationsolution_name+' => '',
	'Class:lnkPersonToTeam/Attribute:team_name' => 'Názov tímu',
	'Class:lnkPersonToTeam/Attribute:team_name+' => '',
	'Class:lnkPersonToTeam/Attribute:person_name' => 'Meno osoby',
	'Class:lnkPersonToTeam/Attribute:person_name+' => '',
	'Class:lnkPersonToTeam/Attribute:role_name' => 'Názov role',
	'Class:lnkPersonToTeam/Attribute:role_name+' => '',
	'Class:Group/Attribute:owner_name' => 'Meno vlastníka',
	'Class:Group/Attribute:owner_name+' => '',
	'Class:Group/Attribute:parent_name' => 'Meno rodiča',
	'Class:Group/Attribute:parent_name+' => '',
	'Class:Group/Attribute:parent_id_friendlyname' => 'Priateľské meno rodičovskej skupiny',
	'Class:Group/Attribute:parent_id_friendlyname+' => '',
	'Class:lnkGroupToCI/Attribute:group_name' => 'Názov',
	'Class:lnkGroupToCI/Attribute:group_name+' => '',
	'Class:lnkGroupToCI/Attribute:ci_name' => 'Názov',
	'Class:lnkGroupToCI/Attribute:ci_name+' => '',
	'Menu:Catalogs' => 'Katalógy',
	'Menu:Catalogs+' => '',
	'Menu:Audit' => 'Audity',
	'Menu:Audit+' => '',
	'Menu:Organization' => 'Organizácia',
	'Menu:Organization+' => '',
	'Menu:Application' => 'Aplikácie',
	'Menu:Application+' => '',
	'Menu:DBServer' => 'Databázové servery',
	'Menu:DBServer+' => '',
	'Menu:ConfigManagement' => 'Manažment konfigurácie',
	'Menu:ConfigManagement+' => '',
	'Menu:ConfigManagementOverview' => 'Prehľad',
	'Menu:ConfigManagementOverview+' => '',
	'Menu:Contact' => 'Kontakty',
	'Menu:Contact+' => '',
	'Menu:Contact:Count' => '%1$d kontakt/y/ov',
	'Menu:Person' => 'Osoby',
	'Menu:Person+' => '',
	'Menu:Team' => 'Tímy',
	'Menu:Team+' => '',
	'Menu:Document' => 'Dokumenty',
	'Menu:Document+' => '',
	'Menu:Location' => 'Poloha',
	'Menu:Location+' => '',
	'Menu:ConfigManagementCI' => 'Konfiguračné položky',
	'Menu:ConfigManagementCI+' => '',
	'Menu:BusinessProcess' => 'Biznisové procesy',
	'Menu:BusinessProcess+' => '',
	'Menu:ApplicationSolution' => 'Aplikačné riešenia',
	'Menu:ApplicationSolution+' => '',
	'Menu:ConfigManagementSoftware' => 'Aplikačný manažment',
	'Menu:Licence' => 'Licencie',
	'Menu:Licence+' => '',
	'Menu:Patch' => 'Záplaty',
	'Menu:Patch+' => '',
	'Menu:ApplicationInstance' => 'Nainštalovaný softvér',
	'Menu:ApplicationInstance+' => '',
	'Menu:ConfigManagementHardware' => 'Manažment infraštruktúry',
	'Menu:Subnet' => 'Podsiete',
	'Menu:Subnet+' => '',
	'Menu:NetworkDevice' => 'Sieťové zariadenia',
	'Menu:NetworkDevice+' => '',
	'Menu:Server' => 'Servery',
	'Menu:Server+' => '',
	'Menu:Printer' => 'Tlačiarne',
	'Menu:Printer+' => '',
	'Menu:MobilePhone' => 'Mobilné telefóny',
	'Menu:MobilePhone+' => '',
	'Menu:PC' => 'Osobné počítače',
	'Menu:PC+' => '',
	'Menu:NewContact' => 'Nový kontakt',
	'Menu:NewContact+' => '',
	'Menu:SearchContacts' => 'Vyhľadať kontakty',
	'Menu:SearchContacts+' => '',
	'Menu:NewCI' => 'Nové CI',
	'Menu:NewCI+' => '',
	'Menu:SearchCIs' => 'Vyhľadať CIs',
	'Menu:SearchCIs+' => '',
	'Menu:ConfigManagement:Devices' => 'Zariadenia',
	'Menu:ConfigManagement:AllDevices' => 'Infraštruktúra',
	'Menu:ConfigManagement:virtualization' => 'Virtualizácia',
	'Menu:ConfigManagement:EndUsers' => 'Koncové užívateľské zariadenia',
	'Menu:ConfigManagement:SWAndApps' => 'Softvér a aplikácie',
	'Menu:ConfigManagement:Misc' => 'Rôzne',
	'Menu:Group' => 'Skupiny CI',
	'Menu:Group+' => '',
	'Menu:ConfigManagement:Shortcuts' => 'Skratky',
	'Menu:ConfigManagement:AllContacts' => 'Všetky kontakty: %1$d',
	'Menu:Typology' => 'Konfiguračná typológia',
	'Menu:Typology+' => '',
	'Menu:OSVersion' => 'OS verzie',
	'Menu:OSVersion+' => '',
	'Menu:Software' => 'Katalóg softvéru',
	'Menu:Software+' => '',
	'UI_WelcomeMenu_AllConfigItems' => 'Zhrnutie',
	'Menu:ConfigManagement:Typology' => 'Konfiguračná typológia',
	'Server:baseinfo' => 'Všeobecné informácie',
	'Server:Date' => 'Dátum',
	'Server:moreinfo' => 'Viac informácií',
	'Server:otherinfo' => 'Iné informácie',
	'Person:info' => 'Všeobecné informácie',
	'Class:Subnet/Tab:IPUsage' => 'Využívanosť IP adries',
	'Class:Subnet/Tab:IPUsage-explain' => 'Rozhrania majúce IP adresu v rozsahu: <em>%1$s</em> do <em>%2$s</em>',
	'Class:Subnet/Tab:FreeIPs' => 'Voľné IP adresy',
	'Class:Subnet/Tab:FreeIPs-count' => 'Voľných IP adries: %1$s',
	'Class:Subnet/Tab:FreeIPs-explain' => 'Tu je extrakt 10 voľných IP adries',
	'Menu:ServiceManagement' => 'Manažment služieb',
	'Menu:ServiceManagement+' => '',
	'Menu:Service:Overview' => 'Prehľad',
	'Menu:Service:Overview+' => '',
	'UI-ServiceManagementMenu-ContractsBySrvLevel' => 'zmluvy podľa úrovne služby',
	'UI-ServiceManagementMenu-ContractsByStatus' => 'zmluvy podla stavu',
	'UI-ServiceManagementMenu-ContractsEndingIn30Days' => 'zmluvy končiace za menej ako 30 dní',
	'Menu:ServiceType' => 'Typy služieb',
	'Menu:ServiceType+' => '',
	'Menu:ProviderContract' => 'Poskytovateľské zmluvy',
	'Menu:ProviderContract+' => '',
	'Menu:CustomerContract' => 'Zákaznícke zmluvy',
	'Menu:CustomerContract+' => '',
	'Menu:ServiceSubcategory' => 'Subkategórie služieb',
	'Menu:ServiceSubcategory+' => '',
	'Menu:Service' => 'Služby',
	'Menu:Service+' => '',
	'Menu:ServiceElement' => 'Prvky služby',
	'Menu:ServiceElement+' => '',
	'Menu:SLA' => 'SLAs',
	'Menu:SLA+' => '',
	'Menu:SLT' => 'SLTs',
	'Menu:SLT+' => '',
	'Menu:DeliveryModel' => 'Typy dodávky',
	'Menu:DeliveryModel+' => '',
	'Menu:ServiceFamily' => 'Rodiny služieb',
	'Menu:ServiceFamily+' => '',
	'Menu:Procedure' => 'Katalóg procedúr',
	'Menu:Procedure+' => '',
	'Class:Contract' => 'zmluva',
	'Class:Contract+' => '',
	'Class:Contract/Attribute:name' => 'Názov',
	'Class:Contract/Attribute:name+' => '',
	'Class:Contract/Attribute:org_id' => 'Zákazník',
	'Class:Contract/Attribute:org_id+' => '',
	'Class:Contract/Attribute:organization_name' => 'Meno zákazníka',
	'Class:Contract/Attribute:organization_name+' => '',
	'Class:Contract/Attribute:contacts_list' => 'Kontakty',
	'Class:Contract/Attribute:contacts_list+' => 'All the contacts for this customer contract~~',
	'Class:Contract/Attribute:documents_list' => 'Zoznam dokumentov',
	'Class:Contract/Attribute:documents_list+' => 'All the documents for this customer contract~~',
	'Class:Contract/Attribute:description' => 'Popis',
	'Class:Contract/Attribute:description+' => '',
	'Class:Contract/Attribute:start_date' => 'Dátum začiatku',
	'Class:Contract/Attribute:start_date+' => '',
	'Class:Contract/Attribute:end_date' => 'Dátum ukončenia',
	'Class:Contract/Attribute:end_date+' => '',
	'Class:Contract/Attribute:cost' => 'Cena',
	'Class:Contract/Attribute:cost+' => '',
	'Class:Contract/Attribute:cost_currency' => 'Mena ceny',
	'Class:Contract/Attribute:cost_currency+' => '',
	'Class:Contract/Attribute:cost_currency/Value:dollars' => 'USD',
	'Class:Contract/Attribute:cost_currency/Value:dollars+' => '',
	'Class:Contract/Attribute:cost_currency/Value:euros' => 'EUR',
	'Class:Contract/Attribute:cost_currency/Value:euros+' => '',
	'Class:Contract/Attribute:contracttype_id' => 'Typ zmluvy',
	'Class:Contract/Attribute:contracttype_id+' => '',
	'Class:Contract/Attribute:contracttype_name' => 'Názov typu zmluvy',
	'Class:Contract/Attribute:contracttype_name+' => '',
	'Class:Contract/Attribute:billing_frequency' => 'Frekvencia faktúrovania',
	'Class:Contract/Attribute:billing_frequency+' => '',
	'Class:Contract/Attribute:cost_unit' => 'Cenová jednotka',
	'Class:Contract/Attribute:cost_unit+' => '',
	'Class:Contract/Attribute:provider_id' => 'Poskytovateľ',
	'Class:Contract/Attribute:provider_id+' => '',
	'Class:Contract/Attribute:provider_name' => 'Meno poskytovateľa',
	'Class:Contract/Attribute:provider_name+' => '',
	'Class:Contract/Attribute:status' => 'Stav',
	'Class:Contract/Attribute:status+' => '',
	'Class:Contract/Attribute:status/Value:implementation' => 'Implementácia',
	'Class:Contract/Attribute:status/Value:implementation+' => '',
	'Class:Contract/Attribute:status/Value:obsolete' => 'Vyradený',
	'Class:Contract/Attribute:status/Value:obsolete+' => '',
	'Class:Contract/Attribute:status/Value:production' => 'Produkcia',
	'Class:Contract/Attribute:status/Value:production+' => '',
	'Class:Contract/Attribute:finalclass' => 'Typ',
	'Class:Contract/Attribute:finalclass+' => '',
	'Class:ProviderContract/Attribute:contracttype_id' => 'Typ zmluvy',
	'Class:ProviderContract/Attribute:contracttype_id+' => '',
	'Class:ProviderContract/Attribute:contracttype_name' => 'Názov typu zmluvy',
	'Class:ProviderContract/Attribute:contracttype_name+' => '',
	'Class:lnkContactToContract/Attribute:contract_name' => 'Názov zmluvy',
	'Class:lnkContactToContract/Attribute:contract_name+' => '',
	'Class:lnkContactToContract/Attribute:contact_name' => 'Názov kontaktu',
	'Class:lnkContactToContract/Attribute:contact_name+' => '',
	'Class:lnkContractToDocument/Attribute:contract_name' => 'Názov zmluvy',
	'Class:lnkContractToDocument/Attribute:contract_name+' => '',
	'Class:lnkContractToDocument/Attribute:document_name' => 'Názov dokumentu',
	'Class:lnkContractToDocument/Attribute:document_name+' => '',
	'Class:lnkFunctionalCIToProviderContract/Attribute:providercontract_name' => 'Názov poskytovateľského zmluvy',
	'Class:lnkFunctionalCIToProviderContract/Attribute:providercontract_name+' => '',
	'Class:lnkFunctionalCIToProviderContract/Attribute:functionalci_name' => 'Názov CI',
	'Class:lnkFunctionalCIToProviderContract/Attribute:functionalci_name+' => '',
	'Class:Service/Attribute:organization_name' => 'Meno poskytovateľa',
	'Class:Service/Attribute:organization_name+' => '',
	'Class:Service/Attribute:servicefamily_name' => 'Názov rodiny služieb',
	'Class:Service/Attribute:servicefamily_name+' => '',
	'Class:lnkDocumentToService/Attribute:service_name' => 'Názov služby',
	'Class:lnkDocumentToService/Attribute:service_name+' => '',
	'Class:lnkDocumentToService/Attribute:document_name' => 'Názov dokumentu',
	'Class:lnkDocumentToService/Attribute:document_name+' => '',
	'Class:lnkContactToService/Attribute:service_name' => 'Názov služby',
	'Class:lnkContactToService/Attribute:service_name+' => '',
	'Class:lnkContactToService/Attribute:contact_name' => 'Názov kontaktu',
	'Class:lnkContactToService/Attribute:contact_name+' => '',
	'Class:ServiceSubcategory/Attribute:service_name' => 'Názov služby',
	'Class:ServiceSubcategory/Attribute:service_name+' => '',
	'Class:SLA/Attribute:organization_name' => 'Názov organizácie poskytovateľa',
	'Class:SLA/Attribute:organization_name+' => '',
	'Class:lnkSLAToSLT/Attribute:sla_name' => 'SLA Názov',
	'Class:lnkSLAToSLT/Attribute:sla_name+' => '',
	'Class:lnkSLAToSLT/Attribute:slt_name' => 'SLT Názov',
	'Class:lnkSLAToSLT/Attribute:slt_name+' => '',
	'Class:lnkCustomerContractToService/Attribute:customercontract_name' => 'Názov zákazníckeho zmluvy',
	'Class:lnkCustomerContractToService/Attribute:customercontract_name+' => '',
	'Class:lnkCustomerContractToService/Attribute:service_name' => 'Názov služby',
	'Class:lnkCustomerContractToService/Attribute:service_name+' => '',
	'Class:lnkCustomerContractToService/Attribute:sla_name' => 'SLA Názov',
	'Class:lnkCustomerContractToService/Attribute:sla_name+' => '',
	'Class:lnkProviderContractToService/Attribute:service_name' => 'Názov služby',
	'Class:lnkProviderContractToService/Attribute:service_name+' => '',
	'Class:lnkProviderContractToService/Attribute:providercontract_name' => 'Názov poskytovateľského zmluvy',
	'Class:lnkProviderContractToService/Attribute:providercontract_name+' => '',
	'Class:lnkFunctionalCIToService/Attribute:service_name' => 'Názov služby',
	'Class:lnkFunctionalCIToService/Attribute:service_name+' => '',
	'Class:lnkFunctionalCIToService/Attribute:functionalci_name' => 'Názov CI',
	'Class:lnkFunctionalCIToService/Attribute:functionalci_name+' => '',
	'Class:DeliveryModel/Attribute:organization_name' => 'Názov organizácie',
	'Class:DeliveryModel/Attribute:organization_name+' => '',
	'Class:lnkDeliveryModelToContact/Attribute:deliverymodel_name' => 'Názov typu dodávky',
	'Class:lnkDeliveryModelToContact/Attribute:deliverymodel_name+' => '',
	'Class:lnkDeliveryModelToContact/Attribute:contact_name' => 'Meno kontaktu',
	'Class:lnkDeliveryModelToContact/Attribute:contact_name+' => '',
	'Class:lnkDeliveryModelToContact/Attribute:role_name' => 'Názov role',
	'Class:lnkDeliveryModelToContact/Attribute:role_name+' => '',
	'Class:Ticket/Attribute:org_name' => 'Názov organizácie',
	'Class:Ticket/Attribute:org_name+' => '',
	'Class:Ticket/Attribute:caller_name' => 'Meno volajúceho',
	'Class:Ticket/Attribute:caller_name+' => '',
	'Class:Ticket/Attribute:team_name' => 'Názov tímu',
	'Class:Ticket/Attribute:team_name+' => '',
	'Class:Ticket/Attribute:agent_name' => 'Meno agenta',
	'Class:Ticket/Attribute:agent_name+' => '',
	'Class:lnkContactToTicket/Attribute:ticket_ref' => 'Referencia na Ticket',
	'Class:lnkContactToTicket/Attribute:ticket_ref+' => '',
	'Class:lnkContactToTicket/Attribute:contact_email' => 'Email kontaktu',
	'Class:lnkContactToTicket/Attribute:contact_email+' => '',
	'Class:lnkFunctionalCIToTicket/Attribute:ticket_ref' => 'Referencia na Ticket',
	'Class:lnkFunctionalCIToTicket/Attribute:ticket_ref+' => '',
	'Class:lnkFunctionalCIToTicket/Attribute:functionalci_name' => 'Názov CI',
	'Class:lnkFunctionalCIToTicket/Attribute:functionalci_name+' => '',
	'Class:WorkOrder/Attribute:ticket_ref' => 'Referencia na Ticket',
	'Class:WorkOrder/Attribute:ticket_ref+' => '',
	'Class:WorkOrder/Attribute:team_name' => 'Názov tímu',
	'Class:WorkOrder/Attribute:team_name+' => '',
	'Class:WorkOrder/Attribute:agent_email' => 'Email agenta',
	'Class:WorkOrder/Attribute:agent_email+' => '',
	'Ticket:baseinfo' => 'Všeobecné informácia',
	'Ticket:date' => 'Dátumy',
	'Ticket:contact' => 'Kontakt',
	'Ticket:moreinfo' => 'Viac informácií',
	'Ticket:relation' => 'Vzťahy',
	'Ticket:log' => 'Komunikácie',
	'Ticket:Type' => 'Kvalifikácia',
	'Ticket:support' => 'Podpora',
	'Ticket:resolution' => 'Riešenie',
	'Ticket:SLA' => 'SLA report',
	'WorkOrder:Details' => 'Detaily',
	'WorkOrder:Moreinfo' => 'Viac informácií',
	'Menu:ChangeManagement' => 'Manažment zmien',
	'Menu:Change:Overview' => 'Prehľad',
	'Menu:Change:Overview+' => '',
	'Menu:NewChange' => 'Nová zmena',
	'Menu:NewChange+' => '',
	'Menu:SearchChanges' => 'Vyhľadať zmeny',
	'Menu:SearchChanges+' => '',
	'Menu:Change:Shortcuts' => 'Skratky',
	'Menu:Change:Shortcuts+' => '',
	'Menu:WaitingAcceptance' => 'Zmeny očakávajúce prijatie',
	'Menu:WaitingAcceptance+' => '',
	'Menu:WaitingApproval' => 'Zmeny očakávajúce schválenie',
	'Menu:WaitingApproval+' => '',
	'Menu:Changes' => 'Otvorené zmeny',
	'Menu:Changes+' => '',
	'Menu:MyChanges' => 'Zmeny pridelené mne',
	'Menu:MyChanges+' => '',
	'UI-ChangeManagementOverview-ChangeByCategory-last-7-days' => 'Zmeny podľa kategórie za posledných 7 dní',
	'UI-ChangeManagementOverview-Last-7-days' => 'Počet zmien za posledných 7 dní',
	'UI-ChangeManagementOverview-ChangeByDomain-last-7-days' => 'Zmeny podľa domény za posledných 7 dní',
	'UI-ChangeManagementOverview-ChangeByStatus-last-7-days' => 'Zmeny podľa stavu za posledných 7 dní',
	'Class:Change/Attribute:changemanager_email' => 'Email manažéra zmien',
	'Class:Change/Attribute:changemanager_email+' => '',
	'Class:Change/Attribute:parent_name' => 'Referencia na rodičovskú zmenu',
	'Class:Change/Attribute:parent_name+' => '',
	'Class:Change/Attribute:related_incident_list' => 'Súvisiace incidenty',
	'Class:Change/Attribute:related_incident_list+' => 'All the incidents linked to this change~~',
	'Class:Change/Attribute:related_problems_list' => 'Súvisiace problémy',
	'Class:Change/Attribute:related_problems_list+' => 'All the problems linked to this change~~',
	'Class:Change/Attribute:parent_id_friendlyname' => 'Priateľské meno rodičovskej zmeny',
	'Class:Change/Attribute:parent_id_friendlyname+' => '',
	'Menu:RequestManagement' => 'Helpdesk',
	'Menu:RequestManagement+' => '',
	'Menu:RequestManagementProvider' => 'Poskytovateľ Helpdesku',
	'Menu:RequestManagementProvider+' => '',
	'Menu:UserRequest:Provider' => 'Otvorené požiadavky prenesené na poskytovateľa',
	'Menu:UserRequest:Provider+' => '',
	'Menu:UserRequest:Overview' => 'Prehľad',
	'Menu:UserRequest:Overview+' => '',
	'Menu:NewUserRequest' => 'Nové požiadavky užívateľa',
	'Menu:NewUserRequest+' => '',
	'Menu:SearchUserRequests' => 'Vyhľadať užívateľské požiadavky',
	'Menu:SearchUserRequests+' => '',
	'Menu:UserRequest:Shortcuts' => 'Skratky',
	'Menu:UserRequest:Shortcuts+' => '',
	'Menu:UserRequest:MyRequests' => 'požiadavky pridelené mne',
	'Menu:UserRequest:MyRequests+' => '',
	'Menu:UserRequest:MySupportRequests' => 'Moje hovory podpory',
	'Menu:UserRequest:MySupportRequests+' => '',
	'Menu:UserRequest:EscalatedRequests' => 'Eskalované požiadavky',
	'Menu:UserRequest:EscalatedRequests+' => '',
	'Menu:UserRequest:OpenRequests' => 'Všetky otvorené požiadavky',
	'Menu:UserRequest:OpenRequests+' => '',
	'UI:WelcomeMenu:MyAssignedCalls' => 'požiadavky pridelené mne',
	'UI-RequestManagementOverview-RequestByType-last-14-days' => 'požiadavky za posledných 14 dní (po typoch)',
	'UI-RequestManagementOverview-Last-14-days' => 'požiadavky posledných 14 dní (po dňoch)',
	'UI-RequestManagementOverview-OpenRequestByStatus' => 'Otvorené požiadavky podľa stavu',
	'UI-RequestManagementOverview-OpenRequestByAgent' => 'Otvorené požiadavky podľa agenta',
	'UI-RequestManagementOverview-OpenRequestByType' => 'Otvorené požiadavky podľa typu',
	'UI-RequestManagementOverview-OpenRequestByCustomer' => 'Otvorené požiadavky podľa organizácie',
	'Class:UserRequest:KnownErrorList' => 'Známe chyby',
	'Menu:UserRequest:MyWorkOrders' => 'Pracovné príkazy pridelené mne',
	'Menu:UserRequest:MyWorkOrders+' => '',
	'Class:Problem:KnownProblemList' => 'Známe problémy',
	'Class:UserRequest/Attribute:approver_email' => 'Email schvalovateľa',
	'Class:UserRequest/Attribute:approver_email+' => '',
	'Class:UserRequest/Attribute:service_name' => 'Názov služby',
	'Class:UserRequest/Attribute:service_name+' => '',
	'Class:UserRequest/Attribute:servicesubcategory_name' => 'Názov subkategórie služieb',
	'Class:UserRequest/Attribute:servicesubcategory_name+' => '',
	'Class:UserRequest/Attribute:parent_request_ref' => 'Požiadavka o odporúčanie',
	'Class:UserRequest/Attribute:parent_request_ref+' => '',
	'Class:UserRequest/Attribute:parent_problem_id' => 'Rodičovský problém',
	'Class:UserRequest/Attribute:parent_problem_id+' => '',
	'Class:UserRequest/Attribute:parent_problem_ref' => 'Referencia na problém',
	'Class:UserRequest/Attribute:parent_problem_ref+' => '',
	'Class:UserRequest/Attribute:parent_change_ref' => 'Referencia na zmenu',
	'Class:UserRequest/Attribute:parent_change_ref+' => '',
	'Class:UserRequest/Attribute:parent_request_id_friendlyname' => 'Priateľské meno ID požiadavky rodiča',
	'Class:UserRequest/Attribute:parent_request_id_friendlyname+' => '',
	'Portal:TitleDetailsFor_Request' => 'Detaily pre požiadavky',
	'Portal:ButtonUpdate' => 'Aktualizácia',
	'Portal:ButtonClose' => 'Zatvoriť',
	'Portal:ButtonReopen' => 'Znova otvoriť',
	'Portal:ShowServices' => 'Katalóg služieb',
	'Portal:SelectRequestType' => 'Zvoľ typ požiadavky',
	'Portal:SelectServiceElementFrom_Service' => 'Zvoľ služby prvku pre %1$s',
	'Portal:SelectRequestTemplate' => 'Zvoľ predlohu pre %1$s',
	'Portal:ListServices' => 'Zoznam služieb',
	'Portal:TitleDetailsFor_Service' => 'Detaily pre službu',
	'Portal:Button:CreateRequestFromService' => 'Vytvor Požiadavka pre túto službu',
	'Portal:ListOpenRequests' => 'Vypíš otvorené požiadavky',
	'Portal:UserRequest:MoreInfo' => 'Viac informácií',
	'Portal:Details-Service-Element' => 'Prvky služieb',
	'Portal:NoClosedTicket' => 'Žiadne zatvorené požiadavky',
	'Portal:NoService' => '',
	'Portal:ListOpenProblems' => 'Prebiehajúce problémy',
	'Portal:ShowProblem' => 'Problémy',
	'Portal:ShowFaqs' => 'Často kladené otázky',
	'Portal:NoOpenProblem' => 'Žiadny otvorený problém',
	'Portal:SelectLanguage' => 'Zmeň svoj jazyk',
	'Portal:LanguageChangedTo_Lang' => 'Jazyk zmenený na',
	'Portal:ChooseYourFavoriteLanguage' => 'Vyberte si svoj obľúbený jazyk'
));



